/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(@Nonnull afj input, @Nonnull afj ingredient, @Nonnull afj output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(@Nonnull afj input, @Nonnull String ingredient, @Nonnull afj output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    @Nonnull
    public static afj getOutput(@Nonnull afj input, @Nonnull afj ingredient) {
        if (input.b() || input.d() != 1 || input.E() != 1) {
            return afj.a;
        }
        if (ingredient.b()) {
            return afj.a;
        }
        for (IBrewingRecipe recipe : recipes) {
            afj output = recipe.getOutput(input, ingredient);
            if (output.b()) continue;
            return output;
        }
        return afj.a;
    }

    public static boolean hasOutput(@Nonnull afj input, @Nonnull afj ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).b();
    }

    public static boolean canBrew(dd<afj> inputs, @Nonnull afj ingredient, int[] inputIndexes) {
        if (ingredient.b()) {
            return false;
        }
        for (int i2 : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput(inputs.get(i2), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(dd<afj> inputs, @Nonnull afj ingredient, int[] inputIndexes) {
        for (int i2 : inputIndexes) {
            afj output = BrewingRecipeRegistry.getOutput(inputs.get(i2), ingredient);
            if (output.b()) continue;
            inputs.set(i2, output);
        }
    }

    public static boolean isValidIngredient(@Nonnull afj stack) {
        if (stack.b()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(@Nonnull afj stack) {
        if (stack.d() != 1 || stack.E() != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

