/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.chunkio.QueuedChunk;
import net.minecraftforge.event.world.ChunkDataEvent;

class ChunkIOProvider
implements Runnable {
    private final QueuedChunk chunkInfo;
    private final avd loader;
    private final lv provider;
    private auo chunk;
    private du nbt;
    private final ConcurrentLinkedQueue<Runnable> callbacks = new ConcurrentLinkedQueue();
    private boolean ran = false;

    ChunkIOProvider(QueuedChunk chunk, avd loader, lv provider) {
        this.chunkInfo = chunk;
        this.loader = loader;
        this.provider = provider;
    }

    public void addCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Runnable callback) {
        this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChunkIOProvider chunkIOProvider = this;
        synchronized (chunkIOProvider) {
            Object[] data = null;
            try {
                data = this.loader.loadChunk__Async(this.chunkInfo.world, this.chunkInfo.x, this.chunkInfo.z);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (data != null) {
                this.nbt = (du)data[1];
                this.chunk = (auo)data[0];
            }
            this.ran = true;
            this.notifyAll();
        }
    }

    public void syncCallback() {
        if (this.chunk == null) {
            this.runCallbacks();
            return;
        }
        this.loader.loadEntities(this.chunkInfo.world, this.nbt.o("Level"), this.chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Load(this.chunk, this.nbt));
        this.chunk.b(this.provider.f.P());
        this.provider.c.b(this.chunk, this.chunkInfo.x, this.chunkInfo.z);
        this.provider.e.put(ajl.a(this.chunkInfo.x, this.chunkInfo.z), (Object)this.chunk);
        this.chunk.c();
        this.chunk.a(this.provider, this.provider.c);
        this.runCallbacks();
    }

    public auo getChunk() {
        return this.chunk;
    }

    public boolean runFinished() {
        return this.ran;
    }

    public boolean hasCallback() {
        return this.callbacks.size() > 0;
    }

    public void runCallbacks() {
        for (Runnable r2 : this.callbacks) {
            r2.run();
        }
        this.callbacks.clear();
    }
}

