/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.config.TypeAdapters;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.apache.logging.log4j.Level;

public class ConfigManager {
    private static Map<String, Multimap<Config.Type, ASMDataTable.ASMData>> asm_data = Maps.newHashMap();
    private static Map<Class<?>, ITypeAdapter> ADAPTERS = Maps.newHashMap();
    private static Map<Class<?>, ITypeAdapter.Map> MAP_ADAPTERS = Maps.newHashMap();
    private static Map<String, Configuration> CONFIGS = Maps.newHashMap();
    private static final Joiner NEW_LINE;
    private static final Joiner PIPE;

    private static void register(Class<?> cls, ITypeAdapter adpt) {
        ADAPTERS.put(cls, adpt);
        if (adpt instanceof ITypeAdapter.Map) {
            MAP_ADAPTERS.put(cls, (ITypeAdapter.Map)adpt);
        }
    }

    public static void loadData(ASMDataTable data) {
        FMLLog.fine("Loading @Config anotation data", new Object[0]);
        for (ASMDataTable.ASMData target : data.getAll(Config.class.getName())) {
            ModAnnotation.EnumHolder tholder;
            String modid = (String)target.getAnnotationInfo().get("modid");
            ArrayListMultimap map = asm_data.get(modid);
            if (map == null) {
                map = ArrayListMultimap.create();
                asm_data.put(modid, (Multimap<Config.Type, ASMDataTable.ASMData>)map);
            }
            Config.Type type = (tholder = (ModAnnotation.EnumHolder)target.getAnnotationInfo().get("type")) == null ? Config.Type.INSTANCE : Config.Type.valueOf(tholder.getValue());
            map.put((Object)type, (Object)target);
        }
    }

    public static void load(String modid, Config.Type type) {
        FMLLog.fine("Attempting to inject @Config classes into %s for type %s", new Object[]{modid, type});
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        File configDir = Loader.instance().getConfigDir();
        Multimap<Config.Type, ASMDataTable.ASMData> map = asm_data.get(modid);
        if (map == null) {
            return;
        }
        for (ASMDataTable.ASMData targ : map.get((Object)type)) {
            try {
                File file;
                Configuration cfg;
                Class<?> cls = Class.forName(targ.getClassName(), true, mcl);
                String name = (String)targ.getAnnotationInfo().get("name");
                if (name == null) {
                    name = modid;
                }
                if ((cfg = CONFIGS.get((file = new File(configDir, name + ".cfg")).getAbsolutePath())) == null) {
                    cfg = new Configuration(file);
                    cfg.load();
                    CONFIGS.put(file.getAbsolutePath(), cfg);
                }
                ConfigManager.createConfig(cfg, cls, modid, type == Config.Type.INSTANCE);
                cfg.save();
            }
            catch (Exception e2) {
                FMLLog.log(Level.ERROR, e2, "An error occurred trying to load a config for %s into %s", modid, targ.getClassName());
                throw new LoaderException(e2);
            }
        }
    }

    private static void createConfig(Configuration cfg, Class<?> cls, String modid, boolean isStatic) {
        String category = "general";
        for (Field f2 : cls.getDeclaredFields()) {
            if (!Modifier.isPublic(f2.getModifiers()) || Modifier.isStatic(f2.getModifiers()) != isStatic) continue;
            ConfigManager.createConfig(modid, category, cfg, f2.getType(), f2, null);
        }
    }

    private static void createConfig(String modid, String category, Configuration cfg, Class<?> ftype, Field f2, Object instance) {
        String sub;
        ITypeAdapter adapter;
        Property prop = null;
        String comment = null;
        Config.Comment ca2 = f2.getAnnotation(Config.Comment.class);
        if (ca2 != null) {
            comment = NEW_LINE.join((Object[])ca2.value());
        }
        String langKey = modid + "." + category + "." + f2.getName().toLowerCase(Locale.ENGLISH);
        Config.LangKey la = f2.getAnnotation(Config.LangKey.class);
        if (la != null) {
            langKey = la.value();
        }
        if ((adapter = ADAPTERS.get(ftype)) != null) {
            prop = adapter.getProp(cfg, category, f2, instance, comment);
            ConfigManager.set(instance, f2, adapter.getValue(prop));
        } else if (ftype.getSuperclass() == Enum.class) {
            Enum enu = (Enum)ConfigManager.get(instance, f2);
            prop = cfg.get(category, f2.getName(), enu.name(), comment);
            prop.setValidationPattern(ConfigManager.makePattern(ftype));
            ConfigManager.set(instance, f2, Enum.valueOf(ftype, prop.getString()));
        } else if (ftype == Map.class) {
            sub = category + "." + f2.getName().toLowerCase(Locale.ENGLISH);
            Map m2 = (Map)ConfigManager.get(instance, f2);
            ParameterizedType type = (ParameterizedType)f2.getGenericType();
            Type mtype = type.getActualTypeArguments()[1];
            cfg.getCategory(sub).setComment(comment);
            for (Map.Entry e2 : m2.entrySet()) {
                ITypeAdapter.Map adpt = MAP_ADAPTERS.get(mtype);
                if (adpt != null) {
                    prop = adpt.getProp(cfg, sub, (String)e2.getKey(), e2.getValue());
                } else if (mtype instanceof Class && ((Class)mtype).getSuperclass() == Enum.class) {
                    prop = TypeAdapters.Str.getProp(cfg, sub, (String)e2.getKey(), ((Enum)e2.getValue()).name());
                    prop.setValidationPattern(ConfigManager.makePattern((Class)mtype));
                } else {
                    throw new RuntimeException("Unknown type in map! " + f2.getDeclaringClass() + "/" + f2.getName() + " " + mtype);
                }
                prop.setLanguageKey(langKey + "." + ((String)e2.getKey()).toLowerCase(Locale.ENGLISH));
            }
            prop = null;
        } else if (ftype.getSuperclass() == Object.class) {
            sub = category + "." + f2.getName().toLowerCase(Locale.ENGLISH);
            Object sinst = ConfigManager.get(instance, f2);
            for (Field sf2 : ftype.getDeclaredFields()) {
                if (!Modifier.isPublic(sf2.getModifiers())) continue;
                ConfigManager.createConfig(modid, sub, cfg, sf2.getType(), sf2, sinst);
            }
        } else {
            throw new RuntimeException("Unknown type in config! " + f2.getDeclaringClass() + "/" + f2.getName() + " " + ftype);
        }
        if (prop != null) {
            Config.RangeDouble da2;
            prop.setLanguageKey(langKey);
            Config.RangeInt ia2 = f2.getAnnotation(Config.RangeInt.class);
            if (ia2 != null) {
                prop.setMinValue(ia2.min());
                prop.setMaxValue(ia2.max());
                if (comment != null) {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{comment, "Min: " + ia2.min(), "Max: " + ia2.max()}));
                } else {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{"Min: " + ia2.min(), "Max: " + ia2.max()}));
                }
            }
            if ((da2 = f2.getAnnotation(Config.RangeDouble.class)) != null) {
                prop.setMinValue(da2.min());
                prop.setMaxValue(da2.max());
                if (comment != null) {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{comment, "Min: " + da2.min(), "Max: " + da2.max()}));
                } else {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{"Min: " + da2.min(), "Max: " + da2.max()}));
                }
            }
        }
    }

    private static void set(Object instance, Field f2, Object v2) {
        try {
            f2.set(instance, v2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static Object get(Object instance, Field f2) {
        try {
            return f2.get(instance);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static Pattern makePattern(Class<? extends Enum> cls) {
        ArrayList lst = Lists.newArrayList();
        for (Enum e2 : cls.getEnumConstants()) {
            lst.add(e2.name());
        }
        return Pattern.compile(PIPE.join((Iterable)lst));
    }

    static {
        ConfigManager.register(Boolean.TYPE, TypeAdapters.bool);
        ConfigManager.register(boolean[].class, TypeAdapters.boolA);
        ConfigManager.register(Boolean.class, TypeAdapters.Bool);
        ConfigManager.register(Boolean[].class, TypeAdapters.BoolA);
        ConfigManager.register(Float.TYPE, TypeAdapters.flt);
        ConfigManager.register(float[].class, TypeAdapters.fltA);
        ConfigManager.register(Float.class, TypeAdapters.Flt);
        ConfigManager.register(Float[].class, TypeAdapters.FltA);
        ConfigManager.register(Double.TYPE, TypeAdapters.dbl);
        ConfigManager.register(double[].class, TypeAdapters.dblA);
        ConfigManager.register(Double.class, TypeAdapters.Dbl);
        ConfigManager.register(Double[].class, TypeAdapters.DblA);
        ConfigManager.register(Byte.TYPE, TypeAdapters.byt);
        ConfigManager.register(byte[].class, TypeAdapters.bytA);
        ConfigManager.register(Byte.class, TypeAdapters.Byt);
        ConfigManager.register(Byte[].class, TypeAdapters.BytA);
        ConfigManager.register(Character.TYPE, TypeAdapters.chr);
        ConfigManager.register(char[].class, TypeAdapters.chrA);
        ConfigManager.register(Character.class, TypeAdapters.Chr);
        ConfigManager.register(Character[].class, TypeAdapters.ChrA);
        ConfigManager.register(Short.TYPE, TypeAdapters.shrt);
        ConfigManager.register(short[].class, TypeAdapters.shrtA);
        ConfigManager.register(Short.class, TypeAdapters.Shrt);
        ConfigManager.register(Short[].class, TypeAdapters.ShrtA);
        ConfigManager.register(Integer.TYPE, TypeAdapters.int_);
        ConfigManager.register(int[].class, TypeAdapters.intA);
        ConfigManager.register(Integer.class, TypeAdapters.Int);
        ConfigManager.register(Integer[].class, TypeAdapters.IntA);
        ConfigManager.register(String.class, TypeAdapters.Str);
        ConfigManager.register(String[].class, TypeAdapters.StrA);
        NEW_LINE = Joiner.on((char)'\n');
        PIPE = Joiner.on((char)'|');
    }
}

