/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public final class TRSRTransformation
implements IModelState,
ITransformation {
    private final javax.vecmath.Matrix4f matrix;
    private boolean full;
    private javax.vecmath.Vector3f translation;
    private Quat4f leftRot;
    private javax.vecmath.Vector3f scale;
    private Quat4f rightRot;
    private static final TRSRTransformation identity;
    private static final float eps = 1.0E-6f;
    private static final float g;
    private static final float cs;
    private static final float ss;
    private static final float sq2;
    private static final EnumMap<cv, TRSRTransformation> vanillaUvTransformLocalToGlobal;
    private static final EnumMap<cv, TRSRTransformation> vanillaUvTransformGlobalToLocal;

    public TRSRTransformation(javax.vecmath.Matrix4f matrix) {
        this.matrix = matrix == null ? TRSRTransformation.identity.matrix : matrix;
    }

    public TRSRTransformation(@Nullable javax.vecmath.Vector3f translation, @Nullable Quat4f leftRot, @Nullable javax.vecmath.Vector3f scale, @Nullable Quat4f rightRot) {
        this.matrix = TRSRTransformation.mul(translation, leftRot, scale, rightRot);
        this.translation = translation != null ? translation : new javax.vecmath.Vector3f();
        this.leftRot = leftRot != null ? leftRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = scale != null ? scale : new javax.vecmath.Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRot = rightRot != null ? rightRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.full = true;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(brp transform) {
        this(TRSRTransformation.toVecmath(transform.c), TRSRTransformation.quatFromXYZDegrees(TRSRTransformation.toVecmath(transform.b)), TRSRTransformation.toVecmath(transform.d), null);
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(cbi rotation) {
        this(rotation.getMatrix());
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation(cv facing) {
        this(TRSRTransformation.getMatrix(facing));
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Matrix4f getMatrix(cv facing) {
        switch (facing) {
            case a: {
                return cbi.e.getMatrix();
            }
            case b: {
                return cbi.m.getMatrix();
            }
            case c: {
                return TRSRTransformation.identity.matrix;
            }
            case d: {
                return cbi.c.getMatrix();
            }
            case e: {
                return cbi.d.getMatrix();
            }
            case f: {
                return cbi.b.getMatrix();
            }
        }
        return new javax.vecmath.Matrix4f();
    }

    public static TRSRTransformation identity() {
        return identity;
    }

    public TRSRTransformation compose(TRSRTransformation b2) {
        javax.vecmath.Matrix4f m2 = this.getMatrix();
        m2.mul(b2.getMatrix());
        return new TRSRTransformation(m2);
    }

    public TRSRTransformation inverse() {
        if (this == identity) {
            return this;
        }
        javax.vecmath.Matrix4f m2 = this.getMatrix();
        m2.invert();
        return new TRSRTransformation(m2);
    }

    private void genCheck() {
        if (!this.full) {
            Pair<Matrix3f, javax.vecmath.Vector3f> pair = TRSRTransformation.toAffine(this.matrix);
            Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> triple = TRSRTransformation.svdDecompose((Matrix3f)pair.getLeft());
            this.translation = (javax.vecmath.Vector3f)pair.getRight();
            this.leftRot = (Quat4f)triple.getLeft();
            this.scale = (javax.vecmath.Vector3f)triple.getMiddle();
            this.rightRot = (Quat4f)triple.getRight();
            this.full = true;
        }
    }

    public static Quat4f quatFromYXZ(float y2, float x2, float z2) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t2 = new Quat4f();
        t2.set(0.0f, (float)Math.sin(y2 / 2.0f), 0.0f, (float)Math.cos(y2 / 2.0f));
        ret.mul(t2);
        t2.set((float)Math.sin(x2 / 2.0f), 0.0f, 0.0f, (float)Math.cos(x2 / 2.0f));
        ret.mul(t2);
        t2.set(0.0f, 0.0f, (float)Math.sin(z2 / 2.0f), (float)Math.cos(z2 / 2.0f));
        ret.mul(t2);
        return ret;
    }

    public static Quat4f quatFromXYZDegrees(javax.vecmath.Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ((float)Math.toRadians(xyz.x), (float)Math.toRadians(xyz.y), (float)Math.toRadians(xyz.z));
    }

    public static Quat4f quatFromXYZ(javax.vecmath.Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ(xyz.x, xyz.y, xyz.z);
    }

    public static Quat4f quatFromXYZ(float x2, float y2, float z2) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t2 = new Quat4f();
        t2.set((float)Math.sin(x2 / 2.0f), 0.0f, 0.0f, (float)Math.cos(x2 / 2.0f));
        ret.mul(t2);
        t2.set(0.0f, (float)Math.sin(y2 / 2.0f), 0.0f, (float)Math.cos(y2 / 2.0f));
        ret.mul(t2);
        t2.set(0.0f, 0.0f, (float)Math.sin(z2 / 2.0f), (float)Math.cos(z2 / 2.0f));
        ret.mul(t2);
        return ret;
    }

    public static javax.vecmath.Vector3f toYXZDegrees(Quat4f q2) {
        javax.vecmath.Vector3f yxz = TRSRTransformation.toYXZ(q2);
        return new javax.vecmath.Vector3f((float)Math.toDegrees(yxz.x), (float)Math.toDegrees(yxz.y), (float)Math.toDegrees(yxz.z));
    }

    public static javax.vecmath.Vector3f toYXZ(Quat4f q2) {
        float w2 = q2.w * q2.w;
        float x2 = q2.x * q2.x;
        float y2 = q2.y * q2.y;
        float z2 = q2.z * q2.z;
        float l2 = w2 + x2 + y2 + z2;
        float sx2 = 2.0f * q2.w * q2.x - 2.0f * q2.y * q2.z;
        float x3 = (float)Math.asin(sx2 / l2);
        if (Math.abs(sx2) > 0.999f * l2) {
            return new javax.vecmath.Vector3f(x3, 2.0f * (float)Math.atan2(q2.y, q2.w), 0.0f);
        }
        return new javax.vecmath.Vector3f(x3, (float)Math.atan2(2.0f * q2.x * q2.z + 2.0f * q2.y * q2.w, w2 - x2 - y2 + z2), (float)Math.atan2(2.0f * q2.x * q2.y + 2.0f * q2.w * q2.z, w2 - x2 + y2 - z2));
    }

    public static javax.vecmath.Vector3f toXYZDegrees(Quat4f q2) {
        javax.vecmath.Vector3f xyz = TRSRTransformation.toXYZ(q2);
        return new javax.vecmath.Vector3f((float)Math.toDegrees(xyz.x), (float)Math.toDegrees(xyz.y), (float)Math.toDegrees(xyz.z));
    }

    public static javax.vecmath.Vector3f toXYZ(Quat4f q2) {
        float w2 = q2.w * q2.w;
        float x2 = q2.x * q2.x;
        float y2 = q2.y * q2.y;
        float z2 = q2.z * q2.z;
        float l2 = w2 + x2 + y2 + z2;
        float sy2 = 2.0f * q2.w * q2.x - 2.0f * q2.y * q2.z;
        float y3 = (float)Math.asin(sy2 / l2);
        if (Math.abs(sy2) > 0.999f * l2) {
            return new javax.vecmath.Vector3f(2.0f * (float)Math.atan2(q2.x, q2.w), y3, 0.0f);
        }
        return new javax.vecmath.Vector3f((float)Math.atan2(2.0f * q2.y * q2.z + 2.0f * q2.x * q2.w, w2 - x2 - y2 + z2), y3, (float)Math.atan2(2.0f * q2.x * q2.y + 2.0f * q2.w * q2.z, w2 + x2 - y2 - z2));
    }

    public static javax.vecmath.Matrix4f mul(@Nullable javax.vecmath.Vector3f translation, @Nullable Quat4f leftRot, @Nullable javax.vecmath.Vector3f scale, @Nullable Quat4f rightRot) {
        javax.vecmath.Matrix4f res = new javax.vecmath.Matrix4f();
        javax.vecmath.Matrix4f t2 = new javax.vecmath.Matrix4f();
        res.setIdentity();
        if (leftRot != null) {
            t2.set(leftRot);
            res.mul(t2);
        }
        if (scale != null) {
            t2.setIdentity();
            t2.m00 = scale.x;
            t2.m11 = scale.y;
            t2.m22 = scale.z;
            res.mul(t2);
        }
        if (rightRot != null) {
            t2.set(rightRot);
            res.mul(t2);
        }
        if (translation != null) {
            res.setTranslation(translation);
        }
        return res;
    }

    public static Triple<Quat4f, javax.vecmath.Vector3f, Quat4f> svdDecompose(Matrix3f m2) {
        Quat4f u2 = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f v2 = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f qt2 = new Quat4f();
        Matrix3f b2 = new Matrix3f(m2);
        Matrix3f t2 = new Matrix3f();
        t2.transpose(m2);
        b2.mul(t2, b2);
        for (int i2 = 0; i2 < 5; ++i2) {
            v2.mul(TRSRTransformation.stepJacobi(b2));
        }
        v2.normalize();
        t2.set(v2);
        b2.set(m2);
        b2.mul(t2);
        float ul2 = 1.0f;
        Pair<Float, Float> p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m10);
        qt2.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
        u2.mul(qt2);
        t2.setIdentity();
        t2.m11 = t2.m00 = qt2.w * qt2.w - qt2.z * qt2.z;
        t2.m10 = -2.0f * qt2.z * qt2.w;
        t2.m01 = -t2.m10;
        t2.m22 = qt2.w * qt2.w + qt2.z * qt2.z;
        ul2 *= t2.m22;
        b2.mul(t2, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m00, b2.m20);
        qt2.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
        u2.mul(qt2);
        t2.setIdentity();
        t2.m22 = t2.m00 = qt2.w * qt2.w - qt2.y * qt2.y;
        t2.m20 = 2.0f * qt2.y * qt2.w;
        t2.m02 = -t2.m20;
        t2.m11 = qt2.w * qt2.w + qt2.y * qt2.y;
        ul2 *= t2.m11;
        b2.mul(t2, b2);
        p2 = TRSRTransformation.qrGivensQuat(b2.m11, b2.m21);
        qt2.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
        u2.mul(qt2);
        t2.setIdentity();
        t2.m22 = t2.m11 = qt2.w * qt2.w - qt2.x * qt2.x;
        t2.m21 = -2.0f * qt2.x * qt2.w;
        t2.m12 = -t2.m21;
        t2.m00 = qt2.w * qt2.w + qt2.x * qt2.x;
        ul2 *= t2.m00;
        b2.mul(t2, b2);
        ul2 = 1.0f / ul2;
        u2.scale((float)Math.sqrt(ul2));
        javax.vecmath.Vector3f s2 = new javax.vecmath.Vector3f(b2.m00 * ul2, b2.m11 * ul2, b2.m22 * ul2);
        return Triple.of((Object)u2, (Object)s2, (Object)v2);
    }

    private static float rsqrt(float f2) {
        float f22 = 0.5f * f2;
        int i2 = Float.floatToIntBits(f2);
        i2 = 1597463007 - (i2 >> 1);
        f2 = Float.intBitsToFloat(i2);
        f2 *= 1.5f - f22 * f2 * f2;
        return f2;
    }

    private static Pair<Float, Float> approxGivensQuat(float a11, float a12, float a22) {
        float sh2 = a12;
        float ch2 = 2.0f * (a11 - a22);
        boolean b2 = g * sh2 * sh2 < ch2 * ch2;
        float w2 = TRSRTransformation.rsqrt(sh2 * sh2 + ch2 * ch2);
        ch2 = b2 ? w2 * ch2 : cs;
        sh2 = b2 ? w2 * sh2 : ss;
        return Pair.of((Object)Float.valueOf(sh2), (Object)Float.valueOf(ch2));
    }

    private static final void swapNeg(Matrix3f m2, int i2, int j2) {
        float[] t2 = new float[3];
        m2.getColumn(j2, t2);
        for (int k2 = 0; k2 < 3; ++k2) {
            m2.setElement(k2, j2, -m2.getElement(k2, i2));
        }
        m2.setColumn(i2, t2);
    }

    private static void sortSingularValues(Matrix3f b2, Quat4f v2) {
        float f2;
        float p0 = b2.m00 * b2.m00 + b2.m10 * b2.m10 + b2.m20 * b2.m20;
        float p1 = b2.m01 * b2.m01 + b2.m11 * b2.m11 + b2.m21 * b2.m21;
        float p2 = b2.m02 * b2.m02 + b2.m12 * b2.m12 + b2.m22 * b2.m22;
        Quat4f t2 = new Quat4f();
        if (p0 < p1) {
            TRSRTransformation.swapNeg(b2, 0, 1);
            t2.set(0.0f, 0.0f, sq2, sq2);
            v2.mul(t2);
            f2 = p0;
            p0 = p1;
            p1 = f2;
        }
        if (p0 < p2) {
            TRSRTransformation.swapNeg(b2, 0, 2);
            t2.set(0.0f, sq2, 0.0f, sq2);
            v2.mul(t2);
            f2 = p0;
            p0 = p2;
            p2 = f2;
        }
        if (p1 < p2) {
            TRSRTransformation.swapNeg(b2, 1, 2);
            t2.set(sq2, 0.0f, 0.0f, sq2);
            v2.mul(t2);
        }
    }

    private static Pair<Float, Float> qrGivensQuat(float a1, float a2) {
        float p2 = (float)Math.sqrt(a1 * a1 + a2 * a2);
        float sh2 = p2 > 1.0E-6f ? a2 : 0.0f;
        float ch2 = Math.abs(a1) + Math.max(p2, 1.0E-6f);
        if (a1 < 0.0f) {
            float f2 = sh2;
            sh2 = ch2;
            ch2 = f2;
        }
        float w2 = TRSRTransformation.rsqrt(ch2 * ch2 + sh2 * sh2);
        return Pair.of((Object)Float.valueOf(sh2 *= w2), (Object)Float.valueOf(ch2 *= w2));
    }

    private static Quat4f stepJacobi(Matrix3f m2) {
        Pair<Float, Float> p2;
        Matrix3f t2 = new Matrix3f();
        Quat4f qt2 = new Quat4f();
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        if (m2.m01 * m2.m01 + m2.m10 * m2.m10 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m00, 0.5f * (m2.m01 + m2.m10), m2.m11);
            qt2.set(0.0f, 0.0f, ((Float)p2.getLeft()).floatValue(), ((Float)p2.getRight()).floatValue());
            ret.mul(qt2);
            t2.setIdentity();
            t2.m11 = t2.m00 = qt2.w * qt2.w - qt2.z * qt2.z;
            t2.m10 = 2.0f * qt2.z * qt2.w;
            t2.m01 = -t2.m10;
            t2.m22 = qt2.w * qt2.w + qt2.z * qt2.z;
            m2.mul(m2, t2);
            t2.transpose();
            m2.mul(t2, m2);
        }
        if (m2.m02 * m2.m02 + m2.m20 * m2.m20 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m00, 0.5f * (m2.m02 + m2.m20), m2.m22);
            qt2.set(0.0f, -((Float)p2.getLeft()).floatValue(), 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt2);
            t2.setIdentity();
            t2.m22 = t2.m00 = qt2.w * qt2.w - qt2.y * qt2.y;
            t2.m20 = -2.0f * qt2.y * qt2.w;
            t2.m02 = -t2.m20;
            t2.m11 = qt2.w * qt2.w + qt2.y * qt2.y;
            m2.mul(m2, t2);
            t2.transpose();
            m2.mul(t2, m2);
        }
        if (m2.m12 * m2.m12 + m2.m21 * m2.m21 > 1.0E-6f) {
            p2 = TRSRTransformation.approxGivensQuat(m2.m11, 0.5f * (m2.m12 + m2.m21), m2.m22);
            qt2.set(((Float)p2.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p2.getRight()).floatValue());
            ret.mul(qt2);
            t2.setIdentity();
            t2.m22 = t2.m11 = qt2.w * qt2.w - qt2.x * qt2.x;
            t2.m21 = 2.0f * qt2.x * qt2.w;
            t2.m12 = -t2.m21;
            t2.m00 = qt2.w * qt2.w + qt2.x * qt2.x;
            m2.mul(m2, t2);
            t2.transpose();
            m2.mul(t2, m2);
        }
        return ret;
    }

    public static Pair<Matrix3f, javax.vecmath.Vector3f> toAffine(javax.vecmath.Matrix4f m2) {
        m2.mul(1.0f / m2.m33);
        javax.vecmath.Vector3f trans = new javax.vecmath.Vector3f(m2.m03, m2.m13, m2.m23);
        Matrix3f linear = new Matrix3f(m2.m00, m2.m01, m2.m02, m2.m10, m2.m11, m2.m12, m2.m20, m2.m21, m2.m22);
        return Pair.of((Object)linear, (Object)trans);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public brp toItemTransform() {
        return new brp(TRSRTransformation.toLwjgl(TRSRTransformation.toXYZDegrees(this.getLeftRot())), TRSRTransformation.toLwjgl(this.getTranslation()), TRSRTransformation.toLwjgl(this.getScale()));
    }

    @Override
    public javax.vecmath.Matrix4f getMatrix() {
        return (javax.vecmath.Matrix4f)this.matrix.clone();
    }

    public javax.vecmath.Vector3f getTranslation() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.translation.clone();
    }

    public Quat4f getLeftRot() {
        this.genCheck();
        return (Quat4f)this.leftRot.clone();
    }

    public javax.vecmath.Vector3f getScale() {
        this.genCheck();
        return (javax.vecmath.Vector3f)this.scale.clone();
    }

    public Quat4f getRightRot() {
        this.genCheck();
        return (Quat4f)this.rightRot.clone();
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)this);
    }

    @Override
    public cv rotate(cv facing) {
        return TRSRTransformation.rotate(this.matrix, facing);
    }

    public static cv rotate(javax.vecmath.Matrix4f matrix, cv facing) {
        dl dir = facing.n();
        Vector4f vec = new Vector4f((float)dir.p(), (float)dir.q(), (float)dir.r(), 0.0f);
        matrix.transform((Tuple4f)vec);
        return cv.a(vec.x, vec.y, vec.z);
    }

    public static boolean isInteger(javax.vecmath.Matrix4f matrix) {
        javax.vecmath.Matrix4f m2 = new javax.vecmath.Matrix4f();
        m2.setIdentity();
        m2.m32 = 1.0f;
        m2.m31 = 1.0f;
        m2.m30 = 1.0f;
        m2.m33 = 0.0f;
        m2.mul(matrix, m2);
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 3; ++j2) {
                float v2 = m2.getElement(i2, j2) / m2.getElement(3, j2);
                if (!((double)Math.abs(v2 - (float)Math.round(v2)) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rotate(cv facing, int vertexIndex) {
        return vertexIndex;
    }

    public String toString() {
        this.genCheck();
        return Objects.toStringHelper(this.getClass()).add("matrix", (Object)this.matrix).add("translation", (Object)this.translation).add("leftRot", (Object)this.leftRot).add("scale", (Object)this.scale).add("rightRot", (Object)this.rightRot).toString();
    }

    public static TRSRTransformation blockCenterToCorner(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public static TRSRTransformation blockCornerToCenter(TRSRTransformation transform) {
        javax.vecmath.Matrix4f ret = new javax.vecmath.Matrix4f(transform.getMatrix());
        javax.vecmath.Matrix4f tmp = new javax.vecmath.Matrix4f();
        tmp.setIdentity();
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRSRTransformation other = (TRSRTransformation)obj;
        return !(this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix));
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Vector3f toVecmath(Vector3f vec) {
        return new javax.vecmath.Vector3f(vec.x, vec.y, vec.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector4f toVecmath(org.lwjgl.util.vector.Vector4f vec) {
        return new Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    @SideOnly(value=Side.CLIENT)
    public static javax.vecmath.Matrix4f toVecmath(Matrix4f m2) {
        return new javax.vecmath.Matrix4f(m2.m00, m2.m10, m2.m20, m2.m30, m2.m01, m2.m11, m2.m21, m2.m31, m2.m02, m2.m12, m2.m22, m2.m32, m2.m03, m2.m13, m2.m23, m2.m33);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector3f toLwjgl(javax.vecmath.Vector3f vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static org.lwjgl.util.vector.Vector4f toLwjgl(Vector4f vec) {
        return new org.lwjgl.util.vector.Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    @SideOnly(value=Side.CLIENT)
    public static Matrix4f toLwjgl(javax.vecmath.Matrix4f m2) {
        Matrix4f r2 = new Matrix4f();
        r2.m00 = m2.m00;
        r2.m01 = m2.m10;
        r2.m02 = m2.m20;
        r2.m03 = m2.m30;
        r2.m10 = m2.m01;
        r2.m11 = m2.m11;
        r2.m12 = m2.m21;
        r2.m13 = m2.m31;
        r2.m20 = m2.m02;
        r2.m21 = m2.m12;
        r2.m22 = m2.m22;
        r2.m23 = m2.m32;
        r2.m30 = m2.m03;
        r2.m31 = m2.m13;
        r2.m32 = m2.m23;
        r2.m33 = m2.m33;
        return r2;
    }

    public static javax.vecmath.Vector3f lerp(Tuple3f from, Tuple3f to2, float progress) {
        javax.vecmath.Vector3f res = new javax.vecmath.Vector3f(from);
        res.interpolate(from, to2, progress);
        return res;
    }

    public static Vector4f lerp(Tuple4f from, Tuple4f to2, float progress) {
        Vector4f res = new Vector4f(from);
        res.interpolate(from, to2, progress);
        return res;
    }

    public static Quat4f slerp(Quat4f from, Quat4f to2, float progress) {
        Quat4f res = new Quat4f();
        res.interpolate(from, to2, progress);
        return res;
    }

    public TRSRTransformation slerp(TRSRTransformation that, float progress) {
        return new TRSRTransformation(TRSRTransformation.lerp((Tuple3f)this.getTranslation(), (Tuple3f)that.getTranslation(), progress), TRSRTransformation.slerp(this.getLeftRot(), that.getLeftRot(), progress), TRSRTransformation.lerp((Tuple3f)this.getScale(), (Tuple3f)that.getScale(), progress), TRSRTransformation.slerp(this.getRightRot(), that.getRightRot(), progress));
    }

    public static TRSRTransformation getVanillaUvTransformLocalToGlobal(cv side) {
        return vanillaUvTransformLocalToGlobal.get(side);
    }

    public static TRSRTransformation getVanillaUvTransformGlobalToLocal(cv side) {
        return vanillaUvTransformGlobalToLocal.get(side);
    }

    public TRSRTransformation getUVLockTransform(cv originalSide) {
        cv newSide = this.rotate(originalSide);
        try {
            return TRSRTransformation.blockCenterToCorner(vanillaUvTransformGlobalToLocal.get(originalSide).compose(TRSRTransformation.blockCornerToCenter(this.inverse())).compose(vanillaUvTransformLocalToGlobal.get(newSide)));
        }
        catch (SingularMatrixException e2) {
            return new TRSRTransformation(null, null, new javax.vecmath.Vector3f(0.0f, 0.0f, 0.0f), null);
        }
    }

    static {
        javax.vecmath.Matrix4f m2 = new javax.vecmath.Matrix4f();
        m2.setIdentity();
        identity = new TRSRTransformation(m2);
        identity.getLeftRot();
        g = 3.0f + 2.0f * (float)Math.sqrt(2.0);
        cs = (float)Math.cos(0.39269908169872414);
        ss = (float)Math.sin(0.39269908169872414);
        sq2 = 1.0f / (float)Math.sqrt(2.0);
        vanillaUvTransformLocalToGlobal = Maps.newEnumMap(cv.class);
        vanillaUvTransformGlobalToLocal = Maps.newEnumMap(cv.class);
        vanillaUvTransformLocalToGlobal.put(cv.d, identity);
        Quat4f tmp = new Quat4f();
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.f, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.e, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(180.0)));
        vanillaUvTransformLocalToGlobal.put(cv.c, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.b, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(cv.a, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        for (cv side : cv.values()) {
            vanillaUvTransformGlobalToLocal.put(side, vanillaUvTransformLocalToGlobal.get(side).inverse());
        }
    }
}

