/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockState
extends atm {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public ExtendedBlockState(alu blockIn, aub<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, ExtendedBlockState.buildUnlistedMap(unlistedProperties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    public Collection<IUnlistedProperty<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p2 : unlistedProperties) {
            builder.put(p2, (Object)Optional.absent());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    protected atm.a createState(@Nonnull alu block, @Nonnull ImmutableMap<aub<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        if (unlistedProperties == null || unlistedProperties.isEmpty()) {
            return super.createState(block, properties, unlistedProperties);
        }
        return new ExtendedStateImplementation(block, properties, unlistedProperties, null);
    }

    protected static class ExtendedStateImplementation
    extends atm.a
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private Map<Map<aub<?>, Comparable<?>>, atm.a> normalMap;

        protected ExtendedStateImplementation(alu block, ImmutableMap<aub<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<aub<?>, Comparable<?>, atl> table) {
            super(block, properties);
            this.unlistedProperties = unlistedProperties;
            this.c = table;
        }

        @Override
        @Nonnull
        public <T extends Comparable<T>, V extends T> atl a(@Nonnull aub<T> property, @Nonnull V value) {
            if (!this.u().containsKey(property)) {
                throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.v().s());
            }
            if (!property.c().contains(value)) {
                throw new IllegalArgumentException("Cannot set property " + property + " to " + value + " on block " + alu.h.b(this.v()) + ", it is not an allowed value");
            }
            if (this.u().get(property) == value) {
                return this;
            }
            HashMap map = Maps.newHashMap(this.u());
            map.put(property, value);
            if (Iterables.all((Iterable)this.unlistedProperties.values(), (Predicate)Predicates.equalTo((Object)Optional.absent()))) {
                return this.normalMap.get(map);
            }
            ImmutableTable<aub<?>, Comparable<?>, atl> table = this.c;
            table = ((atm.a)table.get(property, value)).getPropertyValueTable();
            return new ExtendedStateImplementation(this.v(), ImmutableMap.copyOf((Map)map), this.unlistedProperties, table).setMap(this.normalMap);
        }

        @Override
        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.v().s());
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + alu.h.b(this.v()) + ", it is not an allowed value");
            }
            HashMap newMap = new HashMap((Map<IUnlistedProperty<?>, Optional<?>>)this.unlistedProperties);
            newMap.put(property, Optional.fromNullable(value));
            if (Iterables.all(newMap.values(), (Predicate)Predicates.equalTo((Object)Optional.absent()))) {
                return (IExtendedBlockState)((Object)this.normalMap.get(this.u()));
            }
            return new ExtendedStateImplementation(this.v(), this.u(), ImmutableMap.copyOf(newMap), this.c).setMap(this.normalMap);
        }

        @Override
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
        }

        @Override
        public <V> V getValue(IUnlistedProperty<V> property) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.v().s());
            }
            return property.getType().cast(((Optional)this.unlistedProperties.get(property)).orNull());
        }

        @Override
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        @Override
        public void a(Map<Map<aub<?>, Comparable<?>>, atm.a> map) {
            this.normalMap = map;
            super.a(map);
        }

        private ExtendedStateImplementation setMap(Map<Map<aub<?>, Comparable<?>>, atm.a> map) {
            this.normalMap = map;
            return this;
        }

        @Override
        public atl getClean() {
            return this.normalMap.get(this.u());
        }
    }
}

