/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final co pos;
    private final int dimId;
    private transient atl replacedBlock;
    private int flag;
    @Nullable
    private final du nbt;
    private transient ajs world;
    private final kq registryName;
    private final int meta;

    public BlockSnapshot(ajs world, co pos, atl state) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos;
        this.setReplacedBlock(state);
        this.registryName = state.v().getRegistryName();
        this.meta = state.v().e(state);
        this.setFlag(3);
        asc te2 = world.r(pos);
        if (te2 != null) {
            this.nbt = new du();
            te2.b(this.getNbt());
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(ajs world, co pos, atl state, @Nullable du nbt) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos.h();
        this.setReplacedBlock(state);
        this.registryName = state.v().getRegistryName();
        this.meta = state.v().e(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(ajs world, co pos, atl state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, co pos, String modId, String blockName, int meta, int flag, @Nullable du nbt) {
        this.dimId = dimension;
        this.pos = pos.h();
        this.setFlag(flag);
        this.registryName = new kq(modId, blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(ajs world, co pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(ajs world, co pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(du tag) {
        du nbt = tag.p("hasTE") ? null : tag.o("tileEntity");
        return new BlockSnapshot(tag.h("dimension"), new co(tag.h("posX"), tag.h("posY"), tag.h("posZ")), tag.l("blockMod"), tag.l("blockName"), tag.h("metadata"), tag.h("flag"), nbt);
    }

    public atl getCurrentBlock() {
        return this.getWorld().o(this.getPos());
    }

    public ajs getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.getDimId());
        }
        return this.world;
    }

    public atl getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = ForgeRegistries.BLOCKS.getValue(this.getRegistryName()).a(this.getMeta());
        }
        return this.replacedBlock;
    }

    public asc getTileEntity() {
        if (this.getNbt() != null) {
            return asc.a(this.getWorld(), this.getNbt());
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        atl current = this.getCurrentBlock();
        atl replaced = this.getReplacedBlock();
        if (current.v() != replaced.v() || current.v().e(current) != replaced.v().e(replaced)) {
            if (force) {
                this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
        this.getWorld().a(this.getPos(), current, replaced, applyPhysics ? 3 : 2);
        asc te2 = null;
        if (this.getNbt() != null && (te2 = this.getWorld().r(this.getPos())) != null) {
            te2.a(this.getNbt());
            te2.x_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.getWorld().T().j(), this.getPos().p(), this.getPos().q(), this.getPos().r(), replaced.v().e(replaced), replaced.v().delegate.name(), te2, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(ajs world, co pos, boolean force, boolean applyPhysics) {
        atl current = this.getCurrentBlock();
        atl replaced = this.getReplacedBlock();
        if (current.v() != replaced.v() || current.v().e(current) != replaced.v().e(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.a(pos, current, replaced, applyPhysics ? 3 : 2);
        asc te2 = null;
        if (this.getNbt() != null && (te2 = world.r(pos)) != null) {
            te2.a(this.getNbt());
            te2.x_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.T().j(), pos.p(), pos.q(), pos.r(), replaced.v().e(replaced), replaced.v().delegate.name(), te2, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(du compound) {
        compound.a("blockMod", this.getRegistryName().b());
        compound.a("blockName", this.getRegistryName().a());
        compound.a("posX", this.getPos().p());
        compound.a("posY", this.getPos().q());
        compound.a("posZ", this.getPos().r());
        compound.a("flag", this.getFlag());
        compound.a("dimension", this.getDimId());
        compound.a("metadata", this.getMeta());
        compound.a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.a("tileEntity", this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.getPos().equals(other.getPos())) {
            return false;
        }
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!(this.getNbt() == other.getNbt() || this.getNbt() != null && this.getNbt().equals(other.getNbt()))) {
            return false;
        }
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return this.getRegistryName() == other.getRegistryName() || this.getRegistryName() != null && this.getRegistryName().equals(other.getRegistryName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getPos().p();
        hash = 73 * hash + this.getPos().q();
        hash = 73 * hash + this.getPos().r();
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + (this.getNbt() != null ? this.getNbt().hashCode() : 0);
        hash = 73 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        hash = 73 * hash + (this.getRegistryName() != null ? this.getRegistryName().hashCode() : 0);
        return hash;
    }

    public co getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(atl replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public du getNbt() {
        return this.nbt;
    }

    public void setWorld(ajs world) {
        this.world = world;
    }

    public kq getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

