/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.util.FakePlayer;

public class FakePlayerFactory {
    private static GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    private static Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();
    private static WeakReference<FakePlayer> MINECRAFT_PLAYER = null;

    public static FakePlayer getMinecraft(lw world) {
        FakePlayer ret;
        FakePlayer fakePlayer = ret = MINECRAFT_PLAYER != null ? (FakePlayer)MINECRAFT_PLAYER.get() : null;
        if (ret == null) {
            ret = FakePlayerFactory.get(world, MINECRAFT);
            MINECRAFT_PLAYER = new WeakReference<FakePlayer>(ret);
        }
        return ret;
    }

    public static FakePlayer get(lw world, GameProfile username) {
        if (!fakePlayers.containsKey(username)) {
            FakePlayer fakePlayer = new FakePlayer(world, username);
            fakePlayers.put(username, fakePlayer);
        }
        return fakePlayers.get(username);
    }

    public static void unloadWorld(lw world) {
        Iterator<Map.Entry<GameProfile, FakePlayer>> itr = fakePlayers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<GameProfile, FakePlayer> entry = itr.next();
            if (entry.getValue().l != world) continue;
            itr.remove();
        }
    }
}

