/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static <E> TypeToken<List<E>> listOf(Type arg2) {
        return new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)arg2));
    }

    private static <E> TypeToken<Map<String, E>> mapOf(Type arg2) {
        return new TypeToken<Map<String, E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of((Type)arg2));
    }

    public static enum ImmutableMapTypeAdapter implements JsonDeserializer<ImmutableMap<String, ?>>,
    JsonSerializer<ImmutableMap<String, ?>>
    {
        INSTANCE;


        public ImmutableMap<String, ?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = JsonUtils.mapOf(typeArguments[1]).getType();
            Map map = (Map)context.deserialize(json, parameterizedType);
            return ImmutableMap.copyOf((Map)map);
        }

        public JsonElement serialize(ImmutableMap<String, ?> src, Type type, JsonSerializationContext context) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = JsonUtils.mapOf(typeArguments[1]).getType();
            return context.serialize(src, parameterizedType);
        }
    }

    public static enum ImmutableListTypeAdapter implements JsonDeserializer<ImmutableList<?>>,
    JsonSerializer<ImmutableList<?>>
    {
        INSTANCE;


        public ImmutableList<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parametrizedType = JsonUtils.listOf(typeArguments[0]).getType();
            List list = (List)context.deserialize(json, parametrizedType);
            return ImmutableList.copyOf((Collection)list);
        }

        public JsonElement serialize(ImmutableList<?> src, Type type, JsonSerializationContext context) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parametrizedType = JsonUtils.listOf(typeArguments[0]).getType();
            return context.serialize(src, parametrizedType);
        }
    }
}

