/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final ajs world;
    private final co pos;
    private final atl state;

    public BlockEvent(ajs world, co pos, atl state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public ajs getWorld() {
        return this.world;
    }

    public co getPos() {
        return this.pos;
    }

    public atl getState() {
        return this.state;
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(ajs world, co pos, atl state) {
            super(world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final atl originalState;

            public Post(ajs world, co pos, atl original, atl state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public atl getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(ajs world, co pos, atl state) {
                super(world, pos, state);
            }
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(ajs world, co pos, atl state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<cv> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(ajs world, co pos, atl state, EnumSet<cv> notifiedSides, boolean forceRedstoneUpdate) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<cv> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        @Deprecated
        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, atl placedAgainst, aay player) {
            this(blockSnapshots, placedAgainst, player, ri.a);
        }

        public MultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull atl placedAgainst, @Nonnull aay player, @Nonnull ri hand) {
            super(blockSnapshots.get(0), placedAgainst, player, hand);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, player.b(hand), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final aay player;
        private final BlockSnapshot blockSnapshot;
        private final atl placedBlock;
        private final atl placedAgainst;
        private final ri hand;

        @Deprecated
        public PlaceEvent(BlockSnapshot blockSnapshot, atl placedAgainst, aay player) {
            this(blockSnapshot, placedAgainst, player, ri.a);
        }

        public PlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull atl placedAgainst, @Nonnull aay player, @Nonnull ri hand) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            this.hand = hand;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ][Hand: %s]\n", new Object[]{this.getPlacedBlock(), placedAgainst, player.b(hand), player, hand});
            }
        }

        public aay getPlayer() {
            return this.player;
        }

        @Nonnull
        @Deprecated
        public afj getItemInHand() {
            return this.player.b(this.hand);
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public atl getPlacedBlock() {
            return this.placedBlock;
        }

        public atl getPlacedAgainst() {
            return this.placedAgainst;
        }

        public ri getHand() {
            return this.hand;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final aay player;
        private int exp;

        public BreakEvent(ajs world, co pos, atl state, aay player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.v(), player, world, pos) || state.v().canSilkHarvest(world, pos, world.o(pos), player) && aik.a(aim.t, player.cg()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = aik.a(aim.v, player.cg());
                this.exp = state.v().getExpDrop(state, world, pos, bonusLevel);
            }
        }

        public aay getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<afj> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final aay harvester;

        public HarvestDropsEvent(ajs world, co pos, atl state, int fortuneLevel, float dropChance, List<afj> drops, aay harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<afj> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public aay getHarvester() {
            return this.harvester;
        }
    }
}

