/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.templates;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerItemStack
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final String FLUID_NBT_KEY = "Fluid";
    @Nonnull
    protected afj container;
    protected int capacity;

    public FluidHandlerItemStack(@Nonnull afj container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    @Override
    @Nonnull
    public afj getContainer() {
        return this.container;
    }

    @Nullable
    public FluidStack getFluid() {
        du tagCompound = this.container.p();
        if (tagCompound == null || !tagCompound.e(FLUID_NBT_KEY)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT(tagCompound.o(FLUID_NBT_KEY));
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.o()) {
            this.container.b(new du());
        }
        du fluidTag = new du();
        fluid.writeToNBT(fluidTag);
        this.container.p().a(FLUID_NBT_KEY, fluidTag);
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.E() != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            int fillAmount = Math.min(this.capacity, resource.amount);
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.capacity - contained.amount, resource.amount);
            if (doFill && fillAmount > 0) {
                contained.amount += fillAmount;
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.E() != 1 || resource == null || resource.amount <= 0 || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.E() != 1 || maxDrain <= 0) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
            return null;
        }
        int drainAmount = Math.min(contained.amount, maxDrain);
        FluidStack drained = contained.copy();
        drained.amount = drainAmount;
        if (doDrain) {
            contained.amount -= drainAmount;
            if (contained.amount == 0) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return true;
    }

    protected void setContainerToEmpty() {
        this.container.p().q(FLUID_NBT_KEY);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable cv facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable cv facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public static class SwapEmpty
    extends FluidHandlerItemStack {
        protected final afj emptyContainer;

        public SwapEmpty(afj container, afj emptyContainer, int capacity) {
            super(container, capacity);
            this.emptyContainer = emptyContainer;
        }

        @Override
        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container = this.emptyContainer;
        }
    }

    public static class Consumable
    extends FluidHandlerItemStack {
        public Consumable(afj container, int capacity) {
            super(container, capacity);
        }

        @Override
        protected void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container.g(1);
        }
    }
}

