/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.ExtendedServerListData;
import net.minecraftforge.fml.client.GuiAccessDenied;
import net.minecraftforge.fml.client.GuiConfirmation;
import net.minecraftforge.fml.client.GuiCustomModLoadingErrorScreen;
import net.minecraftforge.fml.client.GuiDupesFound;
import net.minecraftforge.fml.client.GuiJava8Error;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiModsMissing;
import net.minecraftforge.fml.client.GuiNotification;
import net.minecraftforge.fml.client.GuiOldSaveLoadConfirm;
import net.minecraftforge.fml.client.GuiSortingProblem;
import net.minecraftforge.fml.client.GuiWrongMinecraft;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.DuplicateModsFoundException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainerHolder;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Java8VersionException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.toposort.ModSortingException;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private bes client;
    private DummyModContainer optifineContainer;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading = true;
    private Java8VersionException j8onlymods;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;
    private List<caa> resourcePackList;
    private cap metaSerializer;
    private Map<String, caa> resourcePackMap;
    private BiMap<ModContainer, IModGuiFactory> guiFactories;
    private Map<kf, JsonObject> extraServerListData;
    private Map<bnt, ExtendedServerListData> serverDataTag;
    private WeakReference<bno> currentPlayClient;
    private static final kq iconSheet = new kq("fml:textures/gui/icons.png");
    private static final CountDownLatch startupConnectionData = new CountDownLatch(1);
    private SetMultimap<String, kq> missingTextures = HashMultimap.create();
    private Set<String> badTextureDomains = Sets.newHashSet();
    private Table<String, String, Set<kq>> brokenTextures = HashBasedTable.create();
    private static final String ALLOWED_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMinecraftLoading(bes minecraft, List<caa> resourcePackList, bzw resourceManager, cap metaSerializer) {
        this.detectOptifine();
        SplashProgress.start();
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.metaSerializer = metaSerializer;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.u()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        List<String> injectedModContainers = FMLCommonHandler.instance().beginLoading(this);
        try {
            Loader.instance().loadMods(injectedModContainers);
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (Java8VersionException j8mods) {
            this.j8onlymods = j8mods;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
        finally {
            this.client.f();
        }
        try {
            Loader.instance().preinitializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le3) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le3);
            return;
        }
        Map sharedModList = (Map)Launch.blackboard.get("modList");
        if (sharedModList == null) {
            sharedModList = Maps.newHashMap();
            Launch.blackboard.put("modList", sharedModList);
        }
        for (ModContainer mc2 : Loader.instance().getActiveModList()) {
            Map<String, String> sharedModDescriptor = mc2.getSharedModDescriptor();
            if (sharedModDescriptor == null) continue;
            String sharedModId = "fml:" + mc2.getModId();
            sharedModList.put(sharedModId, sharedModDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectOptifine() {
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            InputStream optifineModInfoInputStream = this.getClass().getResourceAsStream("optifinemod.info");
            try {
                ModMetadata optifineMetadata = MetadataCollection.from(optifineModInfoInputStream, "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
                this.optifineContainer = new DummyModContainer(optifineMetadata);
                FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
            }
            finally {
                IOUtils.closeQuietly((InputStream)optifineModInfoInputStream);
            }
        }
        catch (Exception e2) {
            this.optifineContainer = null;
        }
    }

    @Override
    public void haltGame(String message, Throwable t2) {
        SplashProgress.finish();
        this.client.c(new b(message, t2));
        throw Throwables.propagate((Throwable)t2);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null || this.j8onlymods != null) {
            SplashProgress.finish();
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            SplashProgress.finish();
            return;
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
        this.client.f();
        RenderingRegistry.loadEntityRenderers(bes.z().ac().k);
        this.guiFactories = HashBiMap.create();
        for (ModContainer mc2 : Loader.instance().getActiveModList()) {
            String className = mc2.getGuiClassName();
            if (Strings.isNullOrEmpty((String)className)) continue;
            try {
                Class<?> clazz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Class<IModGuiFactory> guiClassFactory = clazz.asSubclass(IModGuiFactory.class);
                IModGuiFactory guiFactory = guiClassFactory.newInstance();
                guiFactory.initialize(this.client);
                this.guiFactories.put((Object)mc2, (Object)guiFactory);
            }
            catch (Exception e2) {
                FMLLog.log(Level.ERROR, e2, "A critical error occurred instantiating the gui factory for mod %s", mc2.getModId());
            }
        }
        this.loading = false;
        this.client.u.a();
        Loader.instance().loadingComplete();
        SplashProgress.finish();
    }

    public void extendModList() {
        Map modList = (Map)Launch.blackboard.get("modList");
        if (modList != null) {
            for (Map.Entry modEntry : modList.entrySet()) {
                String sharedModId = (String)modEntry.getKey();
                String system = sharedModId.split(":")[0];
                if (!"fml".equals(system)) continue;
            }
        }
    }

    public void onInitializationComplete() {
        bqg.z();
        bqg.y();
        if (this.wrongMC != null) {
            this.showGuiScreen(new GuiWrongMinecraft(this.wrongMC));
        } else if (this.j8onlymods != null) {
            this.showGuiScreen(new GuiJava8Error(this.j8onlymods));
        } else if (this.modsMissing != null) {
            this.showGuiScreen(new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.showGuiScreen(new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.showGuiScreen(new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.showGuiScreen(new GuiCustomModLoadingErrorScreen(this.customError));
        } else {
            this.logMissingTextureErrors();
            if (!Loader.instance().java8 && new Date().getTime() >= ForgeModContainer.java8Reminder + 86400000L) {
                this.showGuiScreen(new GuiJava8Error(new Java8VersionException(Collections.<ModContainer>emptyList())));
                ForgeModContainer.updateNag();
            }
        }
    }

    public bes getClient() {
        return this.client;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(aay player, bho gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(@Nullable Object clientGuiElement) {
        bho gui = (bho)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            this.client.a(new GuiNotification(query));
        } else {
            this.client.a(new GuiConfirmation(query));
        }
        if (query.isSynchronous()) {
            while (this.client.m instanceof GuiNotification) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.client.n.c("");
                Thread.sleep(50L);
            }
            this.client.n.c("");
        }
    }

    public boolean handleLoadingScreen(bfk scaledResolution) throws IOException {
        if (this.client.m instanceof GuiNotification) {
            int width = scaledResolution.a();
            int height = scaledResolution.b();
            int mouseX = Mouse.getX() * width / this.client.d;
            int mouseZ = height - Mouse.getY() * height / this.client.e - 1;
            this.client.m.a(mouseX, mouseZ, 0.0f);
            this.client.m.p();
            return true;
        }
        return false;
    }

    public bnq getWorldClient() {
        return this.client.f;
    }

    public bps getClientPlayerEntity() {
        return this.client.h;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public File getSavesDirectory() {
        return ((bbu)this.client.g()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.F();
    }

    public void displayMissingMods(Object modMissingPacket) {
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    public boolean isGUIOpen(Class<? extends bho> gui) {
        return this.client.m != null && this.client.m.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                caa pack = (caa)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                cba meta = (cba)pack.a(this.metaSerializer, "pack");
                if (meta != null && meta.b() == 2) {
                    pack = new cab(pack);
                }
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e2) {
                FMLLog.log(Level.ERROR, "The container %s (type %s) returned an invalid class for it's resource pack.", container.getName(), container.getClass().getName());
                return;
            }
            catch (Exception e3) {
                FMLLog.log(Level.ERROR, e3, "An unexpected exception occurred constructing the custom resource pack for %s", container.getName());
                throw Throwables.propagate((Throwable)e3);
            }
        }
    }

    public caa getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }

    @Override
    public String getCurrentLanguage() {
        return this.client.Q().c().a();
    }

    @Override
    public void serverStopped() {
        MinecraftServer server = this.getServer();
        if (server == null || !server.ao()) {
            // empty if block
        }
    }

    @Override
    public ew getClientPlayHandler() {
        return this.currentPlayClient == null ? null : (bno)this.currentPlayClient.get();
    }

    @Override
    public er getClientToServerNetworkManager() {
        return this.client.v() != null ? this.client.v().a() : null;
    }

    public void handleClientWorldClosing(bnq world) {
        er client = this.getClientToServerNetworkManager();
        if (client != null && !client.c()) {
            PersistentRegistryManager.revertToFrozen();
        }
    }

    public void startIntegratedServer(String id2, String name, ajv settings) {
    }

    public File getSavesDir() {
        return new File(this.client.w, "saves");
    }

    public void tryLoadExistingWorld(bka selectWorldGUI, bbz comparator) {
        du leveldat;
        File dir = new File(this.getSavesDir(), comparator.a());
        try {
            leveldat = ed.a(new FileInputStream(new File(dir, "level.dat")));
        }
        catch (Exception e2) {
            try {
                leveldat = ed.a(new FileInputStream(new File(dir, "level.dat_old")));
            }
            catch (Exception e1) {
                FMLLog.warning("There appears to be a problem loading the save %s, both level files are unreadable.", comparator.a());
                return;
            }
        }
        du fmlData = leveldat.o("FML");
        if (fmlData.e("ModItemData")) {
            this.showGuiScreen(new GuiOldSaveLoadConfirm(comparator.a(), comparator.b(), selectWorldGUI));
        } else {
            try {
                this.client.a(comparator.a(), comparator.b(), null);
            }
            catch (StartupQuery.AbortedException abortedException) {
                // empty catch block
            }
        }
    }

    public void showInGameModOptions(bhk guiIngameMenu) {
        this.showGuiScreen(new GuiModList(guiIngameMenu));
    }

    public IModGuiFactory getGuiFactoryFor(ModContainer selectedMod) {
        return (IModGuiFactory)this.guiFactories.get((Object)selectedMod);
    }

    public void setupServerList() {
        this.extraServerListData = Collections.synchronizedMap(Maps.newHashMap());
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    public void captureAdditionalData(kf serverstatusresponse, JsonObject jsonobject) {
        if (jsonobject.has("modinfo")) {
            JsonObject fmlData = jsonobject.get("modinfo").getAsJsonObject();
            this.extraServerListData.put(serverstatusresponse, fmlData);
        }
    }

    public void bindServerListData(bnt data, kf originalResponse) {
        if (this.extraServerListData.containsKey(originalResponse)) {
            JsonObject jsonData = this.extraServerListData.get(originalResponse);
            String type = jsonData.get("type").getAsString();
            JsonArray modDataArray = jsonData.get("modList").getAsJsonArray();
            boolean moddedClientAllowed = jsonData.has("clientModsAllowed") ? jsonData.get("clientModsAllowed").getAsBoolean() : true;
            ImmutableMap.Builder modListBldr = ImmutableMap.builder();
            for (JsonElement obj : modDataArray) {
                JsonObject modObj = obj.getAsJsonObject();
                modListBldr.put((Object)modObj.get("modid").getAsString(), (Object)modObj.get("version").getAsString());
            }
            ImmutableMap modListMap = modListBldr.build();
            this.serverDataTag.put(data, new ExtendedServerListData(type, FMLNetworkHandler.checkModList((Map<String, String>)modListMap, Side.SERVER) == null, (Map<String, String>)modListMap, !moddedClientAllowed));
        } else {
            String serverDescription = data.d;
            boolean moddedClientAllowed = true;
            if (!Strings.isNullOrEmpty((String)serverDescription)) {
                moddedClientAllowed = !serverDescription.endsWith(":NOFML\u00a7r");
            }
            this.serverDataTag.put(data, new ExtendedServerListData("VANILLA", false, (Map<String, String>)ImmutableMap.of(), !moddedClientAllowed));
        }
        startupConnectionData.countDown();
    }

    @Nullable
    public String enhanceServerListEntry(bji serverListEntry, bnt serverEntry, int x2, int width, int y2, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        ExtendedServerListData extendedData;
        boolean blocked = false;
        if (this.serverDataTag.containsKey(serverEntry)) {
            extendedData = this.serverDataTag.get(serverEntry);
            if ("FML".equals(extendedData.type) && extendedData.isCompatible) {
                idx = 0;
                tooltip = String.format("Compatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("FML".equals(extendedData.type) && !extendedData.isCompatible) {
                idx = 16;
                tooltip = String.format("Incompatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("BUKKIT".equals(extendedData.type)) {
                idx = 32;
                tooltip = String.format("Bukkit modded server", new Object[0]);
            } else if ("VANILLA".equals(extendedData.type)) {
                idx = 48;
                tooltip = String.format("Vanilla server", new Object[0]);
            } else {
                idx = 64;
                tooltip = String.format("Unknown server data", new Object[0]);
            }
        } else {
            return null;
        }
        blocked = extendedData.isBlocked;
        this.client.N().a(iconSheet);
        bfi.a(x2 + width - 18, y2 + 10, 0.0f, idx, 16, 16, 256.0f, 256.0f);
        if (blocked) {
            bfi.a(x2 + width - 18, y2 + 10, 0.0f, 80.0f, 16, 16, 256.0f, 256.0f);
        }
        return relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26 ? tooltip : null;
    }

    public String fixDescription(String description) {
        return description.endsWith(":NOFML\u00a7r") ? description.substring(0, description.length() - 8) + "\u00a7r" : description;
    }

    public void connectToServerAtStartup(String host, int port) {
        this.setupServerList();
        bnv osp = new bnv();
        bnt serverData = new bnt("Command Line", host + ":" + port, false);
        try {
            osp.a(serverData);
            startupConnectionData.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e2) {
            this.showGuiScreen(new bgv(new bhv(), this.client, host, port));
            return;
        }
        this.connectToServer(new bhv(), serverData);
    }

    public void connectToServer(bho guiMultiplayer, bnt serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen(new GuiAccessDenied(guiMultiplayer, serverEntry));
        } else {
            this.showGuiScreen(new bgv(guiMultiplayer, this.client, serverEntry));
        }
    }

    public void connectToRealmsServer(String host, int port) {
    }

    public void setPlayClient(bno netHandlerPlayClient) {
        this.currentPlayClient = new WeakReference<bno>(netHandlerPlayClient);
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus2, er manager, Set<String> channelSet, String channel, Side side) {
        if (side == Side.CLIENT) {
            bus2.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<bno>(manager, channelSet, channel, side, bno.class));
        } else {
            bus2.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<mi>(manager, channelSet, channel, side, mi.class));
        }
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return true;
    }

    @Override
    public void allowLogins() {
    }

    @Override
    public qy getWorldThread(ew net) {
        if (net instanceof fp || net instanceof js || net instanceof kc) {
            return this.getClient();
        }
        if (net instanceof jq || net instanceof jx || net instanceof im || net instanceof kg) {
            return this.getServer();
        }
        throw new RuntimeException("Unknown INetHandler: " + net);
    }

    public void trackMissingTexture(kq resourceLocation) {
        this.badTextureDomains.add(resourceLocation.b());
        this.missingTextures.put((Object)resourceLocation.b(), (Object)resourceLocation);
    }

    public void trackBrokenTexture(kq resourceLocation, String error) {
        this.badTextureDomains.add(resourceLocation.b());
        Set badType = (Set)this.brokenTextures.get((Object)resourceLocation.b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            this.brokenTextures.put((Object)resourceLocation.b(), Objects.firstNonNull((Object)error, (Object)"Unknown error"), (Object)badType);
        }
        badType.add(resourceLocation);
    }

    public void logMissingTextureErrors() {
        if (this.missingTextures.isEmpty() && this.brokenTextures.isEmpty()) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"TEXTURE ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("The following texture errors were found.");
        Map resManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(cae.class, (cae)bes.z().O(), "domainResourceManagers", "field_110548_a");
        for (String resourceDomain : this.badTextureDomains) {
            Set missing = this.missingTextures.get((Object)resourceDomain);
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  DOMAIN {}", new Object[]{resourceDomain});
            logger.error(Strings.repeat((String)"-", (int)50));
            logger.error("  domain {} is missing {} texture{}", new Object[]{resourceDomain, missing.size(), missing.size() != 1 ? "s" : ""});
            bzr fallbackResourceManager = (bzr)resManagers.get(resourceDomain);
            if (fallbackResourceManager == null) {
                logger.error("    domain {} is missing a resource manager - it is probably a side-effect of automatic texture processing", new Object[]{resourceDomain});
            } else {
                List resPacks = (List)ObfuscationReflectionHelper.getPrivateValue(bzr.class, fallbackResourceManager, "resourcePacks", "field_110540_a");
                logger.error("    domain {} has {} location{}:", new Object[]{resourceDomain, resPacks.size(), resPacks.size() != 1 ? "s" : ""});
                Iterator<Object> iterator = resPacks.iterator();
                while (iterator.hasNext()) {
                    caa resPack = (caa)iterator.next();
                    if (resPack instanceof FMLContainerHolder) {
                        FMLContainerHolder containerHolder = (FMLContainerHolder)((Object)resPack);
                        ModContainer fmlContainer = containerHolder.getFMLContainer();
                        logger.error("      mod {} resources at {}", new Object[]{fmlContainer.getModId(), fmlContainer.getSource().getPath()});
                        continue;
                    }
                    if (resPack instanceof bzm) {
                        bzm resourcePack = (bzm)resPack;
                        File resPath = (File)ObfuscationReflectionHelper.getPrivateValue(bzm.class, resourcePack, "resourcePackFile", "field_110597_b");
                        logger.error("      resource pack at path {}", new Object[]{resPath.getPath()});
                        continue;
                    }
                    logger.error("      unknown resourcepack type {} : {}", new Object[]{resPack.getClass().getName(), resPack.b()});
                }
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            if (this.missingTextures.containsKey((Object)resourceDomain)) {
                logger.error("    The missing resources for domain {} are:", new Object[]{resourceDomain});
                for (kq rl2 : missing) {
                    logger.error("      {}", new Object[]{rl2.a()});
                }
                logger.error(Strings.repeat((String)"-", (int)25));
            }
            if (!this.brokenTextures.containsRow((Object)resourceDomain)) {
                logger.error("    No other errors exist for domain {}", new Object[]{resourceDomain});
            } else {
                logger.error("    The following other errors were reported for domain {}:", new Object[]{resourceDomain});
                Map resourceErrs = this.brokenTextures.row((Object)resourceDomain);
                for (String error : resourceErrs.keySet()) {
                    logger.error(Strings.repeat((String)"-", (int)25));
                    logger.error("    Problem: {}", new Object[]{error});
                    for (kq rl3 : (Set)resourceErrs.get(error)) {
                        logger.error("      {}", new Object[]{rl3.a()});
                    }
                }
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error(Strings.repeat((String)"+=", (int)25));
    }

    @Override
    public void processWindowMessages() {
        if (LWJGLUtil.getPlatform() != 3) {
            return;
        }
        if (!SplashProgress.mutex.tryAcquire()) {
            return;
        }
        Display.processMessages();
        SplashProgress.mutex.release();
    }

    @Override
    public String stripSpecialChars(String message) {
        return CharMatcher.anyOf((CharSequence)ALLOWED_CHARS).retainFrom((CharSequence)oy.a(message));
    }

    @Override
    public void reloadRenderers() {
        this.client.g.a();
    }

    @Override
    public void fireSidedRegistryEvents() {
        MinecraftForge.EVENT_BUS.post(new ModelRegistryEvent());
    }

    @Override
    public CompoundDataFixer getDataFixer() {
        return (CompoundDataFixer)this.client.ai();
    }
}

