/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;

public class GuiConfig
extends bho {
    public final bho parentScreen;
    public String title = "Config GUI";
    @Nullable
    public String titleLine2;
    public final List<IConfigElement> configElements;
    public final List<GuiConfigEntries.IConfigEntry> initEntries;
    public GuiConfigEntries entryList;
    protected GuiButtonExt btnDefaultAll;
    protected GuiButtonExt btnUndoAll;
    protected GuiCheckBox chkApplyGlobally;
    public final String modID;
    @Nullable
    public final String configID;
    public final boolean isWorldRunning;
    public final boolean allRequireWorldRestart;
    public final boolean allRequireMcRestart;
    public boolean needsRefresh = true;
    protected HoverChecker undoHoverChecker;
    protected HoverChecker resetHoverChecker;
    protected HoverChecker checkBoxHoverChecker;

    public GuiConfig(bho parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, configID, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(bho parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(bho parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
    }

    public GuiConfig(bho parentScreen, List<IConfigElement> configElements, String modID, @Nullable String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, @Nullable String titleLine2) {
        this.j = bes.z();
        this.parentScreen = parentScreen;
        this.configElements = configElements;
        this.entryList = new GuiConfigEntries(this, this.j);
        this.initEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
        this.allRequireWorldRestart = allRequireWorldRestart;
        this.allRequireMcRestart = allRequireMcRestart;
        this.modID = modID;
        this.configID = configID;
        boolean bl2 = this.isWorldRunning = this.j.f != null;
        if (title != null) {
            this.title = title;
        }
        this.titleLine2 = titleLine2;
        if (this.titleLine2 != null && this.titleLine2.startsWith(" > ")) {
            this.titleLine2 = this.titleLine2.replaceFirst(" > ", "");
        }
    }

    public static String getAbridgedConfigPath(String path) {
        bes mc2 = bes.z();
        if (mc2.w.getAbsolutePath().endsWith(".")) {
            return path.replace("\\", "/").replace(mc2.w.getAbsolutePath().replace("\\", "/").substring(0, mc2.w.getAbsolutePath().length() - 1), "/.minecraft/");
        }
        return path.replace("\\", "/").replace(mc2.w.getAbsolutePath().replace("\\", "/"), "/.minecraft");
    }

    @Override
    public void b() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.j);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.j.k.a("\u21b6") * 2;
        int resetGlyphWidth = this.j.k.a("\u2604") * 2;
        int doneWidth = Math.max(this.j.k.a(cah.a("gui.done", new Object[0])) + 20, 100);
        int undoWidth = this.j.k.a(" " + cah.a("fml.configgui.tooltip.undoChanges", new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.j.k.a(" " + cah.a("fml.configgui.tooltip.resetToDefault", new Object[0])) + resetGlyphWidth + 20;
        int checkWidth = this.j.k.a(cah.a("fml.configgui.applyGlobally", new Object[0])) + 13;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5 + checkWidth) / 2;
        this.n.add(new GuiButtonExt(2000, this.l / 2 - buttonWidthHalf, this.m - 29, doneWidth, 20, cah.a("gui.done", new Object[0])));
        this.btnDefaultAll = new GuiUnicodeGlyphButton(2001, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.m - 29, resetWidth, 20, " " + cah.a("fml.configgui.tooltip.resetToDefault", new Object[0]), "\u2604", 2.0f);
        this.n.add(this.btnDefaultAll);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.l / 2 - buttonWidthHalf + doneWidth + 5, this.m - 29, undoWidth, 20, " " + cah.a("fml.configgui.tooltip.undoChanges", new Object[0]), "\u21b6", 2.0f);
        this.n.add(this.btnUndoAll);
        this.chkApplyGlobally = new GuiCheckBox(2003, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5 + resetWidth + 5, this.m - 24, cah.a("fml.configgui.applyGlobally", new Object[0]), false);
        this.n.add(this.chkApplyGlobally);
        this.undoHoverChecker = new HoverChecker(this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker(this.btnDefaultAll, 800);
        this.checkBoxHoverChecker = new HoverChecker(this.chkApplyGlobally, 800);
        this.entryList.initGui();
    }

    @Override
    public void m() {
        this.entryList.onGuiClosed();
        if (this.configID != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.b();
        }
        if (!(this.parentScreen instanceof GuiConfig)) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    protected void a(bfm button) {
        if (button.k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded(this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post(event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post(new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.j.a(new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", new fh(cah.a("fml.configgui.gameRestartRequired", new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            if (flag) {
                this.j.a(this.parentScreen);
            }
        } else if (button.k == 2001) {
            this.entryList.setAllToDefault(this.chkApplyGlobally.isChecked());
        } else if (button.k == 2002) {
            this.entryList.undoAllChanges(this.chkApplyGlobally.isChecked());
        }
    }

    @Override
    public void k() throws IOException {
        super.k();
        this.entryList.p();
    }

    @Override
    protected void a(int x2, int y2, int mouseEvent) throws IOException {
        if (mouseEvent != 0 || !this.entryList.b(x2, y2, mouseEvent)) {
            this.entryList.mouseClickedPassThru(x2, y2, mouseEvent);
            super.a(x2, y2, mouseEvent);
        }
    }

    @Override
    protected void b(int x2, int y2, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.c(x2, y2, mouseEvent)) {
            super.b(x2, y2, mouseEvent);
        }
    }

    @Override
    protected void a(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.j.a(this.parentScreen);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    @Override
    public void e() {
        super.e();
        this.entryList.updateScreen();
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        this.entryList.a(mouseX, mouseY, partialTicks);
        this.a(this.q, this.title, this.l / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (title2 != null) {
            int strWidth = this.j.k.a(title2);
            int ellipsisWidth = this.j.k.a("...");
            if (strWidth > this.l - 6 && strWidth > ellipsisWidth) {
                title2 = this.j.k.a(title2, this.l - 6 - ellipsisWidth).trim() + "...";
            }
            this.a(this.q, title2, this.l / 2, 18, 0xFFFFFF);
        }
        this.btnUndoAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && this.entryList.hasChangedEntry(this.chkApplyGlobally.isChecked());
        this.btnDefaultAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && !this.entryList.areAllEntriesDefault(this.chkApplyGlobally.isChecked());
        super.a(mouseX, mouseY, partialTicks);
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cah.a("fml.configgui.tooltip.undoAll", new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cah.a("fml.configgui.tooltip.resetAll", new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.checkBoxHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cah.a("fml.configgui.tooltip.applyGlobally", new Object[0]).split("\n")), mouseX, mouseY);
        }
    }

    public void drawToolTip(List<String> stringList, int x2, int y2) {
        GuiUtils.drawHoveringText(stringList, x2, y2, this.l, this.m, 300, this.q);
    }
}

