/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Joiner;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.fml.common.ClassNameUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;

public class ProgressManager {
    private static final List<ProgressBar> bars = new CopyOnWriteArrayList<ProgressBar>();

    public static ProgressBar push(String title, int steps) {
        return ProgressManager.push(title, steps, false);
    }

    public static ProgressBar push(String title, int steps, boolean timeEachStep) {
        ProgressBar bar2 = new ProgressBar(title, steps);
        bars.add(bar2);
        if (timeEachStep) {
            bar2.timeEachStep();
        }
        FMLCommonHandler.instance().processWindowMessages();
        return bar2;
    }

    public static void pop(ProgressBar bar2) {
        if (bar2.getSteps() != bar2.getStep()) {
            throw new IllegalStateException("can't pop unfinished ProgressBar " + bar2.getTitle());
        }
        bars.remove(bar2);
        if (bar2.getSteps() != 0) {
            long newTime = System.nanoTime();
            if (bar2.timeEachStep) {
                FMLLog.fine("Bar Step: %s - %s took %.3fs", bar2.getTitle(), bar2.getMessage(), Float.valueOf((float)(newTime - bar2.lastTime) / 1000000.0f / 1000.0f));
            }
            if (bar2.getSteps() == 1) {
                FMLLog.fine("Bar Finished: %s - %s took %.3fs", bar2.getTitle(), bar2.getMessage(), Float.valueOf((float)(newTime - bar2.startTime) / 1000000.0f / 1000.0f));
            } else {
                FMLLog.fine("Bar Finished: %s took %.3fs", bar2.getTitle(), Float.valueOf((float)(newTime - bar2.startTime) / 1000000.0f / 1000.0f));
            }
        }
        FMLCommonHandler.instance().processWindowMessages();
    }

    public static Iterator<ProgressBar> barIterator() {
        return bars.iterator();
    }

    public static class ProgressBar {
        private final String title;
        private final int steps;
        private volatile int step = 0;
        private volatile String message = "";
        private boolean timeEachStep = false;
        private long startTime;
        private long lastTime = this.startTime = System.nanoTime();

        private ProgressBar(String title, int steps) {
            this.title = title;
            this.steps = steps;
        }

        public void step(Class<?> classToName, String ... extra) {
            this.step(ClassNameUtils.shortName(classToName) + Joiner.on((char)' ').join((Object[])extra));
        }

        public void step(String message) {
            if (this.step >= this.steps) {
                throw new IllegalStateException("too much steps for ProgressBar " + this.title);
            }
            if (this.timeEachStep && this.step != 0) {
                long newTime = System.nanoTime();
                FMLLog.fine("Bar Step: %s - %s took %.3fs", this.getTitle(), this.getMessage(), Float.valueOf((float)(newTime - this.lastTime) / 1000000.0f / 1000.0f));
                this.lastTime = newTime;
            }
            ++this.step;
            this.message = FMLCommonHandler.instance().stripSpecialChars(message);
            FMLCommonHandler.instance().processWindowMessages();
        }

        public String getTitle() {
            return this.title;
        }

        public int getSteps() {
            return this.steps;
        }

        public int getStep() {
            return this.step;
        }

        public String getMessage() {
            return this.message;
        }

        public void timeEachStep() {
            this.timeEachStep = true;
        }
    }
}

