/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ItemStackTransformer
implements IClassTransformer {
    private static final String ITEM_TYPE = "Lnet/minecraft/item/Item;";
    private static final String GETITEM_DESC = "()Lnet/minecraft/item/Item;";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.item.ItemStack".equals(name)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        Object itemField = null;
        for (Object f2 : classNode.fields) {
            if (ITEM_TYPE.equals(((FieldNode)f2).desc) && itemField == null) {
                itemField = f2;
                continue;
            }
            if (!ITEM_TYPE.equals(((FieldNode)f2).desc)) continue;
            throw new RuntimeException("Error processing ItemStack - found a duplicate Item field");
        }
        if (itemField == null) {
            throw new RuntimeException("Error processing ItemStack - no Item field declared (is the code somehow obfuscated?)");
        }
        MethodNode getItemMethod = null;
        for (MethodNode m2 : classNode.methods) {
            if (m2.name.equals("getItemRaw")) continue;
            if (GETITEM_DESC.equals(m2.desc) && getItemMethod == null) {
                getItemMethod = m2;
                continue;
            }
            if (!GETITEM_DESC.equals(m2.desc)) continue;
            throw new RuntimeException("Error processing ItemStack - duplicate getItem method found");
        }
        if (getItemMethod == null) {
            throw new RuntimeException("Error processing ItemStack - no getItem method found (is the code somehow obfuscated?)");
        }
        for (MethodNode m2 : classNode.methods) {
            if (m2.name.equals("getItemRaw")) continue;
            ListIterator it2 = m2.instructions.iterator();
            while (it2.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it2.next();
                if (insnNode.getType() != 4) continue;
                FieldInsnNode fi2 = (FieldInsnNode)insnNode;
                if (!((FieldNode)itemField).name.equals(fi2.name) || fi2.getOpcode() != 180) continue;
                it2.remove();
                MethodInsnNode replace = new MethodInsnNode(182, "net/minecraft/item/ItemStack", getItemMethod.name, getItemMethod.desc, false);
                it2.add(replace);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

