/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import net.minecraftforge.common.util.Java6Utils;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class JarDiscoverer
implements ITypeDiscoverer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList foundMods = Lists.newArrayList();
        FMLLog.fine("Examining file %s for potential mods", candidate.getModContainer().getName());
        JarFile jar = null;
        try {
            jar = new JarFile(candidate.getModContainer());
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            MetadataCollection mc2 = null;
            if (modInfo != null) {
                FMLLog.finer("Located mcmod.info file in file %s", candidate.getModContainer().getName());
                InputStream inputStream = jar.getInputStream(modInfo);
                try {
                    mc2 = MetadataCollection.from(inputStream, candidate.getModContainer().getName());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            } else {
                FMLLog.fine("The mod container %s appears to be missing an mcmod.info file", candidate.getModContainer().getName());
                mc2 = MetadataCollection.from(null, "");
            }
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                ASMModParser modParser;
                Matcher match;
                if (zipEntry.getName() != null && zipEntry.getName().startsWith("__MACOSX") || !(match = classFile.matcher(zipEntry.getName())).matches()) continue;
                try {
                    InputStream inputStream = jar.getInputStream(zipEntry);
                    try {
                        modParser = new ASMModParser(inputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    candidate.addClassEntry(zipEntry.getName());
                }
                catch (LoaderException e2) {
                    FMLLog.log(Level.ERROR, e2, "There was a problem reading the entry %s in the jar %s - probably a corrupt zip", zipEntry.getName(), candidate.getModContainer().getPath());
                    jar.close();
                    throw e2;
                }
                modParser.validate();
                modParser.sendToTable(table, candidate);
                ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                if (container == null) continue;
                table.addContainer(container);
                foundMods.add(container);
                container.bindMetadata(mc2);
                container.setClassVersion(modParser.getClassVersion());
            }
        }
        catch (Exception e3) {
            try {
                FMLLog.log(Level.WARN, e3, "Zip file %s failed to read properly, it will be ignored", candidate.getModContainer().getName());
            }
            catch (Throwable throwable) {
                Java6Utils.closeZipQuietly(jar);
                throw throwable;
            }
            Java6Utils.closeZipQuietly(jar);
        }
        Java6Utils.closeZipQuietly(jar);
        return foundMods;
    }
}

