/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.ListenerList;

public class Event {
    private boolean isCanceled = false;
    private Result result = Result.DEFAULT;
    private static ListenerList listeners = new ListenerList();
    private EventPriority phase = null;

    public Event() {
        this.setup();
    }

    public boolean isCancelable() {
        return false;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a non cancellable event");
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return false;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    protected void setup() {
    }

    public ListenerList getListenerList() {
        return listeners;
    }

    @Nullable
    public EventPriority getPhase() {
        return this.phase;
    }

    public void setPhase(@Nonnull EventPriority value) {
        Preconditions.checkNotNull((Object)value, (Object)"setPhase argument must not be null");
        int prev = this.phase == null ? -1 : this.phase.ordinal();
        Preconditions.checkArgument((prev < value.ordinal() ? 1 : 0) != 0, (String)"Attempted to set event phase to %s when already %s", (Object[])new Object[]{value, this.phase});
        this.phase = value;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

