/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public abstract class FMLMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class EntitySpawnMessage
    extends EntityMessage {
        String modId;
        int modEntityTypeId;
        UUID entityUUID;
        double rawX;
        double rawY;
        double rawZ;
        float scaledYaw;
        float scaledPitch;
        float scaledHeadYaw;
        int throwerId;
        double speedScaledX;
        double speedScaledY;
        double speedScaledZ;
        List<kn.a<?>> dataWatcherList;
        ByteBuf dataStream;

        public EntitySpawnMessage() {
        }

        public EntitySpawnMessage(EntityRegistry.EntityRegistration er2, sn entity, ModContainer modContainer) {
            super(entity);
            this.modId = modContainer.getModId();
            this.modEntityTypeId = er2.getModEntityId();
        }

        @Override
        void toBytes(ByteBuf buf2) {
            super.toBytes(buf2);
            ByteBufUtils.writeUTF8String(buf2, this.modId);
            buf2.writeInt(this.modEntityTypeId);
            buf2.writeLong(this.entity.be().getMostSignificantBits());
            buf2.writeLong(this.entity.be().getLeastSignificantBits());
            buf2.writeDouble(this.entity.p);
            buf2.writeDouble(this.entity.q);
            buf2.writeDouble(this.entity.r);
            buf2.writeByte((int)((byte)(this.entity.v * 256.0f / 360.0f)));
            buf2.writeByte((int)((byte)(this.entity.w * 256.0f / 360.0f)));
            if (this.entity instanceof sw) {
                buf2.writeByte((int)((byte)(((sw)this.entity).aP * 256.0f / 360.0f)));
            } else {
                buf2.writeByte(0);
            }
            ByteBuf tmpBuf = Unpooled.buffer();
            et pb2 = new et(tmpBuf);
            try {
                this.entity.R().a(pb2);
            }
            catch (IOException e2) {
                FMLLog.log(Level.FATAL, e2, "Encountered fatal exception trying to send entity spawn data watchers", new Object[0]);
                throw Throwables.propagate((Throwable)e2);
            }
            buf2.writeBytes(tmpBuf);
            if (this.entity instanceof IThrowableEntity) {
                sn owner = ((IThrowableEntity)((Object)this.entity)).getThrower();
                buf2.writeInt(owner == null ? this.entity.O() : owner.O());
                double maxVel = 3.9;
                double mX = this.entity.s;
                double mY = this.entity.t;
                double mZ = this.entity.u;
                if (mX < -maxVel) {
                    mX = -maxVel;
                }
                if (mY < -maxVel) {
                    mY = -maxVel;
                }
                if (mZ < -maxVel) {
                    mZ = -maxVel;
                }
                if (mX > maxVel) {
                    mX = maxVel;
                }
                if (mY > maxVel) {
                    mY = maxVel;
                }
                if (mZ > maxVel) {
                    mZ = maxVel;
                }
                buf2.writeInt((int)(mX * 8000.0));
                buf2.writeInt((int)(mY * 8000.0));
                buf2.writeInt((int)(mZ * 8000.0));
            } else {
                buf2.writeInt(0);
            }
            if (this.entity instanceof IEntityAdditionalSpawnData) {
                tmpBuf = Unpooled.buffer();
                ((IEntityAdditionalSpawnData)((Object)this.entity)).writeSpawnData(tmpBuf);
                buf2.writeBytes(tmpBuf);
            }
        }

        @Override
        void fromBytes(ByteBuf dat) {
            super.fromBytes(dat);
            this.modId = ByteBufUtils.readUTF8String(dat);
            this.modEntityTypeId = dat.readInt();
            this.entityUUID = new UUID(dat.readLong(), dat.readLong());
            this.rawX = dat.readDouble();
            this.rawY = dat.readDouble();
            this.rawZ = dat.readDouble();
            this.scaledYaw = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledPitch = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledHeadYaw = (float)dat.readByte() * 360.0f / 256.0f;
            try {
                this.dataWatcherList = kn.b(new et(dat));
            }
            catch (IOException e2) {
                FMLLog.log(Level.FATAL, e2, "There was a critical error decoding the datawatcher stream for a mod entity.", new Object[0]);
                throw Throwables.propagate((Throwable)e2);
            }
            this.throwerId = dat.readInt();
            if (this.throwerId != 0) {
                this.speedScaledX = (double)dat.readInt() / 8000.0;
                this.speedScaledY = (double)dat.readInt() / 8000.0;
                this.speedScaledZ = (double)dat.readInt() / 8000.0;
            }
            this.dataStream = dat;
        }
    }

    public static abstract class EntityMessage
    extends FMLMessage {
        sn entity;
        int entityId;

        public EntityMessage() {
        }

        EntityMessage(sn entity) {
            this.entity = entity;
        }

        @Override
        void toBytes(ByteBuf buf2) {
            buf2.writeInt(this.entity.O());
        }

        @Override
        void fromBytes(ByteBuf buf2) {
            this.entityId = buf2.readInt();
        }
    }

    public static class OpenGui
    extends FMLMessage {
        int windowId;
        String modId;
        int modGuiId;
        int x;
        int y;
        int z;

        public OpenGui() {
        }

        OpenGui(int windowId, String modId, int modGuiId, int x2, int y2, int z2) {
            this.windowId = windowId;
            this.modId = modId;
            this.modGuiId = modGuiId;
            this.x = x2;
            this.y = y2;
            this.z = z2;
        }

        @Override
        void toBytes(ByteBuf buf2) {
            buf2.writeInt(this.windowId);
            ByteBufUtils.writeUTF8String(buf2, this.modId);
            buf2.writeInt(this.modGuiId);
            buf2.writeInt(this.x);
            buf2.writeInt(this.y);
            buf2.writeInt(this.z);
        }

        @Override
        void fromBytes(ByteBuf buf2) {
            this.windowId = buf2.readInt();
            this.modId = ByteBufUtils.readUTF8String(buf2);
            this.modGuiId = buf2.readInt();
            this.x = buf2.readInt();
            this.y = buf2.readInt();
            this.z = buf2.readInt();
        }
    }

    public static class CompleteHandshake
    extends FMLMessage {
        Side target;

        public CompleteHandshake() {
        }

        public CompleteHandshake(Side target) {
            this.target = target;
        }

        @Override
        void fromBytes(ByteBuf buf2) {
            this.target = Side.values()[buf2.readByte()];
        }

        @Override
        void toBytes(ByteBuf buf2) {
            buf2.writeByte(this.target.ordinal());
        }
    }
}

