/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private BiMap<Class<? extends sn>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
    }

    public static void registerModEntity(kq registryName, Class<? extends sn> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id2, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(kq registryName, Class<? extends sn> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(registryName, entityClass, entityName, id2, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(registryName, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(kq registryName, Class<? extends sn> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc2, registryName, entityClass, entityName, id2, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
                ForgeRegistries.ENTITIES.register(entry);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc2.getModId(), entityName, entry.getRegistryName());
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered entry %s class %s", mc2.getModId(), registryName, entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARN, e2, "The mod %s tried to register the entity (registry,name,class) (%s,%s,%s) one or both of which are already registered", mc2.getModId(), registryName, entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc2, (Object)er2);
    }

    public static void registerEgg(kq name, int primary, int secondary) {
        EntityEntry entry = ForgeRegistries.ENTITIES.getValue(name);
        if (entry == null) {
            FMLLog.bigWarning("Attempted to registry a entity egg for entity (%s) that is not in the Entity Registry", name);
            return;
        }
        entry.setEgg(new sp.a(name, primary, secondary));
    }

    public static void addSpawn(Class<? extends sx> entityClass, int weightedProb, int min, int max, sy typeOfCreature, akf ... biomes) {
        for (akf biome : biomes) {
            List<akf.c> spawns = biome.a(typeOfCreature);
            boolean found = false;
            for (akf.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new akf.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, sy typeOfCreature, akf ... biomes) {
        Class<?> entityClazz = null;
        if (sx.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends sx> entityClass, sy typeOfCreature, akf ... biomes) {
        for (akf biome : biomes) {
            Iterator<akf.c> spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                akf.c entry = spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, sy typeOfCreature, akf ... biomes) {
        Class<?> entityClazz = null;
        if (sx.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    @Nullable
    public EntityRegistration lookupModSpawn(Class<? extends sn> clazz, boolean keepLooking) {
        Class<? extends sn> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking &= !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    @Nullable
    public EntityRegistration lookupModSpawn(ModContainer mc2, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc2)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(lt entityTracker, sn entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    @Nullable
    public static EntityEntry getEntry(Class<? extends sn> entry) {
        for (EntityEntry e2 : ForgeRegistries.ENTITIES) {
            if (e2.getEntityClass() != entry) continue;
            return e2;
        }
        return null;
    }

    public class EntityRegistration {
        private Class<? extends sn> entityClass;
        private ModContainer container;
        private kq regName;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, sn> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc2, kq registryName, Class<? extends sn> entityClass, String entityName, int id2, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc2;
            this.regName = registryName;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id2;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public kq getRegistryName() {
            return this.regName;
        }

        public Class<? extends sn> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public sn doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (sn)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, sn> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

