/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;

class ItemStackHolderRef {
    private Field field;
    private String itemName;
    private int meta;
    private String serializednbt;
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    ItemStackHolderRef(Field field, String itemName, int meta, String serializednbt) {
        this.field = field;
        this.itemName = itemName;
        this.meta = meta;
        this.serializednbt = serializednbt;
        ItemStackHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f2) {
        try {
            if (modifiersField == null) {
                Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f2, f2.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public void apply() {
        afj is2;
        try {
            is2 = GameRegistry.makeItemStack(this.itemName, this.meta, 1, this.serializednbt);
        }
        catch (RuntimeException e2) {
            FMLLog.getLogger().log(Level.ERROR, "Caught exception processing itemstack {},{},{} in annotation at {}.{}", new Object[]{this.itemName, this.meta, this.serializednbt, this.field.getClass().getName(), this.field.getName()});
            throw e2;
        }
        try {
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, this.field, false);
            fieldAccessorSet.invoke(fieldAccessor, null, is2);
        }
        catch (Exception e3) {
            FMLLog.getLogger().log(Level.WARN, "Unable to set {} with value {},{},{}", new Object[]{this.field, this.itemName, this.meta, this.serializednbt});
        }
    }
}

