/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.FinalFieldHelper;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private kq injectedObject;
    private boolean isValid;
    private FMLControlledNamespacedRegistry registry;

    ObjectHolderRef(Field field, kq injectedObject, boolean extractFromExistingValues) {
        this.registry = this.getRegistryForType(field);
        this.field = field;
        boolean bl2 = this.isValid = this.registry != null;
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (existing == null || existing == this.registry.getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isValid = false;
                    return;
                }
                kq tmp = null;
                if (this.registry != null) {
                    tmp = this.registry.getKey((IForgeRegistryEntry)existing);
                }
                this.injectedObject = tmp;
            }
            catch (Exception e2) {
                throw Throwables.propagate((Throwable)e2);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that does not map to a registry. Ensure the registry was created during the RegistryEvent.NewRegistry event. (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        try {
            FinalFieldHelper.makeWritable(field);
        }
        catch (Exception e3) {
            throw Throwables.propagate((Throwable)e3);
        }
    }

    @Nullable
    private FMLControlledNamespacedRegistry<?> getRegistryForType(Field field) {
        LinkedList typesToExamine = new LinkedList();
        typesToExamine.add(field.getType());
        FMLControlledNamespacedRegistry registry = null;
        while (!typesToExamine.isEmpty() && registry == null) {
            Class type = (Class)typesToExamine.remove();
            Collections.addAll(typesToExamine, type.getInterfaces());
            if (!IForgeRegistryEntry.class.isAssignableFrom(type)) continue;
            registry = PersistentRegistryManager.PersistentRegistry.ACTIVE.getRegistry(type);
            Class parentType = type.getSuperclass();
            if (parentType == null) continue;
            typesToExamine.add(parentType);
        }
        return registry;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void apply() {
        Object thing = this.isValid && this.registry.containsKey(this.injectedObject) && !this.registry.isDummied(this.injectedObject) ? this.registry.getValue(this.injectedObject) : null;
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            FinalFieldHelper.setField(this.field, null, thing);
        }
        catch (Exception e2) {
            FMLLog.log(Level.WARN, e2, "Unable to set %s with value %s (%s)", this.field, thing, this.injectedObject);
        }
    }
}

