/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.apache.logging.log4j.Level;

public class ModListHelper {
    private static File mcDirectory;
    private static Set<File> visitedFiles;
    public static final Map<String, File> additionalMods;

    static void parseModList(File minecraftDirectory) {
        String extraMods;
        FMLRelaunchLog.fine("Attempting to load commandline specified mods, relative to %s", minecraftDirectory.getAbsolutePath());
        mcDirectory = minecraftDirectory;
        Map args = (Map)Launch.blackboard.get("launchArgs");
        String listFile = (String)args.get("--modListFile");
        if (listFile != null) {
            ModListHelper.parseListFile(listFile);
        }
        if ((extraMods = (String)args.get("--mods")) != null) {
            String[] split;
            for (String modFile : split = extraMods.split(",")) {
                ModListHelper.tryAddFile(modFile, null, modFile);
            }
        }
        String[] extras = new String[]{"mods/mod_list.json", "mods/" + FMLInjectionData.mccversion + "/mod_list.json"};
        for (String extra : extras) {
            if (!new File(mcDirectory, extra).exists()) continue;
            ModListHelper.parseListFile(extra);
        }
    }

    private static void parseListFile(String listFile) {
        File repoRoot;
        JsonModList modList;
        String json;
        File f2;
        try {
            f2 = listFile.startsWith("absolute:") ? new File(listFile.substring(9)).getCanonicalFile() : new File(mcDirectory, listFile).getCanonicalFile();
        }
        catch (IOException e2) {
            FMLRelaunchLog.log(Level.INFO, e2, "Unable to canonicalize path %s relative to %s", listFile, mcDirectory.getAbsolutePath());
            return;
        }
        if (!f2.exists()) {
            FMLRelaunchLog.info("Failed to find modList file %s", f2.getAbsolutePath());
            return;
        }
        if (visitedFiles.contains(f2)) {
            FMLRelaunchLog.severe("There appears to be a loop in the modListFile hierarchy. You shouldn't do this!", new Object[0]);
            throw new RuntimeException("Loop detected, impossible to load modlistfile");
        }
        try {
            json = Files.asCharSource((File)f2, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e1) {
            FMLRelaunchLog.log(Level.INFO, e1, "Failed to read modList json file %s.", listFile);
            return;
        }
        Gson gsonParser = new Gson();
        try {
            modList = (JsonModList)gsonParser.fromJson(json, JsonModList.class);
        }
        catch (JsonSyntaxException e2) {
            FMLRelaunchLog.log(Level.INFO, e2, "Failed to parse modList json file %s.", listFile);
            return;
        }
        visitedFiles.add(f2);
        if (modList.parentList != null) {
            ModListHelper.parseListFile(modList.parentList);
        }
        if (!(repoRoot = new File(modList.repositoryRoot)).exists()) {
            FMLRelaunchLog.info("Failed to find the specified repository root %s", modList.repositoryRoot);
            return;
        }
        for (String s2 : modList.modRef) {
            StringBuilder fileName = new StringBuilder();
            StringBuilder genericName = new StringBuilder();
            String[] parts = s2.split(":");
            fileName.append(parts[0].replace('.', File.separatorChar));
            genericName.append(parts[0]);
            fileName.append(File.separatorChar);
            fileName.append(parts[1]).append(File.separatorChar);
            genericName.append(":").append(parts[1]);
            fileName.append(parts[2]).append(File.separatorChar);
            fileName.append(parts[1]).append('-').append(parts[2]);
            if (parts.length == 4) {
                fileName.append('-').append(parts[3]);
                genericName.append(":").append(parts[3]);
            }
            fileName.append(".jar");
            ModListHelper.tryAddFile(fileName.toString(), repoRoot, genericName.toString());
        }
    }

    private static void tryAddFile(String modFileName, @Nullable File repoRoot, String descriptor) {
        File modFile;
        File file = modFile = repoRoot != null ? new File(repoRoot, modFileName) : new File(mcDirectory, modFileName);
        if (!modFile.exists()) {
            FMLRelaunchLog.info("Failed to find mod file %s (%s)", descriptor, modFile.getAbsolutePath());
        } else {
            FMLRelaunchLog.fine("Adding %s (%s) to the mod list", descriptor, modFile.getAbsolutePath());
            additionalMods.put(descriptor, modFile);
        }
    }

    static {
        visitedFiles = Sets.newHashSet();
        additionalMods = Maps.newLinkedHashMap();
    }

    public static class JsonModList {
        public String repositoryRoot;
        public List<String> modRef;
        public String parentList;
    }
}

