/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<du> {
    protected dd<afj> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = dd.a(size, afj.a);
    }

    public ItemStackHandler(dd<afj> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = dd.a(size, afj.a);
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull afj stack) {
        this.validateSlotIndex(slot);
        if (afj.b(this.stacks.get(slot), stack)) {
            return;
        }
        this.stacks.set(slot, stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @Nonnull
    public afj getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks.get(slot);
    }

    @Override
    @Nonnull
    public afj insertItem(int slot, @Nonnull afj stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.b()) {
            return afj.a;
        }
        this.validateSlotIndex(slot);
        afj existing = this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl2 = reachedLimit = stack.E() > limit;
        if (!simulate) {
            if (existing.b()) {
                this.stacks.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.f(reachedLimit ? limit : stack.E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.E() - limit) : afj.a;
    }

    @Override
    @Nonnull
    public afj extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return afj.a;
        }
        this.validateSlotIndex(slot);
        afj existing = this.stacks.get(slot);
        if (existing.b()) {
            return afj.a;
        }
        int toExtract = Math.min(amount, existing.d());
        if (existing.E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, afj.a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, ItemHandlerHelper.copyStackWithSize(existing, existing.E() - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull afj stack) {
        return Math.min(this.getSlotLimit(slot), stack.d());
    }

    @Override
    public du serializeNBT() {
        ea nbtTagList = new ea();
        for (int i2 = 0; i2 < this.stacks.size(); ++i2) {
            if (this.stacks.get(i2).b()) continue;
            du itemTag = new du();
            itemTag.a("Slot", i2);
            this.stacks.get(i2).a(itemTag);
            nbtTagList.a(itemTag);
        }
        du nbt = new du();
        nbt.a("Items", nbtTagList);
        nbt.a("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(du nbt) {
        this.setSize(nbt.b("Size", 3) ? nbt.h("Size") : this.stacks.size());
        ea tagList = nbt.c("Items", 10);
        for (int i2 = 0; i2 < tagList.c(); ++i2) {
            du itemTags = tagList.b(i2);
            int slot = itemTags.h("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, new afj(itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

