/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<dd<afj>> idToStack = Lists.newArrayList();
    private static List<dd<afj>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final dd<afj> EMPTY_LIST = dd.a();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new afj(alv.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new afj(alv.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new afj(alv.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new afj(alv.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", alv.ad);
            OreDictionary.registerOre("stairWood", alv.bU);
            OreDictionary.registerOre("stairWood", alv.bV);
            OreDictionary.registerOre("stairWood", alv.bW);
            OreDictionary.registerOre("stairWood", alv.cC);
            OreDictionary.registerOre("stairWood", alv.cD);
            OreDictionary.registerOre("stickWood", afl.B);
            OreDictionary.registerOre("treeSapling", new afj(alv.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new afj(alv.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new afj(alv.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", alv.bn);
            OreDictionary.registerOre("oreGold", alv.o);
            OreDictionary.registerOre("oreIron", alv.p);
            OreDictionary.registerOre("oreLapis", alv.x);
            OreDictionary.registerOre("oreDiamond", alv.ag);
            OreDictionary.registerOre("oreRedstone", alv.aC);
            OreDictionary.registerOre("oreEmerald", alv.bP);
            OreDictionary.registerOre("oreQuartz", alv.co);
            OreDictionary.registerOre("oreCoal", alv.q);
            OreDictionary.registerOre("ingotIron", afl.m);
            OreDictionary.registerOre("ingotGold", afl.n);
            OreDictionary.registerOre("ingotBrick", afl.aP);
            OreDictionary.registerOre("ingotBrickNether", afl.cq);
            OreDictionary.registerOre("nuggetGold", afl.bF);
            OreDictionary.registerOre("nuggetIron", afl.da);
            OreDictionary.registerOre("gemDiamond", afl.l);
            OreDictionary.registerOre("gemEmerald", afl.bZ);
            OreDictionary.registerOre("gemQuartz", afl.cr);
            OreDictionary.registerOre("gemPrismarine", afl.cN);
            OreDictionary.registerOre("dustPrismarine", afl.cO);
            OreDictionary.registerOre("dustRedstone", afl.aF);
            OreDictionary.registerOre("dustGlowstone", afl.bb);
            OreDictionary.registerOre("gemLapis", new afj(afl.be, 1, 4));
            OreDictionary.registerOre("blockGold", alv.R);
            OreDictionary.registerOre("blockIron", alv.S);
            OreDictionary.registerOre("blockLapis", alv.y);
            OreDictionary.registerOre("blockDiamond", alv.ah);
            OreDictionary.registerOre("blockRedstone", alv.cn);
            OreDictionary.registerOre("blockEmerald", alv.bT);
            OreDictionary.registerOre("blockQuartz", alv.cq);
            OreDictionary.registerOre("blockCoal", alv.cA);
            OreDictionary.registerOre("cropWheat", afl.R);
            OreDictionary.registerOre("cropPotato", afl.cd);
            OreDictionary.registerOre("cropCarrot", afl.cc);
            OreDictionary.registerOre("cropNetherWart", afl.bG);
            OreDictionary.registerOre("sugarcane", afl.aR);
            OreDictionary.registerOre("blockCactus", alv.aK);
            OreDictionary.registerOre("dye", new afj(afl.be, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new afj(afl.aS));
            OreDictionary.registerOre("slimeball", afl.aU);
            OreDictionary.registerOre("enderpearl", afl.bC);
            OreDictionary.registerOre("bone", afl.bf);
            OreDictionary.registerOre("gunpowder", afl.K);
            OreDictionary.registerOre("string", afl.I);
            OreDictionary.registerOre("netherStar", afl.ck);
            OreDictionary.registerOre("leather", afl.aN);
            OreDictionary.registerOre("feather", afl.J);
            OreDictionary.registerOre("egg", afl.aX);
            OreDictionary.registerOre("record", afl.cB);
            OreDictionary.registerOre("record", afl.cC);
            OreDictionary.registerOre("record", afl.cD);
            OreDictionary.registerOre("record", afl.cE);
            OreDictionary.registerOre("record", afl.cF);
            OreDictionary.registerOre("record", afl.cG);
            OreDictionary.registerOre("record", afl.cH);
            OreDictionary.registerOre("record", afl.cI);
            OreDictionary.registerOre("record", afl.cJ);
            OreDictionary.registerOre("record", afl.cK);
            OreDictionary.registerOre("record", afl.cL);
            OreDictionary.registerOre("record", afl.cM);
            OreDictionary.registerOre("dirt", alv.d);
            OreDictionary.registerOre("grass", alv.c);
            OreDictionary.registerOre("stone", alv.b);
            OreDictionary.registerOre("cobblestone", alv.e);
            OreDictionary.registerOre("gravel", alv.n);
            OreDictionary.registerOre("sand", new afj(alv.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new afj(alv.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new afj(alv.cM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", alv.aV);
            OreDictionary.registerOre("obsidian", alv.Z);
            OreDictionary.registerOre("glowstone", alv.aX);
            OreDictionary.registerOre("endstone", alv.bH);
            OreDictionary.registerOre("torch", alv.aa);
            OreDictionary.registerOre("workbench", alv.ai);
            OreDictionary.registerOre("blockSlime", alv.cE);
            OreDictionary.registerOre("blockPrismarine", new afj(alv.cI, 1, apt.a.a.a()));
            OreDictionary.registerOre("blockPrismarineBrick", new afj(alv.cI, 1, apt.a.b.a()));
            OreDictionary.registerOre("blockPrismarineDark", new afj(alv.cI, 1, apt.a.c.a()));
            OreDictionary.registerOre("stoneGranite", new afj(alv.b, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new afj(alv.b, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new afj(alv.b, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new afj(alv.b, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new afj(alv.b, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new afj(alv.b, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", alv.w);
            OreDictionary.registerOre("blockGlass", alv.w);
            OreDictionary.registerOre("blockGlass", new afj(alv.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", alv.bj);
            OreDictionary.registerOre("paneGlass", alv.bj);
            OreDictionary.registerOre("paneGlass", new afj(alv.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", alv.ae);
            OreDictionary.registerOre("chest", alv.bQ);
            OreDictionary.registerOre("chest", alv.cg);
            OreDictionary.registerOre("chestWood", alv.ae);
            OreDictionary.registerOre("chestEnder", alv.bQ);
            OreDictionary.registerOre("chestTrapped", alv.cg);
        }
        HashMap<afj, String> replacements = new HashMap<afj, String>();
        replacements.put(new afj(afl.B), "stickWood");
        replacements.put(new afj(alv.f), "plankWood");
        replacements.put(new afj(alv.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new afj(alv.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new afj(afl.n), "ingotGold");
        replacements.put(new afj(afl.m), "ingotIron");
        replacements.put(new afj(afl.l), "gemDiamond");
        replacements.put(new afj(afl.bZ), "gemEmerald");
        replacements.put(new afj(afl.cN), "gemPrismarine");
        replacements.put(new afj(afl.cO), "dustPrismarine");
        replacements.put(new afj(afl.aF), "dustRedstone");
        replacements.put(new afj(afl.bb), "dustGlowstone");
        replacements.put(new afj(afl.aR), "sugarcane");
        replacements.put(new afj(alv.aK), "blockCactus");
        replacements.put(new afj(afl.aS), "paper");
        replacements.put(new afj(afl.aU), "slimeball");
        replacements.put(new afj(afl.I), "string");
        replacements.put(new afj(afl.aN), "leather");
        replacements.put(new afj(afl.bC), "enderpearl");
        replacements.put(new afj(afl.K), "gunpowder");
        replacements.put(new afj(afl.ck), "netherStar");
        replacements.put(new afj(afl.J), "feather");
        replacements.put(new afj(afl.bf), "bone");
        replacements.put(new afj(afl.aX), "egg");
        replacements.put(new afj(alv.b), "stone");
        replacements.put(new afj(alv.e), "cobblestone");
        replacements.put(new afj(alv.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new afj(alv.aX), "glowstone");
        replacements.put(new afj(alv.w), "blockGlassColorless");
        replacements.put(new afj(alv.cI), "prismarine");
        replacements.put(new afj(alv.b, 1, 1), "stoneGranite");
        replacements.put(new afj(alv.b, 1, 2), "stoneGranitePolished");
        replacements.put(new afj(alv.b, 1, 3), "stoneDiorite");
        replacements.put(new afj(alv.b, 1, 4), "stoneDioritePolished");
        replacements.put(new afj(alv.b, 1, 5), "stoneAndesite");
        replacements.put(new afj(alv.b, 1, 6), "stoneAndesitePolished");
        replacements.put(new afj(alv.ae), "chestWood");
        replacements.put(new afj(alv.bQ), "chestEnder");
        replacements.put(new afj(alv.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i2 = 0; i2 < 16; ++i2) {
            afj dye = new afj(afl.be, 1, i2);
            afj block = new afj(alv.cG, 1, 15 - i2);
            afj pane = new afj(alv.cH, 1, 15 - i2);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i2], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i2], block);
                OreDictionary.registerOre("paneGlass" + dyes[i2], pane);
            }
            replacements.put(dye, "dye" + dyes[i2]);
            replacements.put(block, "blockGlass" + dyes[i2]);
            replacements.put(pane, "paneGlass" + dyes[i2]);
        }
        hasInit = true;
        afj[] replaceStacks = replacements.keySet().toArray(new afj[replacements.keySet().size()]);
        afj[] exclusions = new afj[]{new afj(alv.y), new afj(afl.bk), new afj(alv.bf), new afj(alv.U, 1, Short.MAX_VALUE), new afj(alv.aw), new afj(alv.bZ), new afj(alv.aO), new afj(alv.bo), new afj(alv.ad), new afj(alv.aP), new afj(alv.bp), new afj(alv.bU), new afj(alv.bV), new afj(alv.bq), new afj(alv.bV), new afj(alv.aR), new afj(alv.br), new afj(alv.bW), new afj(alv.aT), new afj(alv.bt), new afj(alv.cC), new afj(alv.aS), new afj(alv.bs), new afj(alv.cD), new afj(alv.bM), new afj(alv.bj), new afj(alv.di), new afj(afl.aH), new afj(afl.at), afj.a};
        List<aho> recipes = ahp.a().b();
        ArrayList<aho> recipesToRemove = new ArrayList<aho>();
        ArrayList<aho> recipesToAdd = new ArrayList<aho>();
        for (aho obj : recipes) {
            afj output;
            aho recipe;
            if (obj.getClass() == ahr.class) {
                recipe = (ahr)obj;
                output = ((ahr)recipe).b();
                if (!output.b() && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, ((ahr)recipe).c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe((ahr)recipe, replacements));
                continue;
            }
            if (obj.getClass() != ahs.class || !(output = ((ahs)(recipe = (ahs)obj)).b()).b() && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, ((ahs)recipe).b.toArray(new afj[((ahs)recipe).b.size()]), replaceStacks)) continue;
            recipesToRemove.add(obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((ahs)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipes", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            dd back = dd.a();
            idToStack.add(back);
            idToStackUn.add(back);
        }
        return val;
    }

    public static String getOreName(int id2) {
        return id2 >= 0 && id2 < idToName.size() ? idToName.get(id2) : "Unknown";
    }

    public static int[] getOreIDs(@Nonnull afj stack) {
        if (stack.b()) {
            throw new IllegalArgumentException("Stack can not be invalid!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        kq registryName = stack.c().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id2 = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id2);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id2 | stack.i() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x2 = 0; x2 < tmp.length; ++x2) {
            ret[x2] = tmp[x2];
        }
        return ret;
    }

    public static dd<afj> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static dd<afj> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static dd<afj> getOres(int id2) {
        return idToStackUn.size() > id2 ? idToStackUn.get(id2) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, afj[] inputs, afj ... targets) {
        for (afj input : inputs) {
            for (afj target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, dd<afj> inputs, afj ... targets) {
        for (afj input : inputs) {
            for (afj target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(@Nonnull afj target, @Nonnull afj input, boolean strict) {
        if (input.b() && !target.b() || !input.b() && target.b()) {
            return false;
        }
        return target.c() == input.c() && (target.i() == Short.MAX_VALUE && !strict || target.i() == input.i());
    }

    public static void registerOre(String name, afh ore) {
        OreDictionary.registerOre(name, new afj(ore));
    }

    public static void registerOre(String name, alu ore) {
        OreDictionary.registerOre(name, new afj(ore));
    }

    public static void registerOre(String name, @Nonnull afj ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, @Nonnull afj ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore.b()) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        kq registryName = ore.c().delegate.name();
        if (registryName == null) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String modContainerName = modContainer == null ? null : modContainer.getName();
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + modContainerName + " report it to them!", name, ore.c().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.i() != Short.MAX_VALUE) {
            hash |= ore.i() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.l();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id2 = 0; id2 < idToStack.size(); ++id2) {
            dd<afj> ores = idToStack.get(id2);
            if (ores == null) continue;
            for (afj ore : ores) {
                ArrayList ids;
                int hash;
                kq name = ore.c().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id2), ore.c().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.i() != Short.MAX_VALUE) {
                    hash |= ore.i() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id2);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final afj Ore;

        public OreRegisterEvent(String name, @Nonnull afj ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        @Nonnull
        public afj getOre() {
            return this.Ore;
        }
    }
}

