/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import jline.console.completer.Completer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConsoleCommandCompleter
implements Completer {
    private static final Logger logger = LogManager.getLogger();
    private final lh server;

    public ConsoleCommandCompleter(lh server) {
        this.server = (lh)Preconditions.checkNotNull((Object)server, (Object)"server");
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        boolean prefix;
        int len = buffer.length();
        if (buffer.isEmpty() || buffer.charAt(0) != '/') {
            buffer = '/' + buffer;
            prefix = false;
        } else {
            prefix = true;
        }
        final String input = buffer;
        ListenableFuture<List<String>> tabComplete = this.server.a(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ConsoleCommandCompleter.this.server.a(ConsoleCommandCompleter.this.server, input, ConsoleCommandCompleter.this.server.c(), false);
            }
        });
        try {
            List completions = (List)tabComplete.get();
            Collections.sort(completions);
            if (prefix) {
                candidates.addAll(completions);
            } else {
                for (String completion : completions) {
                    candidates.add(completion.charAt(0) == '/' ? completion.substring(1) : completion);
                }
            }
            int pos = buffer.lastIndexOf(32);
            if (pos == -1) {
                return cursor - len;
            }
            if (prefix) {
                return cursor - len + pos + 1;
            }
            return cursor - len + pos;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            logger.error("Failed to tab complete", (Throwable)e3);
        }
        return cursor;
    }
}

