/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Client;

import com.microsoft.Malmo.Client.ClientStateMachine;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.TCPInputPoller;
import com.microsoft.Malmo.Utils.TCPUtils;
import com.microsoft.Malmo.Utils.TimeHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.common.config.Configuration;

public class MalmoEnvServer
implements IWantToQuit {
    private static Profiler profiler = new Profiler();
    private static int nsteps = 0;
    private static boolean debug = false;
    private static String hello = "<MalmoEnv";
    private static boolean envPolicy = false;
    private Lock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    private EnvState envState = new EnvState();
    private Hashtable<String, Integer> initTokens = new Hashtable();
    static final long COND_WAIT_SECONDS = 3L;
    static final int BYTES_INT = 4;
    static final int BYTES_DOUBLE = 8;
    private static final Charset utf8 = Charset.forName("UTF-8");
    private int port;
    private TCPInputPoller missionPoller;
    private String version;
    private static final int stepTagLength = "<Step_>".length();
    private static final int findTagLength = "<Find>".length();
    private static final int closeTagLength = "<Close>".length();

    public MalmoEnvServer(String version, int port, TCPInputPoller missionPoller) {
        this.version = version;
        this.missionPoller = missionPoller;
        this.port = port;
    }

    public static void update(Configuration configs) {
        envPolicy = configs.get("envtype", "env", "false").getBoolean();
    }

    public static boolean isEnv() {
        return envPolicy;
    }

    public void serve() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.port);
        serverSocket.setPerformancePreferences(0, 2, 1);
        while (true) {
            try {
                while (true) {
                    final Socket socket = serverSocket.accept();
                    socket.setTcpNoDelay(true);
                    Thread thread = new Thread("EnvServerSocketHandler"){

                        @Override
                        public void run() {
                            boolean running = false;
                            try {
                                MalmoEnvServer.this.checkHello(socket);
                                block4: while (true) {
                                    DataInputStream din = new DataInputStream(socket.getInputStream());
                                    int hdr = din.readInt();
                                    byte[] data = new byte[hdr];
                                    din.readFully(data);
                                    String command = new String(data, utf8);
                                    if (command.startsWith("<Step")) {
                                        profiler.startSection("root");
                                        long start = System.nanoTime();
                                        MalmoEnvServer.this.step(command, socket, din);
                                        profiler.endSection();
                                        if (nsteps % 100 != 0 || !debug) continue;
                                        List dat = profiler.getProfilingData("root");
                                        int qq = 0;
                                        while (true) {
                                            if (qq >= dat.size()) continue block4;
                                            Profiler.Result res = (Profiler.Result)dat.get(qq);
                                            System.out.println(res.profilerName + " " + res.totalUsePercentage + " " + res.usePercentage);
                                            ++qq;
                                        }
                                    }
                                    if (command.startsWith("<Peek")) {
                                        MalmoEnvServer.this.peek(command, socket, din);
                                        continue;
                                    }
                                    if (command.startsWith("<Init")) {
                                        MalmoEnvServer.this.init(command, socket);
                                        continue;
                                    }
                                    if (command.startsWith("<Find")) {
                                        MalmoEnvServer.this.find(command, socket);
                                        continue;
                                    }
                                    if (command.startsWith("<MissionInit")) {
                                        if (!MalmoEnvServer.this.missionInit(din, command, socket)) continue;
                                        running = true;
                                        continue;
                                    }
                                    if (command.startsWith("<Quit")) {
                                        MalmoEnvServer.this.quit(command, socket);
                                        profiler.profilingEnabled = false;
                                        continue;
                                    }
                                    if (command.startsWith("<Exit")) {
                                        MalmoEnvServer.this.exit(command, socket);
                                        profiler.profilingEnabled = false;
                                        continue;
                                    }
                                    if (command.startsWith("<Close")) {
                                        MalmoEnvServer.this.close(command, socket);
                                        profiler.profilingEnabled = false;
                                        continue;
                                    }
                                    if (command.startsWith("<Status")) {
                                        MalmoEnvServer.this.status(command, socket);
                                        continue;
                                    }
                                    if (!command.startsWith("<Echo")) break;
                                    command = "<Echo>" + command + "</Echo>";
                                    data = command.getBytes(utf8);
                                    hdr = data.length;
                                    DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
                                    dout.writeInt(hdr);
                                    dout.write(data, 0, hdr);
                                    dout.flush();
                                }
                                throw new IOException("Unknown env service command");
                            }
                            catch (IOException ioe) {
                                try {
                                    if (running) {
                                        TCPUtils.Log(Level.INFO, "Want to quit on disconnect.");
                                        System.out.println("[LOGTOPY] Want to quit on disconnect.");
                                        MalmoEnvServer.this.setWantToQuit();
                                    }
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                    };
                    thread.start();
                }
            }
            catch (IOException ioe) {
                TCPUtils.Log(Level.SEVERE, "MalmoEnv service exits on " + ioe);
                continue;
            }
            break;
        }
    }

    private void checkHello(Socket socket) throws IOException {
        DataInputStream din = new DataInputStream(socket.getInputStream());
        int hdr = din.readInt();
        if (hdr <= 0 || hdr > hello.length() + 8) {
            throw new IOException("Invalid MalmoEnv hello header length");
        }
        byte[] data = new byte[hdr];
        din.readFully(data);
        if (!new String(data).startsWith(hello + this.version)) {
            throw new IOException("MalmoEnv invalid protocol or version - expected " + hello + this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean missionInit(DataInputStream din, String command, Socket socket) throws IOException {
        boolean started;
        boolean allTokensConsumed;
        block10: {
            String ipOriginator = socket.getInetAddress().getHostName();
            int hdr = din.readInt();
            byte[] data = new byte[hdr];
            din.readFully(data);
            String id = new String(data, utf8);
            TCPUtils.Log(Level.INFO, "Mission Init" + id);
            String[] token = id.split(":");
            String experimentId = token[0];
            int role = Integer.parseInt(token[1]);
            int reset = Integer.parseInt(token[2]);
            int agentCount = Integer.parseInt(token[3]);
            Boolean isSynchronous = Boolean.parseBoolean(token[4]);
            if (isSynchronous.booleanValue() && agentCount > 1) {
                throw new IOException("Synchronous mode currently does not support multiple agents.");
            }
            this.port = -1;
            allTokensConsumed = true;
            started = false;
            this.lock.lock();
            try {
                if (role == 0) {
                    String previousToken = experimentId + ":0:" + (reset - 1);
                    this.initTokens.remove(previousToken);
                    String myToken = experimentId + ":0:" + reset;
                    if (!this.initTokens.containsKey(myToken)) {
                        TCPUtils.Log(Level.INFO, "(Pre)Start " + role + " reset " + reset);
                        started = this.startUp(command, ipOriginator, experimentId, reset, agentCount, myToken, isSynchronous);
                        if (started) {
                            this.initTokens.put(myToken, 0);
                        }
                    } else {
                        started = true;
                    }
                    if (allTokensConsumed = this.areAllTokensConsumed(experimentId, reset, agentCount)) break block10;
                    try {
                        this.cond.await(3L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    allTokensConsumed = this.areAllTokensConsumed(experimentId, reset, agentCount);
                    break block10;
                }
                TCPUtils.Log(Level.INFO, "Start " + role + " reset " + reset);
                started = this.startUp(command, ipOriginator, experimentId, reset, agentCount, experimentId + ":" + role + ":" + reset, isSynchronous);
            }
            finally {
                this.lock.unlock();
            }
        }
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        dout.writeInt(4);
        dout.writeInt(allTokensConsumed && started ? 1 : 0);
        dout.flush();
        byte[] turnKey = "".getBytes();
        dout.writeInt(turnKey.length);
        dout.write(turnKey);
        dout.flush();
        return allTokensConsumed && started;
    }

    private boolean areAllTokensConsumed(String experimentId, int reset, int agentCount) {
        boolean allTokensConsumed = true;
        for (int i = 1; i < agentCount; ++i) {
            String tokenForAgent = experimentId + ":" + i + ":" + (reset - 1);
            if (!this.initTokens.containsKey(tokenForAgent)) continue;
            TCPUtils.Log(Level.FINE, "Mission init - unconsumed " + tokenForAgent);
            allTokensConsumed = false;
        }
        return allTokensConsumed;
    }

    private boolean startUp(String command, String ipOriginator, String experimentId, int reset, int agentCount, String myToken, Boolean isSynchronous) throws IOException {
        this.envState.reward = 0.0;
        this.envState.commands.clear();
        this.envState.obs = null;
        this.envState.info = "";
        this.envState.missionInit = command;
        this.envState.done = false;
        this.envState.quit = false;
        this.envState.turnKey = "";
        this.envState.lastTurnKey = "";
        this.envState.token = myToken;
        this.envState.experimentId = experimentId;
        this.envState.agentCount = agentCount;
        this.envState.reset = reset;
        this.envState.synchronous = isSynchronous;
        return this.startUpMission(command, ipOriginator);
    }

    private boolean startUpMission(String command, String ipOriginator) throws IOException {
        if (this.missionPoller == null) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.missionPoller.commandReceived(command, ipOriginator, dos);
        dos.flush();
        byte[] reply = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(reply);
        DataInputStream dis = new DataInputStream(bais);
        int hdr = dis.readInt();
        byte[] replyBytes = new byte[hdr];
        dis.readFully(replyBytes);
        String replyStr = new String(replyBytes);
        if (replyStr.equals("MALMOOK")) {
            TCPUtils.Log(Level.INFO, "MalmoEnvServer Mission starting ...");
            return true;
        }
        if (replyStr.equals("MALMOBUSY")) {
            TCPUtils.Log(Level.INFO, "MalmoEnvServer Busy - I want to quit");
            this.envState.quit = true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepAsync(String command, Socket socket, DataInputStream din) throws IOException {
        byte[] nextTurnKey;
        byte[] obs;
        boolean done;
        boolean sent;
        String info;
        double reward;
        DataOutputStream dout;
        boolean withInfo;
        boolean withTurnkey;
        block22: {
            byte[] stepTurnKey;
            String actions = command.substring(stepTagLength, command.length() - (stepTagLength + 2));
            int options = Character.getNumericValue(command.charAt(stepTagLength - 2));
            withTurnkey = options < 2;
            boolean bl = withInfo = options == 0 || options == 2;
            if (withTurnkey) {
                int hdr = din.readInt();
                stepTurnKey = new byte[hdr];
                din.readFully(stepTurnKey);
            } else {
                stepTurnKey = new byte[]{};
            }
            dout = new DataOutputStream(socket.getOutputStream());
            reward = 0.0;
            info = "";
            sent = false;
            this.lock.lock();
            try {
                done = this.envState.done;
                obs = this.getObservation(done);
                byte[] currentTurnKey = this.envState.turnKey.getBytes();
                boolean outOfTurn = true;
                nextTurnKey = currentTurnKey;
                if (!done && obs.length > 0 && actions != "") {
                    if (currentTurnKey.length == 0) {
                        if (stepTurnKey.length == 0) {
                            if (actions.contains("\n")) {
                                String[] cmds;
                                for (String cmd : cmds = actions.split("\\n")) {
                                    this.envState.commands.add(cmd);
                                }
                            } else if (!actions.isEmpty()) {
                                this.envState.commands.add(actions);
                            }
                            outOfTurn = false;
                            sent = true;
                        } else {
                            nextTurnKey = stepTurnKey;
                        }
                    } else if (stepTurnKey.length != 0 && Arrays.equals(currentTurnKey, stepTurnKey)) {
                        this.envState.commands.add(new String(stepTurnKey) + " " + actions);
                        outOfTurn = false;
                        this.envState.turnKey = "";
                        this.envState.lastTurnKey = new String(stepTurnKey);
                        sent = true;
                    }
                }
                if (!done && (obs.length <= 0 || outOfTurn)) break block22;
                reward = this.envState.reward;
                this.envState.reward = 0.0;
                if (withInfo) {
                    info = this.envState.info;
                    this.envState.info = "";
                    if (info.isEmpty() && !done) {
                        try {
                            this.cond.await(3L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        info = this.envState.info;
                        this.envState.info = "";
                        if (this.envState.obs != null && this.envState.obs != obs) {
                            obs = this.envState.obs;
                        }
                    }
                }
                this.envState.obs = null;
            }
            finally {
                this.lock.unlock();
            }
        }
        dout.writeInt(obs.length);
        dout.write(obs);
        dout.writeInt(10);
        dout.writeDouble(reward);
        dout.writeByte(done ? 1 : 0);
        dout.writeByte(sent ? 1 : 0);
        if (withInfo) {
            byte[] infoBytes = info.getBytes(utf8);
            dout.writeInt(infoBytes.length);
            dout.write(infoBytes);
        }
        if (withTurnkey) {
            dout.writeInt(nextTurnKey.length);
            dout.write(nextTurnKey);
        }
        dout.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stepSync(String command, Socket socket, DataInputStream din) throws IOException {
        byte[] obs;
        byte[] nextTurnKey;
        boolean done;
        byte[] stepTurnKey;
        boolean withInfo;
        ++nsteps;
        profiler.startSection("commandProcessing");
        String actions = command.substring(stepTagLength, command.length() - (stepTagLength + 2));
        int options = Character.getNumericValue(command.charAt(stepTagLength - 2));
        boolean withTurnkey = options < 2;
        boolean bl = withInfo = options == 0 || options == 2;
        if (withTurnkey) {
            int hdr = din.readInt();
            stepTurnKey = new byte[hdr];
            din.readFully(stepTurnKey);
        } else {
            stepTurnKey = new byte[]{};
        }
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        double reward = 0.0;
        String info = "";
        boolean sent = false;
        this.lock.lock();
        try {
            done = this.envState.done;
            byte[] currentTurnKey = this.envState.turnKey.getBytes();
            boolean outOfTurn = true;
            nextTurnKey = currentTurnKey;
            if (!done && actions != "") {
                if (currentTurnKey.length == 0) {
                    if (stepTurnKey.length == 0) {
                        if (actions.contains("\n")) {
                            String[] cmds;
                            for (String cmd : cmds = actions.split("\\n")) {
                                this.envState.commands.add(cmd);
                            }
                        } else if (!actions.isEmpty()) {
                            this.envState.commands.add(actions);
                        }
                        outOfTurn = false;
                        sent = true;
                    } else {
                        nextTurnKey = stepTurnKey;
                    }
                } else if (stepTurnKey.length != 0 && Arrays.equals(currentTurnKey, stepTurnKey)) {
                    this.envState.commands.add(new String(stepTurnKey) + " " + actions);
                    outOfTurn = false;
                    this.envState.turnKey = "";
                    this.envState.lastTurnKey = new String(stepTurnKey);
                    sent = true;
                }
            }
            this.lock.unlock();
            profiler.endSection();
            profiler.startSection("requestTick");
            while (!TimeHelper.SyncManager.requestTick().booleanValue() && !done) {
                Thread.yield();
            }
            profiler.endSection();
            profiler.startSection("waitForTick");
            while (!TimeHelper.SyncManager.isTickCompleted().booleanValue() && !done) {
                Thread.yield();
            }
            this.lock.lock();
            profiler.endSection();
            profiler.startSection("getObservation");
            obs = this.getObservation(done);
            profiler.endSection();
            profiler.startSection("getInfo");
            if (done || obs.length > 0 && !outOfTurn) {
                reward = this.envState.reward;
                this.envState.reward = 0.0;
                if (withInfo) {
                    info = this.envState.info;
                    this.envState.info = "";
                    if (info.isEmpty() && !done) {
                        try {
                            this.cond.await(3L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        info = this.envState.info;
                        this.envState.info = "";
                        if (this.envState.obs != null && this.envState.obs != obs) {
                            obs = this.envState.obs;
                        }
                    }
                }
                this.envState.obs = null;
            }
            profiler.endSection();
        }
        finally {
            this.lock.unlock();
        }
        profiler.startSection("writeObs");
        dout.writeInt(obs.length);
        dout.write(obs);
        dout.writeInt(10);
        dout.writeDouble(reward);
        dout.writeByte(done ? 1 : 0);
        dout.writeByte(sent ? 1 : 0);
        if (withInfo) {
            byte[] infoBytes = info.getBytes(utf8);
            dout.writeInt(infoBytes.length);
            dout.write(infoBytes);
        }
        if (withTurnkey) {
            dout.writeInt(nextTurnKey.length);
            dout.write(nextTurnKey);
        }
        profiler.endSection();
        profiler.startSection("flush");
        dout.flush();
        profiler.endSection();
    }

    private void step(String command, Socket socket, DataInputStream din) throws IOException {
        if (this.envState.synchronous) {
            this.stepSync(command, socket, din);
        } else {
            this.stepAsync(command, socket, din);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peek(String command, Socket socket, DataInputStream din) throws IOException {
        boolean done;
        byte[] obs;
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        String info = "";
        try {
            TimeHelper.SyncManager.debugLog("Waiting for pistol to fire.");
            while (!TimeHelper.SyncManager.hasServerFiredPistol().booleanValue()) {
                while (!TimeHelper.SyncManager.requestTick().booleanValue()) {
                    Thread.yield();
                }
                while (!TimeHelper.SyncManager.isTickCompleted().booleanValue()) {
                    Thread.yield();
                }
                Thread.yield();
            }
            TimeHelper.SyncManager.debugLog("Pistol fired!.");
            while (!TimeHelper.SyncManager.requestTick().booleanValue()) {
                Thread.yield();
            }
            while (!TimeHelper.SyncManager.isTickCompleted().booleanValue()) {
                Thread.yield();
            }
            while (!TimeHelper.SyncManager.requestTick().booleanValue()) {
                Thread.yield();
            }
            while (!TimeHelper.SyncManager.isTickCompleted().booleanValue()) {
                Thread.yield();
            }
            this.lock.lock();
            TimeHelper.SyncManager.debugLog("Getting observation.");
            obs = this.getObservation(false);
            TimeHelper.SyncManager.debugLog("Observation acquired.");
            done = this.envState.done;
            info = this.envState.info;
        }
        finally {
            this.lock.unlock();
        }
        dout.writeInt(obs.length);
        dout.write(obs);
        byte[] infoBytes = info.getBytes(utf8);
        dout.writeInt(infoBytes.length);
        dout.write(infoBytes);
        dout.writeInt(1);
        dout.writeByte(done ? 1 : 0);
        dout.flush();
    }

    private byte[] getObservation(boolean done) {
        byte[] obs = this.envState.obs;
        if (obs == null && !done && !this.envState.synchronous) {
            try {
                this.cond.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            obs = this.envState.obs;
        }
        if (obs == null) {
            obs = new byte[]{};
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String command, Socket socket) throws IOException {
        Integer port;
        block6: {
            this.lock.lock();
            try {
                String token = command.substring(findTagLength, command.length() - (findTagLength + 1));
                TCPUtils.Log(Level.INFO, "Find token? " + token);
                String[] tokenSplits = token.split(":");
                String experimentId = tokenSplits[0];
                int role = Integer.parseInt(tokenSplits[1]);
                int reset = Integer.parseInt(tokenSplits[2]);
                String previousToken = experimentId + ":" + role + ":" + (reset - 1);
                this.initTokens.remove(previousToken);
                this.cond.signalAll();
                port = this.initTokens.get(token);
                if (port != null) break block6;
                try {
                    this.cond.await(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                port = this.initTokens.get(token);
                if (port == null) {
                    port = 0;
                    TCPUtils.Log(Level.INFO, "Role " + role + " reset " + reset + " waiting for token.");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        dout.writeInt(4);
        dout.writeInt(port);
        dout.flush();
    }

    public boolean isSynchronous() {
        return this.envState.synchronous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String command, Socket socket) throws IOException {
        this.lock.lock();
        try {
            this.initTokens = new Hashtable();
            DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
            dout.writeInt(4);
            dout.writeInt(1);
            dout.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit(String command, Socket socket) throws IOException {
        this.lock.lock();
        try {
            if (!this.envState.done) {
                this.envState.quit = true;
                if (TimeHelper.SyncManager.isSynchronous().booleanValue()) {
                    TimeHelper.SyncManager.setSynchronous(false);
                }
            }
            DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
            dout.writeInt(4);
            dout.writeInt(this.envState.done ? 1 : 0);
            dout.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(String command, Socket socket) throws IOException {
        this.lock.lock();
        try {
            String token = command.substring(closeTagLength, command.length() - (closeTagLength + 1));
            this.initTokens.remove(token);
            DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
            dout.writeInt(4);
            dout.writeInt(1);
            dout.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(String command, Socket socket) throws IOException {
        this.lock.lock();
        try {
            String status = "{}";
            DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
            byte[] statusBytes = status.getBytes(utf8);
            dout.writeInt(statusBytes.length);
            dout.write(statusBytes);
            dout.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit(String command, Socket socket) throws IOException {
        this.lock.lock();
        try {
            TimeHelper.SyncManager.setSynchronous(false);
            DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
            dout.writeInt(4);
            dout.writeInt(1);
            dout.flush();
            ClientStateMachine.exitJava();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getCommand() {
        this.lock.lock();
        try {
            String command = this.envState.commands.poll();
            if (command == null) {
                String string = "";
                return string;
            }
            String string = command;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endMission() {
        this.lock.lock();
        try {
            this.envState.done = true;
            this.envState.quit = false;
            this.envState.missionInit = null;
            this.envState.turnKey = "";
            this.envState.lastTurnKey = "";
            if (this.envState.token != null) {
                this.initTokens.remove(this.envState.token);
                this.envState.token = null;
                this.envState.experimentId = null;
                this.envState.agentCount = 0;
                this.envState.reset = 0;
                this.cond.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observation(String info) {
        String pattern = "\"turn_key\":\"";
        int i = info.indexOf(pattern);
        String turnKey = "";
        if (i != -1) {
            turnKey = info.substring(i + pattern.length(), info.length() - 1);
            turnKey = turnKey.substring(0, turnKey.indexOf("\""));
        }
        this.lock.lock();
        try {
            if (!this.envState.turnKey.equals(turnKey)) {
                // empty if block
            }
            if (!this.envState.lastTurnKey.equals(turnKey)) {
                this.envState.turnKey = turnKey;
            }
            this.envState.info = info;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addRewards(double rewards) {
        this.lock.lock();
        try {
            this.envState.reward += rewards;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addFrame(byte[] frame) {
        this.lock.lock();
        try {
            this.envState.obs = frame;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyIntegrationServerStarted(int integrationServerPort) {
        this.lock.lock();
        try {
            if (this.envState.token != null) {
                TCPUtils.Log(Level.INFO, "Integration server start up - token: " + this.envState.token);
                this.addTokens(integrationServerPort, this.envState.token, this.envState.experimentId, this.envState.agentCount, this.envState.reset);
                this.cond.signalAll();
            } else {
                TCPUtils.Log(Level.WARNING, "No mission token on integration server start up!");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addTokens(int integratedServerPort, String myToken, String experimentId, int agentCount, int reset) {
        this.initTokens.put(myToken, integratedServerPort);
        for (int i = 1; i < agentCount; ++i) {
            String tokenForAgent = experimentId + ":" + i + ":" + reset;
            this.initTokens.put(tokenForAgent, integratedServerPort);
        }
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        this.lock.lock();
        try {
            boolean bl = this.envState.quit;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setWantToQuit() {
        this.lock.lock();
        try {
            this.envState.quit = true;
        }
        finally {
            if (TimeHelper.SyncManager.isSynchronous().booleanValue()) {
                TimeHelper.SyncManager.setSynchronous(false);
            }
            this.lock.unlock();
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getOutcome() {
        return "Env quit";
    }

    private class EnvState {
        String missionInit = null;
        String token = null;
        String experimentId = null;
        int agentCount = 0;
        int reset = 0;
        boolean quit = false;
        boolean synchronous = false;
        boolean done = false;
        double reward = 0.0;
        byte[] obs = null;
        String info = "";
        String turnKey = "";
        String lastTurnKey = "";
        LinkedList<String> commands = new LinkedList();

        private EnvState() {
        }
    }
}

