/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Client;

import com.microsoft.Malmo.Client.ClientState;
import com.microsoft.Malmo.Client.ClientStateMachine;
import com.microsoft.Malmo.Client.InternalKey;
import com.microsoft.Malmo.Client.KeyManager;
import com.microsoft.Malmo.Utils.CraftingHelper;
import com.microsoft.Malmo.Utils.ScreenHelper;
import com.microsoft.Malmo.Utils.TextureHelper;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.MouseHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.lwjgl.input.Mouse;

public class MalmoModClient {
    protected InputType inputType = InputType.HUMAN;
    protected MouseHook mouseHook;
    protected MouseHelper originalMouseHelper;
    private KeyManager keyManager;
    private ClientStateMachine stateMachine;
    private static final String INFO_MOUSE_CONTROL = "mouse_control";

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        TextureHelper.hookIntoRenderPipeline();
        this.setUpExtraKeys(settings);
        this.stateMachine = new ClientStateMachine(ClientState.WAITING_FOR_MOD_READY, this);
        this.originalMouseHelper = Minecraft.getMinecraft().mouseHelper;
        this.mouseHook = new MouseHook();
        this.mouseHook.isOverriding = true;
        Minecraft.getMinecraft().mouseHelper = this.mouseHook;
        this.setInputType(InputType.AI);
    }

    public void setInputType(InputType input) {
        if (this.stateMachine.currentMissionBehaviour() != null && this.stateMachine.currentMissionBehaviour().commandHandler != null) {
            this.stateMachine.currentMissionBehaviour().commandHandler.setOverriding(input == InputType.AI);
        }
        if (this.mouseHook != null) {
            this.mouseHook.isOverriding = input == InputType.AI;
        }
        System.setProperty("fml.noGrab", input == InputType.AI ? "true" : "false");
        this.inputType = input;
        if (input == InputType.HUMAN) {
            Minecraft.getMinecraft().mouseHelper.grabMouseCursor();
        } else {
            Minecraft.getMinecraft().mouseHelper.ungrabMouseCursor();
        }
        this.stateMachine.getScreenHelper().addFragment("Mouse: " + (Object)((Object)input), ScreenHelper.TextCategory.TXT_INFO, INFO_MOUSE_CONTROL);
    }

    private void setUpExtraKeys(GameSettings settings) {
        ArrayList<InternalKey> extraKeys = new ArrayList<InternalKey>();
        extraKeys.add(new InternalKey("key.toggleMalmo", 28, "key.categories.malmo"){

            @Override
            public void onPressed() {
                InputType it = MalmoModClient.this.inputType != InputType.AI ? InputType.AI : InputType.HUMAN;
                System.out.println("Toggling control between human and AI - now " + (Object)((Object)it));
                MalmoModClient.this.setInputType(it);
                super.onPressed();
            }
        });
        extraKeys.add(new InternalKey("key.handyTestHook", 22, "key.categories.malmo"){

            @Override
            public void onPressed() {
                try {
                    CraftingHelper.dumpRecipes("recipe_dump.txt");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.keyManager = new KeyManager(settings, extraKeys);
    }

    static enum InputType {
        HUMAN,
        AI;

    }

    public class MouseHook
    extends MouseHelper {
        public boolean isOverriding = true;
        private MouseEventListener observer = null;

        public void mouseXYChange() {
            if (this.isOverriding) {
                this.deltaX = 0;
                this.deltaY = 0;
                if (Mouse.isGrabbed()) {
                    Mouse.setGrabbed((boolean)false);
                }
            } else {
                super.mouseXYChange();
                if (this.observer != null) {
                    this.observer.onXYZChange(this.deltaX, this.deltaY, Mouse.getDWheel());
                }
            }
        }

        public void grabMouseCursor() {
            if (MalmoModClient.this.inputType != InputType.HUMAN) {
                return;
            }
            super.grabMouseCursor();
        }

        public void ungrabMouseCursor() {
            Mouse.setGrabbed((boolean)false);
        }

        public void requestEvents(MouseEventListener observer) {
            this.observer = observer;
        }
    }

    public static interface MouseEventListener {
        public void onXYZChange(int var1, int var2, int var3);
    }
}

