/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Client;

import com.microsoft.Malmo.Client.MalmoEnvServer;
import com.microsoft.Malmo.Client.VideoProducedObserver;
import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.Schemas.ClientAgentConnection;
import com.microsoft.Malmo.Schemas.MissionDiagnostics;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.AddressHelper;
import com.microsoft.Malmo.Utils.TCPSocketChannel;
import com.microsoft.Malmo.Utils.TextureHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class VideoHook {
    private static final long RETRY_GAP_NS = 5000000000L;
    private long retry_time_ns = 0L;
    private boolean isRunning = false;
    private MissionInit missionInit;
    private IVideoProducer videoProducer;
    public int failedTCPSendCount = 0;
    private TCPSocketChannel connection = null;
    private int renderWidth;
    private int renderHeight;
    ByteBuffer buffer = null;
    ByteBuffer headerbuffer = null;
    final int POS_HEADER_SIZE = 20;
    private long timeOfFirstFrame = 0L;
    private long timeOfLastFrame = 0L;
    private long framesSent = 0L;
    private VideoProducedObserver observer;
    private MalmoEnvServer envServer = null;

    public void start(MissionInit missionInit, IVideoProducer videoProducer, VideoProducedObserver observer, MalmoEnvServer envServer) {
        if (videoProducer == null) {
            return;
        }
        videoProducer.prepare(missionInit);
        this.missionInit = missionInit;
        this.videoProducer = videoProducer;
        this.observer = observer;
        this.envServer = envServer;
        this.buffer = BufferUtils.createByteBuffer((int)this.videoProducer.getRequiredBufferSize());
        this.headerbuffer = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
        this.renderWidth = videoProducer.getWidth();
        this.renderHeight = videoProducer.getHeight();
        this.resizeIfNeeded();
        Display.setResizable((boolean)false);
        ClientAgentConnection cac = missionInit.getClientAgentConnection();
        if (cac == null) {
            return;
        }
        String agentIPAddress = cac.getAgentIPAddress();
        int agentPort = 0;
        switch (videoProducer.getVideoType()) {
            case LUMINANCE: {
                agentPort = cac.getAgentLuminancePort();
                break;
            }
            case DEPTH_MAP: {
                agentPort = cac.getAgentDepthPort();
                break;
            }
            case VIDEO: {
                agentPort = cac.getAgentVideoPort();
                break;
            }
            case COLOUR_MAP: {
                agentPort = cac.getAgentColourMapPort();
            }
        }
        this.connection = new TCPSocketChannel(agentIPAddress, agentPort, "vid");
        this.failedTCPSendCount = 0;
        try {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        catch (Exception e) {
            System.out.println("Failed to register video hook: " + e);
        }
        this.isRunning = true;
    }

    private void resizeIfNeeded() {
        int oldRenderWidth = Display.getWidth();
        int oldRenderHeight = Display.getHeight();
        if (this.renderWidth == oldRenderWidth && this.renderHeight == oldRenderHeight) {
            return;
        }
        try {
            int old_x = Display.getX();
            int old_y = Display.getY();
            Display.setLocation((int)old_x, (int)old_y);
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.renderWidth, this.renderHeight));
            System.out.println("Resized the window");
        }
        catch (LWJGLException e) {
            System.out.println("Failed to resize the window!");
            e.printStackTrace();
        }
        this.forceResize(this.renderWidth, this.renderHeight);
    }

    public void stop(MissionDiagnostics diags) {
        if (!this.isRunning) {
            return;
        }
        if (this.videoProducer != null) {
            this.videoProducer.cleanup();
        }
        try {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        catch (Exception e) {
            System.out.println("Failed to unregister video hook: " + e);
        }
        this.connection.close();
        this.isRunning = false;
        Display.setResizable((boolean)true);
        if (diags != null) {
            MissionDiagnostics.VideoData vd = new MissionDiagnostics.VideoData();
            vd.setFrameType(this.videoProducer.getVideoType().toString());
            vd.setFramesSent((int)this.framesSent);
            if (this.timeOfLastFrame == this.timeOfFirstFrame) {
                vd.setAverageFpsSent(new BigDecimal(0));
            } else {
                vd.setAverageFpsSent(new BigDecimal(1000.0 * (double)this.framesSent / (double)(this.timeOfLastFrame - this.timeOfFirstFrame)));
            }
            diags.getVideoData().add(vd);
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.resizeIfNeeded();
        }
    }

    @SubscribeEvent
    public void postRender(RenderWorldLastEvent event) {
        boolean colourmapVideoProducer;
        boolean colourmapFrame = TextureHelper.colourmapFrame;
        boolean bl = colourmapVideoProducer = this.videoProducer.getVideoType() == IVideoProducer.VideoType.COLOUR_MAP;
        if (colourmapFrame != colourmapVideoProducer) {
            return;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        float x = (float)(player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)event.getPartialTicks());
        float y = (float)(player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)event.getPartialTicks());
        float z = (float)(player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)event.getPartialTicks());
        float yaw = player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * event.getPartialTicks();
        float pitch = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * event.getPartialTicks();
        long time_before_ns = System.nanoTime();
        if (this.observer != null) {
            this.observer.frameProduced();
        }
        if (time_before_ns < this.retry_time_ns) {
            return;
        }
        boolean success = false;
        try {
            long time_after_render_ns;
            int size = this.videoProducer.getRequiredBufferSize();
            if (AddressHelper.getMissionControlPort() == 0) {
                success = true;
                if (this.envServer != null) {
                    byte[] data = new byte[size];
                    this.buffer.clear();
                    this.videoProducer.getFrame(this.missionInit, this.buffer);
                    this.buffer.get(data);
                    time_after_render_ns = System.nanoTime();
                    this.envServer.addFrame(data);
                } else {
                    time_after_render_ns = System.nanoTime();
                }
            } else {
                this.buffer.clear();
                this.headerbuffer.clear();
                this.headerbuffer.putFloat(x);
                this.headerbuffer.putFloat(y);
                this.headerbuffer.putFloat(z);
                this.headerbuffer.putFloat(yaw);
                this.headerbuffer.putFloat(pitch);
                this.videoProducer.getFrame(this.missionInit, this.buffer);
                this.headerbuffer.flip();
                ByteBuffer[] buffers = new ByteBuffer[]{this.headerbuffer, this.buffer};
                time_after_render_ns = System.nanoTime();
                success = this.connection.sendTCPBytes(buffers, size + 20);
            }
            long time_after_ns = System.nanoTime();
            float ms_send = (float)(time_after_ns - time_after_render_ns) / 1000000.0f;
            float ms_render = (float)(time_after_render_ns - time_before_ns) / 1000000.0f;
            if (success) {
                this.failedTCPSendCount = 0;
                this.timeOfLastFrame = System.currentTimeMillis();
                if (this.timeOfFirstFrame == 0L) {
                    this.timeOfFirstFrame = this.timeOfLastFrame;
                }
                ++this.framesSent;
            }
        }
        catch (Exception e) {
            System.out.format(e.getMessage(), new Object[0]);
        }
        if (!success) {
            System.out.format("Failed to send frame - will retry in %d seconds\n", 5L);
            this.retry_time_ns = time_before_ns + 5000000000L;
            ++this.failedTCPSendCount;
        }
    }

    private void forceResize(int width, int height) {
        boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        String resizeMethodName = devEnv ? "resize" : "func_71370_a";
        Class[] cArgs = new Class[]{Integer.TYPE, Integer.TYPE};
        try {
            Method resize = Minecraft.class.getDeclaredMethod(resizeMethodName, cArgs);
            resize.setAccessible(true);
            resize.invoke((Object)Minecraft.getMinecraft(), width, height);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

