/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo;

import com.microsoft.Malmo.StateEpisode;
import com.microsoft.Malmo.Utils.TimeHelper;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EpisodeEventWrapper {
    private StateEpisode stateEpisode = null;
    ReentrantReadWriteLock stateEpisodeLock = new ReentrantReadWriteLock();

    public StateEpisode setStateEpisode(StateEpisode stateEpisode) {
        this.stateEpisodeLock.writeLock().lock();
        StateEpisode lastEpisode = this.stateEpisode;
        this.stateEpisode = stateEpisode;
        this.stateEpisodeLock.writeLock().unlock();
        return lastEpisode;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            try {
                this.stateEpisode.onClientTick(ev);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onSyncTickEvent(TimeHelper.SyncTickEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onSyncTick(ev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onServerTick(ev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onPlayerTick(ev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onRenderTick(ev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load cev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onChunkLoad(cev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onPlayerDies(LivingDeathEvent lde) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onPlayerDies(lde);
        }
        this.stateEpisodeLock.readLock().unlock();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID() == "malmomod") {
            this.stateEpisodeLock.readLock().lock();
            if (this.stateEpisode != null && this.stateEpisode.isLive()) {
                this.stateEpisode.onConfigChanged(ev);
            }
            this.stateEpisodeLock.readLock().unlock();
        }
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent ev) {
        this.stateEpisodeLock.readLock().lock();
        if (this.stateEpisode != null && this.stateEpisode.isLive()) {
            this.stateEpisode.onPlayerJoinedServer(ev);
        }
        this.stateEpisodeLock.readLock().unlock();
    }
}

