/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.MissionHandlers.CommandForWheeledRobotNavigationImplementation;
import com.microsoft.Malmo.Schemas.AbsoluteMovementCommand;
import com.microsoft.Malmo.Schemas.AbsoluteMovementCommands;
import com.microsoft.Malmo.Schemas.MissionInit;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class AbsoluteMovementCommandsImplementation
extends CommandBase {
    private boolean isOverriding = false;
    private boolean setX = false;
    private boolean setY = false;
    private boolean setZ = false;
    private boolean setYaw = false;
    private boolean setPitch = false;
    private float x;
    private float y;
    private float z;
    private float rotationYaw;
    private float rotationPitch;

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof AbsoluteMovementCommands)) {
            return false;
        }
        AbsoluteMovementCommands amparams = (AbsoluteMovementCommands)params;
        this.setUpAllowAndDenyLists(amparams.getModifierList());
        return true;
    }

    private void sendChanges() {
        float pitch;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player == null) {
            return;
        }
        double x = this.setX ? (double)this.x : 0.0;
        double y = this.setY ? (double)this.y : 0.0;
        double z = this.setZ ? (double)this.z : 0.0;
        float yaw = this.setYaw ? this.rotationYaw : 0.0f;
        float f = pitch = this.setPitch ? this.rotationPitch : 0.0f;
        if (this.setX || this.setY || this.setZ || this.setYaw || this.setPitch) {
            MalmoMod.network.sendToServer((IMessage)new TeleportMessage(x, y, z, yaw, pitch, this.setX, this.setY, this.setZ, this.setYaw, this.setPitch));
            if (this.setYaw || this.setPitch) {
                CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent event = new CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent(this.setYaw, this.rotationYaw, this.setPitch, this.rotationPitch);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.setPitch = false;
            this.setYaw = false;
            this.setZ = false;
            this.setY = false;
            this.setX = false;
        }
    }

    @Override
    public boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb == null || verb.length() == 0) {
            return false;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.TPX.value())) {
            this.setX = true;
            this.x = Float.valueOf(parameter).floatValue();
            this.sendChanges();
            return true;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.TPY.value())) {
            this.setY = true;
            this.y = Float.valueOf(parameter).floatValue();
            this.sendChanges();
            return true;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.TPZ.value())) {
            this.setZ = true;
            this.z = Float.valueOf(parameter).floatValue();
            this.sendChanges();
            return true;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.TP.value())) {
            String[] coords = parameter.split(" ");
            if (coords.length != 3) {
                return false;
            }
            this.setZ = true;
            this.setY = true;
            this.setX = true;
            this.x = Float.valueOf(coords[0]).floatValue();
            this.y = Float.valueOf(coords[1]).floatValue();
            this.z = Float.valueOf(coords[2]).floatValue();
            this.sendChanges();
            return true;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.SET_YAW.value())) {
            this.setYaw = true;
            this.rotationYaw = Float.valueOf(parameter).floatValue();
            this.sendChanges();
            return true;
        }
        if (verb.equalsIgnoreCase(AbsoluteMovementCommand.SET_PITCH.value())) {
            this.setPitch = true;
            this.rotationPitch = Float.valueOf(parameter).floatValue();
            this.sendChanges();
            return true;
        }
        return false;
    }

    @Override
    public void install(MissionInit missionInit) {
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class TeleportMessageHandler
    implements IMessageHandler<TeleportMessage, IMessage> {
        public IMessage onMessage(final TeleportMessage message, final MessageContext ctx) {
            Object mainThread = null;
            mainThread = ctx.side == Side.CLIENT ? Minecraft.getMinecraft() : (WorldServer)ctx.getServerHandler().playerEntity.world;
            mainThread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    EnumSet<SPacketPlayerPosLook.EnumFlags> enumset = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
                    if (!message.setX) {
                        enumset.add(SPacketPlayerPosLook.EnumFlags.X);
                    }
                    if (!message.setY) {
                        enumset.add(SPacketPlayerPosLook.EnumFlags.Y);
                    }
                    if (!message.setZ) {
                        enumset.add(SPacketPlayerPosLook.EnumFlags.Z);
                    }
                    if (!message.setYaw) {
                        enumset.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
                    }
                    if (!message.setPitch) {
                        enumset.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
                    }
                    EntityPlayerMP player = ctx.getServerHandler().playerEntity;
                    player.dismountRidingEntity();
                    player.connection.setPlayerLocation(message.x, message.y, message.z, message.yaw, message.pitch, enumset);
                    player.setRotationYawHead(message.yaw);
                }
            });
            return null;
        }
    }

    public static class TeleportMessage
    implements IMessage {
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;
        private float yaw = 0.0f;
        private float pitch = 0.0f;
        private boolean setX = false;
        private boolean setY = false;
        private boolean setZ = false;
        private boolean setYaw = false;
        private boolean setPitch = false;

        public TeleportMessage() {
        }

        public TeleportMessage(double x, double y, double z, float yaw, float pitch, boolean setX, boolean setY, boolean setZ, boolean setYaw, boolean setPitch) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.setX = setX;
            this.setY = setY;
            this.setZ = setZ;
            this.setYaw = setYaw;
            this.setPitch = setPitch;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.yaw = buf.readFloat();
            this.pitch = buf.readFloat();
            this.setX = buf.readBoolean();
            this.setY = buf.readBoolean();
            this.setZ = buf.readBoolean();
            this.setYaw = buf.readBoolean();
            this.setPitch = buf.readBoolean();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeFloat(this.yaw);
            buf.writeFloat(this.pitch);
            buf.writeBoolean(this.setX);
            buf.writeBoolean(this.setY);
            buf.writeBoolean(this.setZ);
            buf.writeBoolean(this.setYaw);
            buf.writeBoolean(this.setPitch);
        }
    }
}

