/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.RewardForCollectingItemImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForDiscardingItemImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForItemBase;
import com.microsoft.Malmo.Schemas.AgentQuitFromPossessingItem;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithDescription;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AgentQuitFromPossessingItemImplementation
extends HandlerBase
implements IWantToQuit {
    private AgentQuitFromPossessingItem params;
    private HashMap<String, Integer> possessedItems;
    private List<ItemQuitMatcher> matchers;
    private String quitCode = "";
    private boolean wantToQuit = false;

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof AgentQuitFromPossessingItem)) {
            return false;
        }
        this.params = (AgentQuitFromPossessingItem)params;
        this.matchers = new ArrayList<ItemQuitMatcher>();
        for (BlockOrItemSpecWithDescription bs : this.params.getItem()) {
            this.matchers.add(new ItemQuitMatcher(bs));
        }
        return true;
    }

    @Override
    public boolean doIWantToQuit(MissionInit missionInit) {
        return this.wantToQuit;
    }

    @Override
    public String getOutcome() {
        return this.quitCode;
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.possessedItems = new HashMap();
    }

    @Override
    public void cleanup() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onGainItem(RewardForCollectingItemImplementation.GainItemEvent event) {
        if (event.stack != null && event.cause == 0) {
            this.checkForMatch(event.stack);
        }
    }

    @SubscribeEvent
    public void onPickupItem(EntityItemPickupEvent event) {
        if (event.getItem() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            this.checkForMatch(event.getItem().getEntityItem());
        }
    }

    @SubscribeEvent
    public void onItemCraft(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.crafting.isEmpty()) {
            this.checkForMatch(event.crafting);
        }
    }

    @SubscribeEvent
    public void onItemSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.isEmpty()) {
            this.checkForMatch(event.smelting);
        }
    }

    @SubscribeEvent
    public void onLoseItem(RewardForDiscardingItemImplementation.LoseItemEvent event) {
        if (event.stack != null && event.cause == 0) {
            this.removeCollectedItemCount(event.stack);
        }
    }

    @SubscribeEvent
    public void onDropItem(ItemTossEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP) {
            this.removeCollectedItemCount(event.getEntityItem().getEntityItem());
        }
    }

    @SubscribeEvent
    public void onDestroyItem(PlayerDestroyItemEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            this.removeCollectedItemCount(event.getOriginal());
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (!event.isCanceled() && event.getPlacedBlock() != null && event.getPlayer() instanceof EntityPlayerMP) {
            this.removeCollectedItemCount(new ItemStack(event.getPlacedBlock().getBlock()));
        }
    }

    private boolean getVariant(ItemStack is) {
        for (ItemQuitMatcher matcher : this.matchers) {
            if (!matcher.allowedItemTypes.contains(is.getItem().getUnlocalizedName())) continue;
            if (matcher.matchSpec.getColour() != null && matcher.matchSpec.getColour().size() > 0) {
                return true;
            }
            if (matcher.matchSpec.getVariant() == null || matcher.matchSpec.getVariant().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addCollectedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            int prev = this.possessedItems.get(is.getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getUnlocalizedName());
            this.possessedItems.put(is.getUnlocalizedName(), prev + is.getCount());
        } else {
            int prev = this.possessedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getItem().getUnlocalizedName());
            this.possessedItems.put(is.getItem().getUnlocalizedName(), prev + is.getCount());
        }
    }

    private void removeCollectedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            int prev = this.possessedItems.get(is.getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getUnlocalizedName());
            this.possessedItems.put(is.getUnlocalizedName(), prev - is.getCount());
        } else {
            int prev = this.possessedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getItem().getUnlocalizedName());
            this.possessedItems.put(is.getItem().getUnlocalizedName(), prev - is.getCount());
        }
    }

    private int getCollectedItemCount(ItemStack is) {
        boolean variant = this.getVariant(is);
        if (variant) {
            return this.possessedItems.get(is.getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getUnlocalizedName());
        }
        return this.possessedItems.get(is.getItem().getUnlocalizedName()) == null ? 0 : this.possessedItems.get(is.getItem().getUnlocalizedName());
    }

    private void checkForMatch(ItemStack is) {
        int savedCollected = this.getCollectedItemCount(is);
        if (is != null) {
            for (ItemQuitMatcher matcher : this.matchers) {
                if (!matcher.matches(is)) continue;
                if (savedCollected != 0) {
                    if (is.getCount() + savedCollected < matcher.matchSpec.getAmount()) continue;
                    this.quitCode = matcher.description();
                    this.wantToQuit = true;
                    continue;
                }
                if (is.getCount() < matcher.matchSpec.getAmount()) continue;
                this.quitCode = matcher.description();
                this.wantToQuit = true;
            }
            this.addCollectedItemCount(is);
        }
    }

    public static class ItemQuitMatcher
    extends RewardForItemBase.ItemMatcher {
        String description;

        ItemQuitMatcher(BlockOrItemSpecWithDescription spec) {
            super(spec);
            this.description = spec.getDescription();
        }

        String description() {
            return this.description;
        }
    }
}

