/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.AnimationDecorator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.AnimationDrawingHelper;
import com.microsoft.Malmo.Utils.EvaluationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AnimationDecoratorImplementation
extends HandlerBase
implements IWorldDecorator {
    AnimationDecorator params = null;
    AnimationDrawingHelper drawContext = new AnimationDrawingHelper();
    Vec3d origin;
    Vec3d velocity;
    Vec3d minCanvas;
    Vec3d maxCanvas;
    int frameCount = 0;
    int tickCounter = 0;
    Random rng;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof AnimationDecorator)) {
            return false;
        }
        this.params = (AnimationDecorator)params;
        if (this.params.getLinear() != null) {
            AnimationDecorator.Linear linear = this.params.getLinear();
            this.origin = new Vec3d(linear.getInitialPos().getX().doubleValue(), linear.getInitialPos().getY().doubleValue(), linear.getInitialPos().getZ().doubleValue());
            this.velocity = new Vec3d(linear.getInitialVelocity().getX().doubleValue(), linear.getInitialVelocity().getY().doubleValue(), linear.getInitialVelocity().getZ().doubleValue());
            this.minCanvas = new Vec3d((double)linear.getCanvasBounds().getMin().getX(), (double)linear.getCanvasBounds().getMin().getY(), (double)linear.getCanvasBounds().getMin().getZ());
            this.maxCanvas = new Vec3d((double)linear.getCanvasBounds().getMax().getX(), (double)linear.getCanvasBounds().getMax().getY(), (double)linear.getCanvasBounds().getMax().getZ());
        } else {
            long seed = 0L;
            String strSeed = this.params.getParametric().getSeed();
            seed = strSeed == null || strSeed == "" || strSeed.equals("random") ? System.currentTimeMillis() : Long.parseLong(strSeed);
            this.rng = new Random(seed);
            try {
                double x = EvaluationHelper.eval(this.params.getParametric().getX(), 0.0f, this.rng);
                double y = EvaluationHelper.eval(this.params.getParametric().getY(), 0.0f, this.rng);
                double z = EvaluationHelper.eval(this.params.getParametric().getZ(), 0.0f, this.rng);
                this.origin = new Vec3d(x, y, z);
            }
            catch (Exception e) {
                System.out.println("ERROR: malformed equations in animation - check these:");
                System.out.println("        " + this.params.getParametric().getX());
                System.out.println("        " + this.params.getParametric().getY());
                System.out.println("        " + this.params.getParametric().getZ());
            }
        }
        return true;
    }

    @Override
    public void buildOnWorld(MissionInit missionInit, World world) throws IWorldDecorator.DecoratorException {
        if (this.origin == null) {
            throw new IWorldDecorator.DecoratorException("Origin not specified - check syntax of equations?");
        }
        try {
            this.drawContext.setOrigin(this.origin);
            this.drawContext.Draw(this.params.getDrawingDecorator(), world);
        }
        catch (Exception e) {
            throw new IWorldDecorator.DecoratorException("Error trying to build animation - " + e.getMessage());
        }
    }

    @Override
    public void update(World world) {
        ++this.tickCounter;
        if (this.tickCounter < this.params.getTicksPerUpdate()) {
            ++this.tickCounter;
            return;
        }
        ++this.frameCount;
        this.tickCounter = 0;
        BlockPos oldpos = new BlockPos(this.origin);
        if (this.params.getLinear() != null) {
            AnimationDecorator.Linear linear = this.params.getLinear();
            double dx = this.velocity.xCoord;
            double dy = this.velocity.yCoord;
            double dz = this.velocity.zCoord;
            if (this.drawContext.getMax().xCoord + dx > (double)linear.getCanvasBounds().getMax().getX() + 1.0 || this.drawContext.getMin().xCoord + dx < (double)linear.getCanvasBounds().getMin().getX()) {
                dx = -dx;
            }
            if (this.drawContext.getMax().yCoord + dy > (double)linear.getCanvasBounds().getMax().getY() + 1.0 || this.drawContext.getMin().yCoord + dy < (double)linear.getCanvasBounds().getMin().getY()) {
                dy = -dy;
            }
            if (this.drawContext.getMax().zCoord + dz > (double)linear.getCanvasBounds().getMax().getZ() + 1.0 || this.drawContext.getMin().zCoord + dz < (double)linear.getCanvasBounds().getMin().getZ()) {
                dz = -dz;
            }
            this.velocity = new Vec3d(dx, dy, dz);
            this.origin = this.origin.add(this.velocity);
        } else {
            try {
                double x = EvaluationHelper.eval(this.params.getParametric().getX(), this.frameCount, this.rng);
                double y = EvaluationHelper.eval(this.params.getParametric().getY(), this.frameCount, this.rng);
                double z = EvaluationHelper.eval(this.params.getParametric().getZ(), this.frameCount, this.rng);
                this.origin = new Vec3d(x, y, z);
            }
            catch (Exception e) {
                System.out.println("ERROR - check syntax of equations for animation.");
            }
        }
        BlockPos newpos = new BlockPos(this.origin);
        if (oldpos.equals((Object)newpos)) {
            return;
        }
        try {
            this.drawContext.setOrigin(this.origin);
            this.drawContext.Draw(this.params.getDrawingDecorator(), world);
            this.drawContext.clearPrevious(world);
        }
        catch (Exception e) {
            System.out.println("ERROR - can not draw animation.");
        }
    }

    @Override
    public boolean getExtraAgentHandlersAndData(List<Object> handlers, Map<String, String> data) {
        return false;
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean targetedUpdate(String nextAgentName) {
        return false;
    }

    @Override
    public void getTurnParticipants(ArrayList<String> participants, ArrayList<Integer> participantSlots) {
    }
}

