/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.CommandListModifier;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.List;

public abstract class CommandBase
extends HandlerBase
implements ICommandHandler {
    private List<String> commandsAllowList = null;
    private List<String> commandsDenyList = null;

    protected boolean isCommandAllowed(String verb) {
        if (this.commandsDenyList == null && this.commandsAllowList == null) {
            return true;
        }
        if (this.commandsDenyList != null && this.commandsDenyList.contains(verb.toLowerCase())) {
            System.out.println("command verb on the deny-list: " + verb);
            return false;
        }
        if (this.commandsAllowList != null && !this.commandsAllowList.contains(verb.toLowerCase())) {
            System.out.println("command verb not on the allow-list: " + verb);
            for (String v : this.commandsAllowList) {
                System.out.println("(" + v + " is allowed)");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(String command, MissionInit missionInit) {
        String parameter;
        if (command == null || command.length() == 0) {
            return false;
        }
        String[] parms = command.split(" ", 2);
        String verb = parms[0].toLowerCase();
        String string = parameter = parms.length > 1 ? parms[1] : "";
        if (!this.isCommandAllowed(verb)) {
            return false;
        }
        return this.onExecute(verb, parameter, missionInit);
    }

    protected void setUpAllowAndDenyLists(CommandListModifier list) {
        this.commandsDenyList = null;
        this.commandsAllowList = null;
        if (list != null && list.getCommand() != null) {
            ArrayList<String> listcopy = new ArrayList<String>();
            listcopy.addAll(list.getCommand());
            if (list.getType().equalsIgnoreCase("deny-list")) {
                this.commandsDenyList = listcopy;
            } else {
                this.commandsAllowList = listcopy;
            }
        }
    }

    protected abstract boolean onExecute(String var1, String var2, MissionInit var3);
}

