/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyBindingMap;

public class CommandForKey
extends CommandBase {
    public static final String DOWN_COMMAND_STRING = "1";
    public static final String UP_COMMAND_STRING = "0";
    private KeyHook keyHook = null;
    private KeyBinding originalBinding = null;
    private int originalBindingIndex;
    private String keyDescription;

    private KeyHook create(KeyBinding key) {
        if (key != null && key instanceof KeyHook) {
            return (KeyHook)key;
        }
        return new KeyHook(key.getKeyDescription(), key.getKeyCode(), key.getKeyCategory());
    }

    public CommandForKey(String key) {
        this.keyDescription = key;
    }

    @Override
    public boolean isOverriding() {
        return this.keyHook != null ? this.keyHook.isOverridingPresses : false;
    }

    @Override
    public void setOverriding(boolean b) {
        if (this.keyHook != null) {
            this.keyHook.isDown = false;
            this.keyHook.justPressed = false;
            this.keyHook.isOverridingPresses = b;
        }
    }

    public void setKeyEventObserver(KeyEventListener observer) {
        this.keyHook.setObserver(observer);
    }

    @Override
    public void install(MissionInit missionInit) {
        Field[] kbfields;
        int i;
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        boolean createdHook = false;
        Field[] fields = GameSettings.class.getFields();
        for (i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (f.getType() != KeyBinding.class) continue;
            try {
                KeyBinding kb = (KeyBinding)f.get(settings);
                if (kb == null || !kb.getKeyDescription().equals(this.keyDescription)) continue;
                this.originalBinding = kb;
                this.keyHook = this.create(this.originalBinding);
                createdHook = true;
                f.set(settings, (Object)this.keyHook);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < settings.keyBindings.length; ++i) {
            if (!settings.keyBindings[i].getKeyDescription().equals(this.keyDescription)) continue;
            this.originalBindingIndex = i;
            if (!createdHook) {
                this.originalBinding = settings.keyBindings[i];
                this.keyHook = this.create(this.originalBinding);
                createdHook = true;
            }
            settings.keyBindings[i] = this.keyHook;
        }
        for (i = 0; i < settings.keyBindsHotbar.length; ++i) {
            if (!settings.keyBindsHotbar[i].getKeyDescription().equals(this.keyDescription)) continue;
            this.originalBindingIndex = i;
            if (!createdHook) {
                this.originalBinding = settings.keyBindsHotbar[i];
                this.keyHook = this.create(this.originalBinding);
                createdHook = true;
            }
            settings.keyBindsHotbar[i] = this.keyHook;
        }
        for (Field f : kbfields = KeyBinding.class.getDeclaredFields()) {
            if (f.getType() != KeyBindingMap.class) continue;
            try {
                f.setAccessible(true);
                KeyBindingMap kbp = (KeyBindingMap)f.get(null);
                while (kbp.lookupAll(this.keyHook.getKeyCode()).size() > 1) {
                    kbp.removeKey(this.originalBinding);
                }
                return;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        return this.keyHook != null ? this.keyHook.execute(verb, parameter) : false;
    }

    public KeyBinding getKeyBinding() {
        return this.keyHook;
    }

    private class KeyHook
    extends KeyBinding {
        private boolean isOverridingPresses;
        private boolean isDown;
        private boolean justPressed;
        private String commandString;
        private boolean keyDownEventSent;
        private boolean lastPressedState;
        private boolean lastKeydownState;
        private KeyEventListener observer;

        public KeyHook(String description, int keyCode, String category) {
            super(description, keyCode, category);
            this.isOverridingPresses = false;
            this.isDown = false;
            this.justPressed = false;
            this.commandString = null;
            this.keyDownEventSent = false;
            this.lastPressedState = false;
            this.lastKeydownState = false;
            this.observer = null;
        }

        public void press() {
            this.isDown = true;
            this.justPressed = true;
        }

        public void release() {
            this.isDown = false;
        }

        public boolean isKeyDown() {
            boolean bReturn;
            boolean bl = bReturn = this.isOverridingPresses ? this.isDown : super.isKeyDown();
            if (this.observer != null && !this.isOverridingPresses) {
                if (bReturn && !this.keyDownEventSent) {
                    this.observer.onKeyChange(this.getCommandString(), true);
                    this.keyDownEventSent = true;
                } else if (!bReturn && this.keyDownEventSent) {
                    this.observer.onKeyChange(this.getCommandString(), false);
                    this.keyDownEventSent = false;
                }
            }
            return bReturn;
        }

        public boolean isPressed() {
            boolean bReturn = this.isOverridingPresses ? this.justPressed : super.isPressed();
            this.justPressed = false;
            if (this.observer != null && !this.isOverridingPresses && bReturn) {
                this.observer.onKeyChange(this.getCommandString(), true);
                this.keyDownEventSent = true;
            }
            return bReturn;
        }

        private String getCommandString() {
            if (this.commandString == null) {
                this.commandString = this.getKeyDescription();
                int splitpoint = this.commandString.indexOf(".");
                if (splitpoint != -1 && splitpoint != this.commandString.length()) {
                    this.commandString = this.commandString.substring(splitpoint + 1);
                }
            }
            return this.commandString;
        }

        public boolean execute(String verb, String parameter) {
            if (verb != null && verb.equalsIgnoreCase(this.getCommandString())) {
                if (parameter != null && parameter.equalsIgnoreCase(CommandForKey.DOWN_COMMAND_STRING)) {
                    this.press();
                } else if (parameter != null && parameter.equalsIgnoreCase(CommandForKey.UP_COMMAND_STRING)) {
                    this.release();
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }

        public void setObserver(KeyEventListener observer) {
            this.observer = observer;
        }
    }

    public static interface KeyEventListener {
        public void onKeyChange(String var1, boolean var2);
    }
}

