/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.HashMap;

public class CommandGroup
extends CommandBase {
    private ArrayList<ICommandHandler> handlers = new ArrayList();
    private boolean isOverriding = false;
    private boolean shareParametersWithChildren = false;

    protected void setShareParametersWithChildren(boolean share) {
        this.shareParametersWithChildren = share;
    }

    void addCommandHandler(ICommandHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
            handler.setOverriding(this.isOverriding);
        }
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        for (ICommandHandler han : this.handlers) {
            if (!han.execute(verb + " " + parameter, missionInit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void install(MissionInit missionInit) {
        for (ICommandHandler han : this.handlers) {
            han.install(missionInit);
        }
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        for (ICommandHandler han : this.handlers) {
            han.deinstall(missionInit);
        }
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
        for (ICommandHandler han : this.handlers) {
            han.setOverriding(b);
        }
    }

    @Override
    public void setParentBehaviour(MissionBehaviour mb) {
        super.setParentBehaviour(mb);
        for (ICommandHandler han : this.handlers) {
            ((HandlerBase)((Object)han)).setParentBehaviour(mb);
        }
    }

    @Override
    public void appendExtraServerInformation(HashMap<String, String> map) {
        for (ICommandHandler han : this.handlers) {
            if (!(han instanceof HandlerBase)) continue;
            ((HandlerBase)((Object)han)).appendExtraServerInformation(map);
        }
    }

    @Override
    public boolean parseParameters(Object params) {
        boolean ok = super.parseParameters(params);
        if (this.shareParametersWithChildren) {
            for (ICommandHandler han : this.handlers) {
                if (!(han instanceof HandlerBase)) continue;
                ok &= ((HandlerBase)((Object)han)).parseParameters(params);
            }
        }
        return ok;
    }

    public boolean isFixed() {
        return false;
    }
}

