/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldGenerator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.DefaultWorldGenerator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.MapFileHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;

public class DefaultWorldGeneratorImplementation
extends HandlerBase
implements IWorldGenerator {
    DefaultWorldGenerator dwparams;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof DefaultWorldGenerator)) {
            return false;
        }
        this.dwparams = (DefaultWorldGenerator)params;
        return true;
    }

    public static long getWorldSeedFromString(String seedString) {
        long seed = new Random().nextLong();
        if (seedString != null && !seedString.isEmpty()) {
            try {
                long i = Long.parseLong(seedString);
                if (i != 0L) {
                    seed = i;
                }
            }
            catch (NumberFormatException numberformatexception) {
                seed = seedString.hashCode();
            }
        }
        return seed;
    }

    @Override
    public boolean createWorld(MissionInit missionInit) {
        long seed = DefaultWorldGeneratorImplementation.getWorldSeedFromString(this.dwparams.getSeed());
        WorldType.WORLD_TYPES[0].onGUICreateWorldPress();
        WorldSettings worldsettings = new WorldSettings(seed, GameType.SURVIVAL, true, false, WorldType.WORLD_TYPES[0]);
        worldsettings.enableCommands();
        return MapFileHelper.createAndLaunchWorld(worldsettings, this.dwparams.isDestroyAfterUse());
    }

    @Override
    public boolean shouldCreateWorld(MissionInit missionInit, World world) {
        if (this.dwparams != null && this.dwparams.isForceReset()) {
            return true;
        }
        if (Minecraft.getMinecraft().world == null || world == null) {
            return true;
        }
        String genOptions = world.getWorldInfo().getGeneratorOptions();
        return genOptions != null && !genOptions.isEmpty();
    }

    @Override
    public String getErrorDetails() {
        return "";
    }
}

