/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.MissionHandlers.CommandForWheeledRobotNavigationImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForCollectingItemImplementation;
import com.microsoft.Malmo.Schemas.DiscreteMovementCommand;
import com.microsoft.Malmo.Schemas.DiscreteMovementCommands;
import com.microsoft.Malmo.Schemas.MissionInit;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class DiscreteMovementCommandsImplementation
extends CommandBase
implements ICommandHandler {
    public static final String MOVE_ATTEMPTED_KEY = "attemptedToMove";
    private boolean isOverriding;
    DiscreteMovementCommands params;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof DiscreteMovementCommands)) {
            return false;
        }
        this.params = (DiscreteMovementCommands)params;
        this.setUpAllowAndDenyLists(this.params.getModifierList());
        return true;
    }

    private int getDirectionFromYaw(float yaw) {
        int direction = (int)((yaw + 45.0f) / 90.0f);
        return (direction + 4) % 4;
    }

    private DiscreteMovementCommand verbToCommand(String verb) {
        for (DiscreteMovementCommand com : DiscreteMovementCommand.values()) {
            if (!verb.equalsIgnoreCase(com.value())) continue;
            return com;
        }
        return null;
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        boolean handled = false;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player != null) {
            int z = 0;
            int x = 0;
            boolean y = false;
            DiscreteMovementCommand command = this.verbToCommand(verb);
            if (command == null) {
                return false;
            }
            switch (command) {
                case MOVENORTH: 
                case JUMPNORTH: {
                    z = -1;
                    break;
                }
                case MOVESOUTH: 
                case JUMPSOUTH: {
                    z = 1;
                    break;
                }
                case MOVEEAST: 
                case JUMPEAST: {
                    x = 1;
                    break;
                }
                case MOVEWEST: 
                case JUMPWEST: {
                    x = -1;
                    break;
                }
                case MOVE: 
                case JUMPMOVE: 
                case STRAFE: 
                case JUMPSTRAFE: {
                    if (parameter != null && parameter.length() != 0) {
                        float velocity = Float.valueOf(parameter).floatValue();
                        int offset = velocity > 0.0f ? 1 : (velocity < 0.0f ? -1 : 0);
                        int direction = this.getDirectionFromYaw(player.rotationYaw);
                        if (command == DiscreteMovementCommand.STRAFE || command == DiscreteMovementCommand.JUMPSTRAFE) {
                            direction = (direction + 1) % 4;
                        }
                        switch (direction) {
                            case 0: {
                                z = offset;
                                break;
                            }
                            case 1: {
                                x = -offset;
                                break;
                            }
                            case 2: {
                                z = -offset;
                                break;
                            }
                            case 3: {
                                x = offset;
                            }
                        }
                        break;
                    }
                }
                case TURN: {
                    if (parameter == null || parameter.length() == 0) break;
                    float yawDelta = Float.valueOf(parameter).floatValue();
                    int direction = this.getDirectionFromYaw(player.rotationYaw);
                    direction += yawDelta > 0.0f ? 1 : (yawDelta < 0.0f ? -1 : 0);
                    direction = (direction + 4) % 4;
                    player.rotationYaw = direction * 90;
                    player.onUpdate();
                    CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent event = new CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent(true, player.rotationYaw, false, 0.0f);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    handled = true;
                    break;
                }
                case LOOK: {
                    if (parameter == null || parameter.length() == 0) break;
                    float pitchDelta = Float.valueOf(parameter).floatValue();
                    player.rotationPitch = player.rotationPitch + (pitchDelta < 0.0f ? -45.0f : (float)(pitchDelta > 0.0f ? 45 : 0));
                    player.onUpdate();
                    CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent event = new CommandForWheeledRobotNavigationImplementation.ResetPitchAndYawEvent(false, 0.0f, true, player.rotationPitch);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    handled = true;
                    break;
                }
                case ATTACK: {
                    RayTraceResult mop = Minecraft.getMinecraft().objectMouseOver;
                    if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
                        BlockPos hitPos = mop.getBlockPos();
                        EnumFacing face = mop.sideHit;
                        IBlockState iblockstate = player.world.getBlockState(hitPos);
                        Block block = iblockstate.getBlock();
                        if (iblockstate.getMaterial() != Material.AIR) {
                            MalmoMod.network.sendToServer((IMessage)new AttackActionMessage(hitPos, face, mop.hitVec));
                            List items = block.getDrops((IBlockAccess)player.world, hitPos, iblockstate, 0);
                            for (ItemStack item : items) {
                                RewardForCollectingItemImplementation.GainItemEvent event = new RewardForCollectingItemImplementation.GainItemEvent(item);
                                MinecraftForge.EVENT_BUS.post((Event)event);
                            }
                        }
                    }
                    handled = true;
                    break;
                }
                case USE: 
                case JUMPUSE: {
                    ItemStack itemStack;
                    Block b;
                    RayTraceResult mop = this.getObjectMouseOver(command);
                    if (mop.typeOfHit == RayTraceResult.Type.BLOCK && player.inventory.getCurrentItem() != null && (b = Block.getBlockFromItem((Item)(itemStack = player.inventory.getCurrentItem()).getItem())) != null) {
                        EntityPlayerSP exceptedEntity;
                        BlockPos pos = mop.getBlockPos().add(mop.sideHit.getDirectionVec());
                        AxisAlignedBB axisalignedbb = b.getDefaultState().getCollisionBoundingBox((IBlockAccess)player.world, pos);
                        EntityPlayerSP entityPlayerSP = exceptedEntity = command == DiscreteMovementCommand.USE ? null : player;
                        if (axisalignedbb == null || player.world.checkNoEntityCollision(axisalignedbb.offset(pos), (Entity)exceptedEntity)) {
                            boolean standOnBlockPlaced = command == DiscreteMovementCommand.JUMPUSE && mop.getBlockPos().equals((Object)new BlockPos(player.posX, player.posY - 1.0, player.posZ));
                            MalmoMod.network.sendToServer((IMessage)new UseActionMessage(mop.getBlockPos(), itemStack, mop.sideHit, standOnBlockPlaced, mop.hitVec));
                        }
                    }
                    handled = true;
                    break;
                }
            }
            if (command == DiscreteMovementCommand.JUMP || command == DiscreteMovementCommand.JUMPNORTH || command == DiscreteMovementCommand.JUMPEAST || command == DiscreteMovementCommand.JUMPSOUTH || command == DiscreteMovementCommand.JUMPWEST || command == DiscreteMovementCommand.JUMPMOVE || command == DiscreteMovementCommand.JUMPUSE || command == DiscreteMovementCommand.JUMPSTRAFE) {
                y = true;
            }
            if (!(!this.params.isAutoJump() || y || z == 0 && x == 0 || player.world.getCollisionBoxes((Entity)player, player.getEntityBoundingBox().offset((double)x, 0.0, (double)z)).isEmpty())) {
                y = true;
            }
            if (z != 0 || x != 0 || y) {
                double oldX = player.posX;
                double oldZ = player.posZ;
                player.move(MoverType.SELF, (double)x, (double)y, (double)z);
                player.onUpdate();
                if (this.params.isAutoFall()) {
                    for (int bailCountdown = 256; !player.onGround && !player.capabilities.isFlying && bailCountdown > 0; --bailCountdown) {
                        player.move(MoverType.SELF, 0.0, Math.floor(player.posY - 1.0E-7) - player.posY, 0.0);
                        player.onUpdate();
                    }
                }
                double newX = player.posX;
                double newZ = player.posZ;
                double offsetX = newX - Math.floor(newX);
                double offsetZ = newZ - Math.floor(newZ);
                if (Math.abs(offsetX - 0.5) + Math.abs(offsetZ - 0.5) > 0.01) {
                    DiscretePartialMoveEvent event = new DiscretePartialMoveEvent(player.posX, player.posY, player.posZ);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    player.move(MoverType.SELF, oldX - newX, 0.0, oldZ - newZ);
                    player.onUpdate();
                }
                player.lastTickPosX = player.posX;
                player.lastTickPosY = player.posY;
                player.lastTickPosZ = player.posZ;
                try {
                    MalmoMod.getPropertiesForCurrentThread().put(MOVE_ATTEMPTED_KEY, true);
                }
                catch (Exception e) {
                    System.out.println("Failed to access properties for the client thread after discrete movement - reward may be incorrect.");
                }
                handled = true;
            }
        }
        return handled;
    }

    private RayTraceResult getObjectMouseOver(DiscreteMovementCommand command) {
        RayTraceResult mop = null;
        if (command.equals((Object)DiscreteMovementCommand.USE)) {
            mop = Minecraft.getMinecraft().objectMouseOver;
        } else if (command.equals((Object)DiscreteMovementCommand.JUMPUSE)) {
            long partialTicks = 0L;
            EntityPlayerSP viewer = Minecraft.getMinecraft().player;
            double blockReach = Minecraft.getMinecraft().playerController.getBlockReachDistance();
            Vec3d eyePos = viewer.getPositionEyes((float)partialTicks);
            Vec3d lookVec = viewer.getLook((float)partialTicks);
            boolean yOffset = true;
            Vec3d searchVec = eyePos.addVector(lookVec.xCoord * blockReach, (double)yOffset + lookVec.yCoord * blockReach, lookVec.zCoord * blockReach);
            mop = Minecraft.getMinecraft().world.rayTraceBlocks(eyePos, searchVec, false, false, false);
        }
        return mop;
    }

    @Override
    public void install(MissionInit missionInit) {
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class AttackActionMessageHandler
    implements IMessageHandler<AttackActionMessage, IMessage> {
        public IMessage onMessage(final AttackActionMessage message, final MessageContext ctx) {
            WorldServer mainThread = null;
            if (ctx.side == Side.CLIENT) {
                return null;
            }
            mainThread = (WorldServer)ctx.getServerHandler().playerEntity.world;
            mainThread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().playerEntity;
                    IBlockState iblockstate = player.world.getBlockState(message.pos);
                    Block block = iblockstate.getBlock();
                    if (iblockstate.getMaterial() != Material.AIR) {
                        PlayerInteractEvent.LeftClickBlock event = new PlayerInteractEvent.LeftClickBlock((EntityPlayer)player, message.pos, message.face, message.hitVec);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.isCanceled()) {
                            boolean dropBlock = false;
                            List items = block.getDrops((IBlockAccess)player.world, message.pos, iblockstate, 0);
                            player.world.destroyBlock(message.pos, dropBlock);
                            for (ItemStack item : items) {
                                if (player.inventory.addItemStackToInventory(item)) continue;
                                Block.spawnAsEntity((World)player.world, (BlockPos)message.pos, (ItemStack)item);
                            }
                            BlockEvent.BreakEvent breakevent = new BlockEvent.BreakEvent(player.world, message.pos, iblockstate, (EntityPlayer)player);
                            MinecraftForge.EVENT_BUS.post((Event)breakevent);
                        }
                    }
                }
            });
            return null;
        }
    }

    public static class AttackActionMessage
    implements IMessage {
        public BlockPos pos;
        public EnumFacing face;
        public Vec3d hitVec;

        public AttackActionMessage() {
        }

        public AttackActionMessage(BlockPos hitPos, EnumFacing face, Vec3d hitVec) {
            this.pos = hitPos;
            this.face = face;
            this.hitVec = hitVec;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.face = EnumFacing.values()[buf.readInt()];
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.getX());
            buf.writeInt(this.pos.getY());
            buf.writeInt(this.pos.getZ());
            buf.writeInt(this.face.ordinal());
            buf.writeDouble(this.hitVec.xCoord);
            buf.writeDouble(this.hitVec.yCoord);
            buf.writeDouble(this.hitVec.zCoord);
        }
    }

    public static class UseActionMessageHandler
    implements IMessageHandler<UseActionMessage, IMessage> {
        public IMessage onMessage(final UseActionMessage message, final MessageContext ctx) {
            WorldServer mainThread = null;
            if (ctx.side == Side.CLIENT) {
                return null;
            }
            mainThread = (WorldServer)ctx.getServerHandler().playerEntity.world;
            mainThread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().playerEntity;
                    PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock((EntityPlayer)player, EnumHand.MAIN_HAND, message.pos, message.face, message.hitVec);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled()) {
                        IBlockState blockType;
                        BlockPos pos = message.pos.add(message.face.getDirectionVec());
                        Block b = Block.getBlockFromItem((Item)message.itemStack.getItem());
                        if (b != null && player.world.setBlockState(pos, blockType = b.getStateFromMeta(message.itemStack.getMetadata()))) {
                            BlockSnapshot snapshot = new BlockSnapshot(player.world, pos, blockType);
                            BlockEvent.PlaceEvent placeevent = new BlockEvent.PlaceEvent(snapshot, player.world.getBlockState(message.pos), (EntityPlayer)player);
                            MinecraftForge.EVENT_BUS.post((Event)placeevent);
                            if (!player.isCreative()) {
                                if (player.inventory.getCurrentItem().getCount() > 1) {
                                    player.inventory.getCurrentItem().setCount(player.inventory.getCurrentItem().getCount() - 1);
                                } else {
                                    ((ItemStack)player.inventory.mainInventory.get(player.inventory.currentItem)).setCount(0);
                                }
                            }
                            if (message.standOnPlacedBlock) {
                                player.setPosition((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
                            }
                        }
                    }
                }
            });
            return null;
        }
    }

    public static class UseActionMessage
    implements IMessage {
        public BlockPos pos;
        public ItemStack itemStack;
        public EnumFacing face;
        public boolean standOnPlacedBlock;
        public Vec3d hitVec;

        public UseActionMessage() {
        }

        public UseActionMessage(BlockPos pos, ItemStack itemStack, EnumFacing face, boolean standOnPlacedBlock, Vec3d hitVec) {
            this.pos = pos;
            this.itemStack = itemStack;
            this.face = face;
            this.standOnPlacedBlock = standOnPlacedBlock;
            this.hitVec = hitVec;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.face = EnumFacing.values()[buf.readInt()];
            this.standOnPlacedBlock = buf.readBoolean();
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.getX());
            buf.writeInt(this.pos.getY());
            buf.writeInt(this.pos.getZ());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
            buf.writeInt(this.face.ordinal());
            buf.writeBoolean(this.standOnPlacedBlock);
            buf.writeDouble(this.hitVec.xCoord);
            buf.writeDouble(this.hitVec.yCoord);
            buf.writeDouble(this.hitVec.zCoord);
        }
    }

    public static class DiscretePartialMoveEvent
    extends Event {
        public final double x;
        public final double y;
        public final double z;

        public DiscretePartialMoveEvent(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

