/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.PlaceCommands;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EquipCommandsImplementation
extends CommandBase {
    private boolean isOverriding;

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (!verb.equalsIgnoreCase("equip")) {
            return false;
        }
        Item item = Item.getByNameOrId((String)parameter);
        if (item != null && item.getRegistryName() != null && !parameter.equalsIgnoreCase("none")) {
            MalmoMod.network.sendToServer((IMessage)new EquipMessage(parameter));
        }
        return true;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof PlaceCommands)) {
            return false;
        }
        PlaceCommands pParams = (PlaceCommands)params;
        this.setUpAllowAndDenyLists(pParams.getModifierList());
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
    }

    @Override
    public void deinstall(MissionInit missionInit) {
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class EquipMessageHandler
    implements IMessageHandler<EquipMessage, IMessage> {
        public IMessage onMessage(EquipMessage message, MessageContext ctx) {
            System.out.println("Equip message recieved");
            EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            if (player == null) {
                return null;
            }
            Item item = Item.getByNameOrId((String)message.parameters);
            if (item == null || item.getRegistryName() == null) {
                return null;
            }
            InventoryPlayer inv = player.inventory;
            boolean itemInInventory = false;
            ItemStack stackInInventory = null;
            int stackIndex = -1;
            for (int i = 0; !itemInInventory && i < inv.getSizeInventory(); ++i) {
                Item stack = inv.getStackInSlot(i).getItem();
                if (stack.getRegistryName() == null || !stack.getRegistryName().equals((Object)item.getRegistryName())) continue;
                stackInInventory = inv.getStackInSlot(i).copy();
                stackIndex = i;
                itemInInventory = true;
            }
            if (!itemInInventory) {
                return null;
            }
            int hotbarIdx = player.inventory.currentItem;
            System.out.println("got harbar " + hotbarIdx);
            System.out.println("got slot " + stackIndex);
            ItemStack prevEquip = inv.getStackInSlot(hotbarIdx).copy();
            inv.setInventorySlotContents(hotbarIdx, stackInInventory);
            inv.setInventorySlotContents(stackIndex, prevEquip);
            return null;
        }
    }

    public static class EquipMessage
    implements IMessage {
        String parameters;

        public EquipMessage() {
        }

        public EquipMessage(String parameters) {
            this.parameters = parameters;
        }

        public void fromBytes(ByteBuf buf) {
            this.parameters = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.parameters);
        }
    }
}

