/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldGenerator;
import com.microsoft.Malmo.MissionHandlers.DefaultWorldGeneratorImplementation;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.FlatWorldGenerator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.MapFileHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;

public class FlatWorldGeneratorImplementation
extends HandlerBase
implements IWorldGenerator {
    FlatWorldGenerator fwparams;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof FlatWorldGenerator)) {
            return false;
        }
        this.fwparams = (FlatWorldGenerator)params;
        return true;
    }

    @Override
    public boolean createWorld(MissionInit missionInit) {
        long seed = DefaultWorldGeneratorImplementation.getWorldSeedFromString(this.fwparams.getSeed());
        WorldSettings worldsettings = new WorldSettings(seed, GameType.SURVIVAL, false, false, WorldType.FLAT);
        worldsettings.setGeneratorOptions(this.fwparams.getGeneratorString());
        worldsettings.enableCommands();
        return MapFileHelper.createAndLaunchWorld(worldsettings, this.fwparams.isDestroyAfterUse());
    }

    @Override
    public boolean shouldCreateWorld(MissionInit missionInit, World world) {
        if (this.fwparams != null && this.fwparams.isForceReset()) {
            return true;
        }
        if (Minecraft.getMinecraft().world == null || world == null) {
            return true;
        }
        WorldInfo worldInfo = world.getWorldInfo();
        if (worldInfo == null) {
            return true;
        }
        String genOptions = worldInfo.getGeneratorOptions();
        if (genOptions == null) {
            return true;
        }
        return !genOptions.equals(this.fwparams.getGeneratorString());
    }

    @Override
    public String getErrorDetails() {
        return "";
    }
}

