/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlers.CommandForKey;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.Schemas.HumanLevelCommand;
import com.microsoft.Malmo.Schemas.HumanLevelCommands;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Utils.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HumanLevelCommandsImplementation
extends CommandGroup {
    float targetYawDelta = 0.0f;
    float targetPitchDelta = 0.0f;
    float targetYawDeltaDelta = 0.0f;
    float targetPitchDeltaDelta = 0.0f;
    TimeHelper.TickRateMonitor clientTickMonitor = new TimeHelper.TickRateMonitor();
    TimeHelper.TickRateMonitor renderTickMonitor = new TimeHelper.TickRateMonitor();

    public HumanLevelCommandsImplementation() {
        this.setShareParametersWithChildren(true);
        List<CommandForKey> keys = HumanLevelCommandsImplementation.getKeyOverrides();
        for (CommandForKey k : keys) {
            this.addCommandHandler(k);
        }
    }

    public static List<CommandForKey> getKeyOverrides() {
        ArrayList<CommandForKey> keys = new ArrayList<CommandForKey>();
        keys.add(new CommandForKey("key.forward"));
        keys.add(new CommandForKey("key.left"));
        keys.add(new CommandForKey("key.back"));
        keys.add(new CommandForKey("key.right"));
        keys.add(new CommandForKey("key.jump"));
        keys.add(new CommandForKey("key.sneak"));
        keys.add(new CommandForKey("key.sprint"));
        keys.add(new CommandForKey("key.inventory"));
        keys.add(new CommandForKey("key.swapHands"));
        keys.add(new CommandForKey("key.drop"));
        keys.add(new CommandForKey("key.use"));
        keys.add(new CommandForKey("key.attack"));
        keys.add(new CommandForKey("key.pickItem"));
        for (int i = 1; i <= 9; ++i) {
            keys.add(new CommandForKey("key.hotbar." + i));
        }
        return keys;
    }

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof HumanLevelCommands)) {
            return false;
        }
        HumanLevelCommands cmparams = (HumanLevelCommands)params;
        this.setUpAllowAndDenyLists(cmparams.getModifierList());
        return true;
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb.equalsIgnoreCase(HumanLevelCommand.MOVE_MOUSE.value()) && parameter != null && parameter.length() != 0) {
            Integer z;
            Integer y;
            Integer x;
            String[] params = parameter.split(" ");
            if (params.length != 2 && params.length != 3) {
                System.out.println("Malformed parameter string (" + parameter + ") - expected <x> <y>, or <x> <y> <z>");
                return false;
            }
            try {
                x = Integer.valueOf(params[0]);
                y = Integer.valueOf(params[1]);
                z = params.length == 3 ? Integer.valueOf(params[2]) : 0;
            }
            catch (NumberFormatException e) {
                System.out.println("Malformed parameter string (" + parameter + ") - " + e.getMessage());
                return false;
            }
            if (x == null || y == null) {
                System.out.println("Malformed parameter string (" + parameter + ")");
                return false;
            }
            if (x != 0 || y != 0) {
                Minecraft mc = Minecraft.getMinecraft();
                float f = mc.gameSettings.mouseSensitivity * 0.6f + 0.2f;
                float f1 = f * f * f * 8.0f;
                float f2 = (float)x.intValue() * f1;
                float f3 = (float)y.intValue() * f1;
                if (mc.gameSettings.invertMouse) {
                    f3 = -f3;
                }
                if (this.isOverriding()) {
                    mc.player.turn(this.targetYawDelta, this.targetPitchDelta);
                }
                int renderTicksPerClientTick = this.clientTickMonitor.getEventsPerSecond() >= 1.0f ? (int)Math.ceil(this.renderTickMonitor.getEventsPerSecond() / this.clientTickMonitor.getEventsPerSecond()) : 0;
                renderTicksPerClientTick = Math.max(1, renderTicksPerClientTick);
                this.targetYawDelta = f2;
                this.targetPitchDelta = f3;
                this.targetYawDeltaDelta = f2 / (float)renderTicksPerClientTick;
                this.targetPitchDeltaDelta = f3 / (float)renderTicksPerClientTick;
            }
            if (z != 0 && !Minecraft.getMinecraft().player.isSpectator() && this.isOverriding()) {
                Minecraft.getMinecraft().player.inventory.changeCurrentItem(z.intValue());
            }
            return true;
        }
        return super.onExecute(verb, parameter, missionInit);
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
        super.install(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        super.deinstall(missionInit);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (this.isCommandAllowed(HumanLevelCommand.MOVE_MOUSE.value()) && ev.phase == TickEvent.Phase.START) {
            this.clientTickMonitor.beat();
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent ev) {
        if (this.isCommandAllowed(HumanLevelCommand.MOVE_MOUSE.value()) && ev.phase == TickEvent.Phase.START && this.isOverriding()) {
            EntityPlayerSP player;
            this.renderTickMonitor.beat();
            if (this.isOverriding() && (player = Minecraft.getMinecraft().player) != null && (this.targetPitchDelta != 0.0f || this.targetYawDelta != 0.0f)) {
                player.turn(this.targetYawDeltaDelta, this.targetPitchDeltaDelta);
                this.targetYawDelta -= this.targetYawDeltaDelta;
                this.targetPitchDelta -= this.targetPitchDeltaDelta;
                if ((double)(this.targetYawDelta / this.targetYawDeltaDelta) < 1.0) {
                    this.targetYawDeltaDelta = this.targetYawDelta;
                }
                if ((double)(this.targetPitchDelta / this.targetPitchDeltaDelta) < 1.0) {
                    this.targetPitchDeltaDelta = this.targetPitchDelta;
                }
            }
        }
    }
}

