/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandForHotBarKeysImplementation;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.ObservationFromFullInventoryImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForCollectingItemImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardForDiscardingItemImplementation;
import com.microsoft.Malmo.Schemas.InventoryCommand;
import com.microsoft.Malmo.Schemas.InventoryCommands;
import com.microsoft.Malmo.Schemas.MissionInit;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class InventoryCommandsImplementation
extends CommandGroup {
    InventoryCommandsImplementation() {
        this.setShareParametersWithChildren(true);
        this.addCommandHandler(new CommandForHotBarKeysImplementation());
    }

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof InventoryCommands)) {
            return false;
        }
        InventoryCommands iparams = (InventoryCommands)params;
        this.setUpAllowAndDenyLists(iparams.getModifierList());
        return true;
    }

    static ItemStack[] combineSlots(EntityPlayerMP player, String invDst, int dst, String invAdd, int add, BlockPos containerPos) {
        InventoryPlayer addInv;
        InventoryPlayer dstInv;
        IInventory container = null;
        String containerName = "";
        if (containerPos != null) {
            TileEntity te = player.world.getTileEntity(containerPos);
            if (te != null && te instanceof TileEntityLockableLoot) {
                containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)te);
                container = (IInventory)te;
            } else if (te != null && te instanceof TileEntityEnderChest) {
                containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)player.getInventoryEnderChest());
                container = player.getInventoryEnderChest();
            }
        }
        Object object = invDst.equals("inventory") ? player.inventory : (dstInv = invDst.equals(containerName) ? container : null);
        Object object2 = invAdd.equals("inventory") ? player.inventory : (addInv = invAdd.equals(containerName) ? container : null);
        if (dstInv == null || addInv == null) {
            return null;
        }
        ItemStack dstStack = dstInv.getStackInSlot(dst);
        ItemStack addStack = addInv.getStackInSlot(add);
        if (addStack == null) {
            return null;
        }
        ItemStack[] returnStacks = null;
        if (dstStack == null) {
            if (dstInv != addInv) {
                ItemStack stackBeingGained;
                returnStacks = new ItemStack[2];
                ItemStack stackBeingLost = addInv == player.inventory ? addStack : null;
                Object object3 = stackBeingGained = dstInv == player.inventory ? addStack : null;
                if (stackBeingGained != null) {
                    returnStacks[0] = stackBeingGained.copy();
                }
                if (stackBeingLost != null) {
                    returnStacks[1] = stackBeingLost.copy();
                }
            }
            dstInv.setInventorySlotContents(dst, addStack);
            addInv.setInventorySlotContents(add, null);
            return returnStacks;
        }
        boolean itemsMatch = dstStack.getItem() == addStack.getItem();
        boolean dstCanStack = dstStack.isStackable() && dstStack.getCount() < dstStack.getMaxStackSize() && dstStack.getCount() < dstInv.getInventoryStackLimit();
        boolean subTypesMatch = !dstStack.getHasSubtypes() || dstStack.getMetadata() == addStack.getMetadata();
        boolean tagsMatch = ItemStack.areItemStackTagsEqual((ItemStack)dstStack, (ItemStack)addStack);
        if (itemsMatch && dstCanStack && subTypesMatch && tagsMatch) {
            int limit = Math.min(dstStack.getMaxStackSize(), dstInv.getInventoryStackLimit());
            int room = limit - dstStack.getCount();
            ItemStack itemsTransferred = dstStack.copy();
            if (addStack.getCount() > room) {
                addStack.shrink(room);
                dstStack.grow(room);
                itemsTransferred.setCount(room);
            } else {
                dstStack.grow(addStack.getCount());
                itemsTransferred.setCount(addStack.getCount());
                addInv.removeStackFromSlot(add);
            }
            if (dstInv != addInv) {
                returnStacks = new ItemStack[2];
                if (dstInv == player.inventory) {
                    returnStacks[0] = itemsTransferred;
                } else {
                    returnStacks[1] = itemsTransferred;
                }
            }
        }
        return returnStacks;
    }

    static ItemStack[] swapSlots(EntityPlayerMP player, String lhsInv, int lhs, String rhsInv, int rhs, BlockPos containerPos) {
        InventoryPlayer rhsInventory;
        InventoryPlayer lhsInventory;
        IInventory container = null;
        String containerName = "";
        if (containerPos != null) {
            TileEntity te = player.world.getTileEntity(containerPos);
            if (te != null && te instanceof TileEntityLockableLoot) {
                containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)te);
                container = (IInventory)te;
            } else if (te != null && te instanceof TileEntityEnderChest) {
                containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)player.getInventoryEnderChest());
                container = player.getInventoryEnderChest();
            }
        }
        Object object = lhsInv.equals("inventory") ? player.inventory : (lhsInventory = lhsInv.equals(containerName) ? container : null);
        Object object2 = rhsInv.equals("inventory") ? player.inventory : (rhsInventory = rhsInv.equals(containerName) ? container : null);
        if (lhsInventory == null || rhsInventory == null) {
            return null;
        }
        if (rhs < 0 || lhs < 0) {
            return null;
        }
        if (lhs >= lhsInventory.getSizeInventory() || rhs >= rhsInventory.getSizeInventory()) {
            return null;
        }
        ItemStack srcStack = lhsInventory.getStackInSlot(lhs);
        ItemStack dstStack = rhsInventory.getStackInSlot(rhs);
        lhsInventory.setInventorySlotContents(lhs, dstStack);
        rhsInventory.setInventorySlotContents(rhs, srcStack);
        if (lhsInventory != rhsInventory) {
            ItemStack stackBeingGained;
            ItemStack[] returnStacks = new ItemStack[2];
            ItemStack stackBeingLost = lhsInventory == player.inventory ? srcStack : dstStack;
            ItemStack itemStack = stackBeingGained = lhsInventory == player.inventory ? dstStack : srcStack;
            if (stackBeingGained != null) {
                returnStacks[0] = stackBeingGained.copy();
            }
            if (stackBeingLost != null) {
                returnStacks[1] = stackBeingLost.copy();
            }
            return returnStacks;
        }
        return null;
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb.equalsIgnoreCase(InventoryCommand.SWAP_INVENTORY_ITEMS.value())) {
            if (parameter != null && parameter.length() != 0) {
                ArrayList<Object> params = new ArrayList<Object>();
                if (this.getParameters(parameter, params)) {
                    MalmoMod.network.sendToServer((IMessage)new InventoryMessage(params, false));
                    return true;
                }
                return false;
            }
        } else if (verb.equalsIgnoreCase(InventoryCommand.COMBINE_INVENTORY_ITEMS.value())) {
            if (parameter != null && parameter.length() != 0) {
                ArrayList<Object> params = new ArrayList<Object>();
                if (this.getParameters(parameter, params)) {
                    MalmoMod.network.sendToServer((IMessage)new InventoryMessage(params, true));
                    return true;
                }
                return false;
            }
        } else if (verb.equalsIgnoreCase(InventoryCommand.DISCARD_CURRENT_ITEM.value())) {
            Minecraft.getMinecraft().player.dropItem(false);
            return true;
        }
        return super.onExecute(verb, parameter, missionInit);
    }

    private boolean getParameters(String parameter, List<Object> parsedParams) {
        Integer rhsIndex;
        Integer lhsIndex;
        String rhsStrIndex;
        String rhsName;
        String lhsStrIndex;
        String lhsName;
        String[] params = parameter.split(" ");
        if (params.length != 2) {
            System.out.println("Malformed parameter string (" + parameter + ") - expected <x> <y>");
            return false;
        }
        String[] lhsParams = params[0].split(":");
        String[] rhsParams = params[1].split(":");
        boolean checkContainers = false;
        if (lhsParams.length == 2) {
            lhsName = lhsParams[0];
            lhsStrIndex = lhsParams[1];
            checkContainers = true;
        } else if (lhsParams.length == 1) {
            lhsName = "inventory";
            lhsStrIndex = lhsParams[0];
        } else {
            System.out.println("Malformed parameter string (" + params[0] + ")");
            return false;
        }
        if (rhsParams.length == 2) {
            rhsName = rhsParams[0];
            rhsStrIndex = rhsParams[1];
            checkContainers = true;
        } else if (rhsParams.length == 1) {
            rhsName = "inventory";
            rhsStrIndex = rhsParams[0];
        } else {
            System.out.println("Malformed parameter string (" + params[1] + ")");
            return false;
        }
        try {
            lhsIndex = Integer.valueOf(lhsStrIndex);
            rhsIndex = Integer.valueOf(rhsStrIndex);
        }
        catch (NumberFormatException e) {
            System.out.println("Malformed parameter string (" + parameter + ") - " + e.getMessage());
            return false;
        }
        if (lhsIndex == null || rhsIndex == null) {
            System.out.println("Malformed parameter string (" + parameter + ")");
            return false;
        }
        BlockPos containerPos = null;
        if (checkContainers) {
            boolean containerMatches;
            String containerName = "";
            RayTraceResult rtr = Minecraft.getMinecraft().objectMouseOver;
            if (rtr != null && rtr.typeOfHit == RayTraceResult.Type.BLOCK) {
                containerPos = rtr.getBlockPos();
                TileEntity te = Minecraft.getMinecraft().world.getTileEntity(containerPos);
                if (te instanceof TileEntityLockableLoot) {
                    containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)te);
                } else if (te instanceof TileEntityEnderChest) {
                    containerName = ObservationFromFullInventoryImplementation.getInventoryName((IInventory)Minecraft.getMinecraft().player.getInventoryEnderChest());
                }
            }
            boolean bl = containerMatches = !(!lhsName.equals("inventory") && !lhsName.equals(containerName) || !rhsName.equals("inventory") && !rhsName.equals(containerName));
            if (!containerMatches) {
                System.out.println("Missing container requested in parameter string (" + parameter + ")");
                return false;
            }
        }
        parsedParams.add(lhsName);
        parsedParams.add(lhsIndex);
        parsedParams.add(rhsName);
        parsedParams.add(rhsIndex);
        if (containerPos != null) {
            parsedParams.add(containerPos);
        }
        return true;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    public static class InventoryChangeMessageHandler
    implements IMessageHandler<InventoryChangeMessage, IMessage> {
        public IMessage onMessage(InventoryChangeMessage message, MessageContext ctx) {
            Event event;
            if (message.itemsGained != null) {
                event = new RewardForCollectingItemImplementation.GainItemEvent(message.itemsGained);
                MinecraftForge.EVENT_BUS.post(event);
            }
            if (message.itemsLost != null) {
                event = new RewardForDiscardingItemImplementation.LoseItemEvent(message.itemsLost);
                MinecraftForge.EVENT_BUS.post(event);
            }
            return null;
        }
    }

    public static class InventoryMessageHandler
    implements IMessageHandler<InventoryMessage, IMessage> {
        public InventoryChangeMessage onMessage(final InventoryMessage message, MessageContext ctx) {
            final EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().playerEntity.world;
            mainThread.addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    ItemStack[] changes = null;
                    changes = message.combine ? InventoryCommandsImplementation.combineSlots(player, message.invA, message.slotA, message.invB, message.slotB, message.containerPos) : InventoryCommandsImplementation.swapSlots(player, message.invA, message.slotA, message.invB, message.slotB, message.containerPos);
                    if (changes != null) {
                        MalmoMod.network.sendTo((IMessage)new InventoryChangeMessage(changes[0], changes[1]), player);
                    }
                }
            });
            return null;
        }
    }

    public static class InventoryMessage
    implements IMessage {
        String invA;
        String invB;
        int slotA;
        int slotB;
        boolean combine;
        BlockPos containerPos;

        public InventoryMessage() {
        }

        public InventoryMessage(List<Object> params, boolean combine) {
            this.invA = (String)params.get(0);
            this.slotA = (Integer)params.get(1);
            this.invB = (String)params.get(2);
            this.slotB = (Integer)params.get(3);
            if (params.size() == 5) {
                this.containerPos = (BlockPos)params.get(4);
            }
            this.combine = combine;
        }

        public void fromBytes(ByteBuf buf) {
            this.invA = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.slotA = buf.readInt();
            this.invB = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.slotB = buf.readInt();
            this.combine = buf.readBoolean();
            if (buf.readBoolean()) {
                this.containerPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            }
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.invA);
            buf.writeInt(this.slotA);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.invB);
            buf.writeInt(this.slotB);
            buf.writeBoolean(this.combine);
            buf.writeBoolean(this.containerPos != null);
            if (this.containerPos != null) {
                buf.writeInt(this.containerPos.getX());
                buf.writeInt(this.containerPos.getY());
                buf.writeInt(this.containerPos.getZ());
            }
        }
    }

    public static class InventoryChangeMessage
    implements IMessage {
        public ItemStack itemsGained = null;
        public ItemStack itemsLost = null;

        public InventoryChangeMessage() {
        }

        public InventoryChangeMessage(ItemStack itemsGained, ItemStack itemsLost) {
            this.itemsGained = itemsGained;
            this.itemsLost = itemsLost;
        }

        public void fromBytes(ByteBuf buf) {
            boolean lostItems;
            boolean gainedItems = buf.readBoolean();
            if (gainedItems) {
                this.itemsGained = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            if (lostItems = buf.readBoolean()) {
                this.itemsLost = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.itemsGained != null);
            if (this.itemsGained != null) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemsGained);
            }
            buf.writeBoolean(this.itemsLost != null);
            if (this.itemsLost != null) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemsLost);
            }
        }
    }
}

