/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.AgentQuitFromReachingPosition;
import com.microsoft.Malmo.Schemas.AgentSection;
import com.microsoft.Malmo.Schemas.BlockOrItemSpec;
import com.microsoft.Malmo.Schemas.BlockType;
import com.microsoft.Malmo.Schemas.Colour;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.MazeBlock;
import com.microsoft.Malmo.Schemas.MazeDecorator;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromSubgoalPositionList;
import com.microsoft.Malmo.Schemas.PointWithToleranceAndDescription;
import com.microsoft.Malmo.Schemas.PosAndDirection;
import com.microsoft.Malmo.Schemas.Variation;
import com.microsoft.Malmo.Utils.BlockDrawingHelper;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MazeDecoratorImplementation
extends HandlerBase
implements IWorldDecorator {
    private MazeDecorator mazeParams = null;
    private Random pathrand;
    private Random blockrand;
    private BlockDrawingHelper.XMLBlockState startBlock;
    private BlockDrawingHelper.XMLBlockState endBlock;
    private BlockDrawingHelper.XMLBlockState floorBlock;
    private BlockDrawingHelper.XMLBlockState pathBlock;
    private BlockDrawingHelper.XMLBlockState optimalPathBlock;
    private BlockDrawingHelper.XMLBlockState subgoalPathBlock;
    private BlockDrawingHelper.XMLBlockState gapBlock;
    private BlockDrawingHelper.XMLBlockState waypointBlock;
    private ItemStack waypointItem;
    private int startHeight;
    private int endHeight;
    private int pathHeight;
    private int optimalPathHeight;
    private int subgoalHeight;
    private int gapHeight;
    private PosAndDirection startPosition = null;
    private AgentQuitFromReachingPosition quitter = null;
    private ObservationFromSubgoalPositionList navigator = null;
    int width;
    int length;
    int gaps;
    int maxPathLength;
    int xOrg;
    int yOrg;
    int zOrg;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof MazeDecorator)) {
            return false;
        }
        this.mazeParams = (MazeDecorator)params;
        return true;
    }

    private void initRNGs() {
        long seed = 0L;
        seed = this.mazeParams.getSeed() == null || this.mazeParams.getSeed().equals("random") ? System.currentTimeMillis() : Long.parseLong(this.mazeParams.getSeed());
        this.pathrand = new Random(seed);
        this.blockrand = new Random(seed);
        if (this.mazeParams.getMaterialSeed() != null) {
            long bseed = 0L;
            bseed = this.mazeParams.getMaterialSeed().equals("random") ? System.currentTimeMillis() : Long.parseLong(this.mazeParams.getMaterialSeed());
            this.blockrand = new Random(bseed);
        }
    }

    private void initBlocksAndHeights() {
        this.startBlock = this.getBlock(this.mazeParams.getStartBlock(), this.blockrand);
        this.endBlock = this.getBlock(this.mazeParams.getEndBlock(), this.blockrand);
        this.floorBlock = this.getBlock(this.mazeParams.getFloorBlock(), this.blockrand);
        this.pathBlock = this.getBlock(this.mazeParams.getPathBlock(), this.blockrand);
        this.optimalPathBlock = this.mazeParams.getOptimalPathBlock() != null ? this.getBlock(this.mazeParams.getOptimalPathBlock(), this.blockrand) : this.pathBlock;
        this.subgoalPathBlock = this.mazeParams.getSubgoalBlock() != null ? this.getBlock(this.mazeParams.getSubgoalBlock(), this.blockrand) : this.optimalPathBlock;
        this.gapBlock = this.getBlock(this.mazeParams.getGapBlock(), this.blockrand);
        if (this.mazeParams.getWaypoints() != null) {
            if (this.mazeParams.getWaypoints().getWaypointBlock() != null) {
                this.waypointBlock = this.getBlock(this.mazeParams.getWaypoints().getWaypointBlock(), this.blockrand);
            } else {
                BlockOrItemSpec bis = this.mazeParams.getWaypoints().getWaypointItem();
                DrawItem di = new DrawItem();
                di.setType(bis.getType().get(this.blockrand.nextInt(bis.getType().size())));
                if (bis.getColour() != null && !bis.getColour().isEmpty()) {
                    di.setColour(bis.getColour().get(this.blockrand.nextInt(bis.getColour().size())));
                }
                if (bis.getVariant() != null && !bis.getVariant().isEmpty()) {
                    di.setVariant(bis.getVariant().get(this.blockrand.nextInt(bis.getVariant().size())));
                }
                this.waypointItem = MinecraftTypeHelper.getItemStackFromDrawItem(di);
            }
        }
        this.startHeight = this.getHeight(this.mazeParams.getStartBlock(), this.pathrand);
        this.endHeight = this.getHeight(this.mazeParams.getEndBlock(), this.pathrand);
        this.pathHeight = this.getHeight(this.mazeParams.getPathBlock(), this.pathrand);
        this.optimalPathHeight = this.mazeParams.getOptimalPathBlock() != null ? this.getHeight(this.mazeParams.getOptimalPathBlock(), this.pathrand) : this.pathHeight;
        this.subgoalHeight = this.mazeParams.getSubgoalBlock() != null ? this.getHeight(this.mazeParams.getSubgoalBlock(), this.pathrand) : this.optimalPathHeight;
        this.gapHeight = this.getHeight(this.mazeParams.getGapBlock(), this.pathrand);
    }

    private void initDimensions() {
        this.width = this.mazeParams.getSizeAndPosition().getWidth();
        this.length = this.mazeParams.getSizeAndPosition().getLength();
        int totalCells = this.width * this.length;
        float gapProbability = this.mazeParams.getGapProbability().getValue().floatValue();
        float variance = this.mazeParams.getGapProbability().getVariance().floatValue();
        gapProbability = (gapProbability = (float)((double)gapProbability + ((double)this.pathrand.nextFloat() - 0.5) * 2.0 * (double)variance)) < 0.0f ? 0.0f : (gapProbability > 1.0f ? 1.0f : gapProbability);
        this.gaps = (int)((float)(this.width * this.length) * gapProbability);
        this.maxPathLength = totalCells - this.gaps;
        if (this.maxPathLength < 2) {
            System.out.println("Error - Impossible to construct a path across a " + this.width + " by " + this.length + " field with " + this.gaps + " missing cells. Changing requirements.");
            this.maxPathLength = this.length;
            this.gaps = totalCells - this.maxPathLength;
        }
        this.xOrg = this.mazeParams.getSizeAndPosition().getXOrigin();
        this.yOrg = this.mazeParams.getSizeAndPosition().getYOrigin();
        this.zOrg = this.mazeParams.getSizeAndPosition().getZOrigin();
    }

    private Cell createStartCell() {
        int offset = this.mazeParams.getEndBlock().isFixedToEdge() ? Math.max(0, this.length - this.maxPathLength) : 0;
        int startx = this.pathrand.nextInt(this.width);
        int startz = offset + this.pathrand.nextInt(this.length - offset);
        Cell start = new Cell(startx, startz);
        if (this.mazeParams.getStartBlock().isFixedToEdge()) {
            start.z = 0;
            if (offset != 0) {
                System.out.println("Can't fix both start and end to the edges - not enough blocks available to complete the path. Changing requirements.");
                this.maxPathLength = this.length;
                this.gaps = this.width * this.length - this.maxPathLength;
            }
        }
        return start;
    }

    private Cell createEndCell(Cell start, boolean allowDiags) {
        Cell end = null;
        if (this.maxPathLength > this.length + this.width) {
            end = new Cell(start.x, start.z);
            while (end.x == start.x && end.z == start.z) {
                end = new Cell();
                if (!this.mazeParams.getEndBlock().isFixedToEdge()) continue;
                end.z = this.length - 1;
            }
        } else {
            int minx = Math.max(0, start.x - (this.maxPathLength - 1));
            int maxx = Math.min(this.width - 1, start.x + (this.maxPathLength - 1));
            int minz = Math.max(0, start.z - (this.maxPathLength - 1));
            int maxz = Math.min(this.length - 1, start.z + (this.maxPathLength - 1));
            while (end == null) {
                int x = this.pathrand.nextInt(1 + maxx - minx) + minx;
                int z = this.pathrand.nextInt(1 + maxz - minz) + minz;
                if (this.mazeParams.getEndBlock().isFixedToEdge()) {
                    z = this.length - 1;
                }
                if (this.distBetweenPoints(x, z, start.x, start.z, allowDiags) > this.maxPathLength) continue;
                end = new Cell(x, z);
            }
        }
        return end;
    }

    private void addWaypoints(Cell[] grid, Cell start, Cell end, boolean allowDiags) {
        for (int i = 0; i < this.width * this.length; ++i) {
            if (grid[i] == null) continue;
            grid[i].isVisited = false;
            grid[i].isWaypoint = false;
        }
        ArrayList<Cell> candidates = new ArrayList<Cell>();
        ArrayList<Cell> queue = new ArrayList<Cell>();
        queue.add(start);
        while (!queue.isEmpty()) {
            Cell home = (Cell)queue.remove(0);
            Cell[] neighbours = new Cell[8];
            int x = home.x;
            int z = home.z;
            this.populateNeighbours(grid, neighbours, x, z, allowDiags);
            for (int n = 0; n < 8; ++n) {
                if (neighbours[n] == null || neighbours[n].isVisited || neighbours[n] == end) continue;
                neighbours[n].isVisited = true;
                candidates.add(neighbours[n]);
                queue.add(neighbours[n]);
            }
        }
        int remaining = candidates.size();
        for (int i = 0; i < this.mazeParams.getWaypoints().getQuantity() && remaining > 0; --remaining, ++i) {
            int chosen = this.pathrand.nextInt(remaining) + i;
            Cell chosenCell = (Cell)candidates.get(chosen);
            chosenCell.isWaypoint = true;
            candidates.set(chosen, (Cell)candidates.get(i));
            candidates.set(i, chosenCell);
        }
    }

    private void buildPath(Cell[] grid, Cell start, Cell end, boolean allowDiags) {
        int[] order = new int[this.width * this.length];
        for (int i = 0; i < this.width * this.length; ++i) {
            order[i] = i;
        }
        int nextRandomSlot = 0;
        boolean refreshPath = true;
        while (this.gaps > 0 || this.gaps == 0 && refreshPath) {
            Cell targetCell = null;
            int target = -1;
            if (this.gaps > 0) {
                do {
                    int targetSlot = nextRandomSlot + this.pathrand.nextInt(this.width * this.length - nextRandomSlot);
                    target = order[targetSlot];
                    order[targetSlot] = order[nextRandomSlot];
                    order[nextRandomSlot] = target;
                    ++nextRandomSlot;
                } while ((targetCell = grid[target]) == start || targetCell == end);
                refreshPath |= targetCell.isOnOptimalPath;
                grid[target] = null;
            }
            if (refreshPath) {
                for (int i = 0; i < this.width * this.length; ++i) {
                    if (grid[i] == null) continue;
                    grid[i].dist = this.width * this.length;
                    grid[i].isOnOptimalPath = false;
                    grid[i].predecessor = null;
                }
                start.dist = 0;
                start.isOnOptimalPath = true;
                end.isOnOptimalPath = true;
                ArrayList<Cell> queue = new ArrayList<Cell>();
                queue.add(start);
                while (!queue.isEmpty() && queue.get(0) != end) {
                    Cell home = (Cell)queue.remove(0);
                    Cell[] neighbours = new Cell[8];
                    int x = home.x;
                    int z = home.z;
                    this.populateNeighbours(grid, neighbours, x, z, allowDiags);
                    for (int n = 0; n < 8; ++n) {
                        if (neighbours[n] == null || neighbours[n].dist <= home.dist + 1) continue;
                        queue.add(neighbours[n]);
                        neighbours[n].dist = home.dist + 1;
                        neighbours[n].predecessor = home;
                    }
                }
                int pathLength = end.dist + 1;
                if (pathLength <= this.maxPathLength) {
                    Cell c = end;
                    while (c != start) {
                        c.isOnOptimalPath = true;
                        c = c.predecessor;
                    }
                    --this.gaps;
                    refreshPath = false;
                    continue;
                }
                if (this.gaps <= 0) continue;
                grid[target] = targetCell;
                continue;
            }
            --this.gaps;
        }
    }

    private void populateNeighbours(Cell[] grid, Cell[] neighbours, int x, int z, boolean allowDiags) {
        neighbours[0] = x > 0 ? grid[x - 1 + z * this.width] : null;
        neighbours[1] = x < this.width - 1 ? grid[x + 1 + z * this.width] : null;
        neighbours[2] = z > 0 ? grid[x + (z - 1) * this.width] : null;
        neighbours[3] = z < this.length - 1 ? grid[x + (z + 1) * this.width] : null;
        neighbours[4] = allowDiags && x > 0 && z < this.length - 1 ? grid[x - 1 + (z + 1) * this.width] : null;
        neighbours[5] = allowDiags && x > 0 && z > 0 ? grid[x - 1 + (z - 1) * this.width] : null;
        neighbours[6] = allowDiags && x < this.width - 1 && z < this.length - 1 ? grid[x + 1 + (z + 1) * this.width] : null;
        neighbours[7] = allowDiags && x < this.width - 1 && z > 0 ? grid[x + 1 + (z - 1) * this.width] : null;
    }

    private void findSubgoals(Cell[] grid, Cell start, Cell end) {
        System.out.println("Attempting to find subgoals...");
        ArrayList<Cell> opath = new ArrayList<Cell>();
        Cell cur = end;
        while (cur != start) {
            opath.add(0, cur);
            cur = cur.predecessor;
        }
        opath.add(0, start);
        int startindex = 0;
        int removalcandidateindex = 1;
        int destindex = 2;
        if (opath.size() > 2) {
            while (destindex != opath.size()) {
                Cell smoothstart = (Cell)opath.get(startindex);
                Cell smoothremovalcandidate = (Cell)opath.get(removalcandidateindex);
                Cell smoothdest = (Cell)opath.get(destindex);
                double xa = (double)smoothstart.x + 0.5;
                double za = (double)smoothstart.z + 0.5;
                double xb = (double)smoothdest.x + 0.5;
                double zb = (double)smoothdest.z + 0.5;
                double dist = Math.sqrt((xb - xa) * (xb - xa) + (zb - za) * (zb - za));
                int samplepoints = (int)Math.ceil(dist * 5.0);
                boolean walkable = true;
                for (int sample = 0; sample < samplepoints && walkable; ++sample) {
                    int cellz;
                    double f = (double)sample / (double)samplepoints;
                    double xs = xa + (xb - xa) * f;
                    double zs = za + (zb - za) * f;
                    int cellx = (int)Math.floor(xs);
                    int cellindex = cellx + (cellz = (int)Math.floor(zs)) * this.width;
                    if (cellindex < 0 || cellindex >= grid.length || grid[cellindex] == null) {
                        walkable = false;
                    }
                    if (!walkable || this.gapHeight <= this.optimalPathHeight || this.gapBlock.getBlock().getDefaultState().equals(Blocks.AIR.getDefaultState())) continue;
                    int lowerx = (int)Math.floor(xs - 0.2);
                    int upperx = (int)Math.floor(xs + 0.2);
                    int lowerz = (int)Math.floor(zs - 0.2);
                    int upperz = (int)Math.floor(zs + 0.2);
                    int[] cellsToTest = new int[]{lowerx + lowerz * this.width, lowerx + upperz * this.width, upperx + lowerz * this.width, upperx + upperz * this.width};
                    for (int i = 0; i < 4 && walkable; ++i) {
                        int ctt = cellsToTest[i];
                        if (ctt >= 0 && ctt < grid.length && grid[ctt] != null) continue;
                        walkable = false;
                    }
                }
                if (walkable) {
                    opath.remove(removalcandidateindex);
                    continue;
                }
                startindex = removalcandidateindex;
                removalcandidateindex = startindex + 1;
                destindex = startindex + 2;
                smoothremovalcandidate.isSubgoal = true;
            }
        }
        if (this.mazeParams.getAddNavigationObservations() != null) {
            this.navigator = new ObservationFromSubgoalPositionList();
            int scale = this.mazeParams.getSizeAndPosition().getScale();
            double y = 1 + this.optimalPathHeight + this.yOrg;
            int i = 1;
            for (Cell cell : opath) {
                double x = (double)scale * ((double)cell.x + 0.5) + (double)this.xOrg;
                double z = (double)scale * ((double)cell.z + 0.5) + (double)this.zOrg;
                PointWithToleranceAndDescription ptd = new PointWithToleranceAndDescription();
                ptd.setTolerance(new BigDecimal(1.0));
                ptd.setX(new BigDecimal(x));
                ptd.setY(new BigDecimal(y));
                ptd.setZ(new BigDecimal(z));
                ptd.setDescription("MazeSubpoint_" + String.valueOf(i));
                ++i;
                this.navigator.getPoint().add(ptd);
            }
            System.out.println("Found subgoals.");
        }
    }

    private void placeBlocks(World world, Cell[] grid, Cell start, Cell end) {
        BlockDrawingHelper drawContext = new BlockDrawingHelper();
        drawContext.beginDrawing(world);
        int scale = this.mazeParams.getSizeAndPosition().getScale();
        drawContext.clearEntities(world, this.xOrg, this.yOrg, this.zOrg, this.xOrg + this.width * scale, this.yOrg + this.mazeParams.getSizeAndPosition().getHeight(), this.zOrg + this.length * scale);
        for (int x = 0; x < this.width * scale; ++x) {
            for (int z = 0; z < this.length * scale; ++z) {
                int h;
                BlockDrawingHelper.XMLBlockState bs;
                for (int y = 0; y < this.mazeParams.getSizeAndPosition().getHeight(); ++y) {
                    world.setBlockToAir(new BlockPos(x + this.xOrg, y + this.yOrg, z + this.zOrg));
                }
                BlockPos bp = new BlockPos(x + this.xOrg, this.yOrg, z + this.zOrg);
                drawContext.setBlockState(world, bp, this.floorBlock);
                Cell c = grid[x / scale + z / scale * this.width];
                BlockDrawingHelper.XMLBlockState xMLBlockState = c == null ? this.gapBlock : (bs = c.isOnOptimalPath ? this.optimalPathBlock : this.pathBlock);
                int n = c == null ? this.gapHeight : (h = c.isOnOptimalPath ? this.optimalPathHeight : this.pathHeight);
                if (c != null && c.isSubgoal) {
                    bs = this.subgoalPathBlock;
                    h = this.subgoalHeight;
                }
                if (c != null && c.isWaypoint && x % scale == scale / 2 && z % scale == scale / 2) {
                    if (this.mazeParams.getWaypoints().getWaypointBlock() != null) {
                        bs = this.waypointBlock;
                        h = this.pathHeight;
                    } else if (this.waypointItem != null) {
                        int offset = 0;
                        drawContext.placeItem(this.waypointItem.copy(), new BlockPos(x + this.xOrg + offset, this.yOrg + h + 1, z + this.zOrg + offset), world, scale % 2 == 1);
                    }
                }
                if (c != null && c == start) {
                    h = this.startHeight;
                    bs = this.startBlock;
                }
                if (c != null && c == end) {
                    h = this.endHeight;
                    bs = this.endBlock;
                }
                for (int y = 1; y <= h; ++y) {
                    BlockPos pos = new BlockPos(x + this.xOrg, y + this.yOrg, z + this.zOrg);
                    drawContext.setBlockState(world, pos, bs);
                }
            }
        }
    }

    private void recordStartAndEndPoints(Cell start, Cell end, MissionInit missionInit) {
        int scale = this.mazeParams.getSizeAndPosition().getScale();
        PosAndDirection p = new PosAndDirection();
        p.setX(new BigDecimal((double)scale * ((double)start.x + 0.5) + (double)this.xOrg));
        p.setY(new BigDecimal(1 + this.yOrg + this.startHeight));
        p.setZ(new BigDecimal((double)scale * ((double)start.z + 0.5) + (double)this.zOrg));
        this.startPosition = p;
        for (AgentSection as : missionInit.getMission().getAgentSection()) {
            p.setPitch(as.getAgentStart().getPlacement().getPitch());
            p.setYaw(as.getAgentStart().getPlacement().getYaw());
            as.getAgentStart().setPlacement(p);
        }
        if (this.mazeParams.getAddQuitProducer() != null) {
            String desc = this.mazeParams.getAddQuitProducer().getDescription();
            this.quitter = new AgentQuitFromReachingPosition();
            PointWithToleranceAndDescription endpoint = new PointWithToleranceAndDescription();
            endpoint.setDescription(desc);
            endpoint.setTolerance(new BigDecimal(0.5 + (double)scale / 2.0));
            double endX = (double)scale * ((double)end.x + 0.5) + (double)this.xOrg;
            double endY = 1 + this.optimalPathHeight + this.yOrg;
            double endZ = (double)scale * ((double)end.z + 0.5) + (double)this.zOrg;
            endpoint.setX(new BigDecimal(endX));
            endpoint.setY(new BigDecimal(endY));
            endpoint.setZ(new BigDecimal(endZ));
            this.quitter.getMarker().add(endpoint);
        }
    }

    @Override
    public void buildOnWorld(MissionInit missionInit, World world) {
        this.initRNGs();
        this.initBlocksAndHeights();
        this.initDimensions();
        boolean allowDiags = this.mazeParams.isAllowDiagonalMovement();
        Cell start = this.createStartCell();
        Cell end = this.createEndCell(start, allowDiags);
        Cell[] grid = new Cell[this.width * this.length];
        for (int i = 0; i < this.width * this.length; ++i) {
            int x = i % this.width;
            int z = i / this.width;
            grid[i] = new Cell(x, z);
        }
        grid[start.x + start.z * this.width] = start;
        grid[end.x + end.z * this.width] = end;
        this.buildPath(grid, start, end, allowDiags);
        if (this.mazeParams.getWaypoints() != null) {
            this.addWaypoints(grid, start, end, allowDiags);
        }
        this.findSubgoals(grid, start, end);
        this.placeBlocks(world, grid, start, end);
        this.recordStartAndEndPoints(start, end, missionInit);
    }

    private int getHeight(MazeBlock mblock, Random rand) {
        int h = mblock.getHeight();
        if (mblock.getHeightVariance() != 0) {
            h += rand.nextInt(2 * mblock.getHeightVariance() + 1) - mblock.getHeightVariance();
        }
        return h;
    }

    private BlockDrawingHelper.XMLBlockState getBlock(MazeBlock mblock, Random rand) {
        BlockType blockName = this.chooseBlock(mblock.getType(), rand);
        Colour blockCol = this.chooseColour(mblock.getColour(), rand);
        Variation blockVar = this.chooseVariant(mblock.getVariant(), rand);
        return new BlockDrawingHelper.XMLBlockState(blockName, blockCol, null, blockVar);
    }

    private BlockType chooseBlock(List<BlockType> types, Random r) {
        if (types == null || types.size() == 0) {
            return BlockType.AIR;
        }
        return types.get(r.nextInt(types.size()));
    }

    private Colour chooseColour(List<Colour> colours, Random r) {
        if (colours == null || colours.size() == 0) {
            return null;
        }
        return colours.get(r.nextInt(colours.size()));
    }

    private Variation chooseVariant(List<Variation> vars, Random r) {
        if (vars == null || vars.size() == 0) {
            return null;
        }
        return vars.get(r.nextInt(vars.size()));
    }

    private int distBetweenPoints(int x1, int z1, int x2, int z2, boolean bAllowDiags) {
        int w = Math.abs(x2 - x1);
        int h = Math.abs(z2 - z1);
        if (bAllowDiags) {
            if (w < h) {
                w = 0;
            } else {
                h = 0;
            }
        }
        return w + h + 1;
    }

    @Override
    public void update(World world) {
    }

    @Override
    public boolean getExtraAgentHandlersAndData(List<Object> handlers, Map<String, String> data) {
        boolean added = false;
        if (this.quitter != null) {
            handlers.add(this.quitter);
            added = true;
        }
        if (this.navigator != null) {
            handlers.add(this.navigator);
            added = true;
        }
        Float x = Float.valueOf(this.startPosition.getX().floatValue());
        Float y = Float.valueOf(this.startPosition.getY().floatValue());
        Float z = Float.valueOf(this.startPosition.getZ().floatValue());
        String posString = x.toString() + ":" + y.toString() + ":" + z.toString();
        data.put("startPosition", posString);
        return added;
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean targetedUpdate(String nextAgentName) {
        return false;
    }

    @Override
    public void getTurnParticipants(ArrayList<String> participants, ArrayList<Integer> participantSlots) {
    }

    private class Cell {
        public int x;
        public int z;
        public int dist;
        public boolean isOnOptimalPath;
        public boolean isSubgoal;
        public boolean isWaypoint;
        public boolean isVisited;
        public Cell predecessor;

        Cell() {
            this.dist = MazeDecoratorImplementation.this.width * MazeDecoratorImplementation.this.length;
            this.isOnOptimalPath = false;
            this.isSubgoal = false;
            this.isWaypoint = false;
            this.isVisited = false;
            this.predecessor = null;
            this.x = MazeDecoratorImplementation.this.pathrand.nextInt(MazeDecoratorImplementation.this.width);
            this.z = MazeDecoratorImplementation.this.pathrand.nextInt(MazeDecoratorImplementation.this.length);
        }

        Cell(int x, int z) {
            this.dist = MazeDecoratorImplementation.this.width * MazeDecoratorImplementation.this.length;
            this.isOnOptimalPath = false;
            this.isSubgoal = false;
            this.isWaypoint = false;
            this.isVisited = false;
            this.predecessor = null;
            this.x = x;
            this.z = z;
        }
    }
}

