/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IAudioProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.IVideoProducer;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWantToQuit;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldGenerator;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.ObservationFromComposite;
import com.microsoft.Malmo.MissionHandlers.QuitFromComposite;
import com.microsoft.Malmo.MissionHandlers.RewardFromTeamImplementation;
import com.microsoft.Malmo.MissionHandlers.RewardGroup;
import com.microsoft.Malmo.MissionHandlers.WorldFromComposite;
import com.microsoft.Malmo.Schemas.AgentHandlers;
import com.microsoft.Malmo.Schemas.AgentSection;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ServerHandlers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MissionBehaviour {
    public List<IVideoProducer> videoProducers = new ArrayList<IVideoProducer>();
    public IAudioProducer audioProducer = null;
    public ICommandHandler commandHandler = null;
    public IObservationProducer observationProducer = null;
    public IRewardProducer rewardProducer = null;
    public IWorldDecorator worldDecorator = null;
    public IWorldGenerator worldGenerator = null;
    public IWantToQuit quitProducer = null;
    private String failedHandlers = "";

    public static MissionBehaviour createAgentHandlersFromMissionInit(MissionInit missionInit) throws Exception {
        MissionBehaviour behaviour = new MissionBehaviour();
        behaviour.initAgent(missionInit);
        return behaviour;
    }

    public static MissionBehaviour createServerHandlersFromMissionInit(MissionInit missionInit) throws Exception {
        MissionBehaviour behaviour = new MissionBehaviour();
        behaviour.initServer(missionInit);
        return behaviour;
    }

    public String getErrorReport() {
        return this.failedHandlers;
    }

    private void reset() {
        this.videoProducers = new ArrayList<IVideoProducer>();
        this.audioProducer = null;
        this.commandHandler = null;
        this.observationProducer = null;
        this.rewardProducer = null;
        this.worldDecorator = null;
        this.quitProducer = null;
    }

    private void initAgent(MissionInit missionInit) {
        this.reset();
        AgentHandlers handlerset = missionInit.getMission().getAgentSection().get(missionInit.getClientRole()).getAgentHandlers();
        for (Object handler : handlerset.getAgentMissionHandlers()) {
            this.createAndAddHandler(handler);
        }
        List<AgentSection> agents = missionInit.getMission().getAgentSection();
        if (agents != null && agents.size() > 1) {
            this.addHandler(new RewardFromTeamImplementation());
        }
    }

    public boolean addExtraHandlers(List<Object> handlers) {
        for (Object handler : handlers) {
            this.createAndAddHandler(handler);
        }
        return true;
    }

    private void initServer(MissionInit missionInit) {
        this.reset();
        ServerHandlers handlerset = missionInit.getMission().getServerSection().getServerHandlers();
        this.createAndAddHandler(handlerset.getWorldGenerator());
        for (Object handler : handlerset.getWorldDecorators()) {
            this.createAndAddHandler(handler);
        }
        for (Object handler : handlerset.getServerQuitProducers()) {
            this.createAndAddHandler(handler);
        }
    }

    private void createAndAddHandler(Object xmlObj) {
        if (xmlObj == null) {
            return;
        }
        Object handler = this.createHandlerFromParams(xmlObj);
        if (handler != null) {
            if (handler instanceof HandlerBase) {
                ((HandlerBase)handler).setParentBehaviour(this);
            }
            this.addHandler(handler);
        }
    }

    private void addHandler(Object handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof IVideoProducer) {
            this.addVideoProducer((IVideoProducer)handler);
        } else if (handler instanceof IAudioProducer) {
            this.addAudioProducer((IAudioProducer)handler);
        } else if (handler instanceof ICommandHandler) {
            this.addCommandHandler((ICommandHandler)handler);
        } else if (handler instanceof IObservationProducer) {
            this.addObservationProducer((IObservationProducer)handler);
        } else if (handler instanceof IRewardProducer) {
            this.addRewardProducer((IRewardProducer)handler);
        } else if (handler instanceof IWorldGenerator) {
            this.addWorldGenerator((IWorldGenerator)handler);
        } else if (handler instanceof IWorldDecorator) {
            this.addWorldDecorator((IWorldDecorator)handler);
        } else if (handler instanceof IWantToQuit) {
            this.addQuitProducer((IWantToQuit)handler);
        } else {
            this.failedHandlers = this.failedHandlers + handler.getClass().getSimpleName() + " isn't of a recognised handler type.\n";
        }
    }

    private void addVideoProducer(IVideoProducer handler) {
        if (this.videoProducers.size() > 0 && (this.videoProducers.get(0).getHeight() != handler.getHeight() || this.videoProducers.get(0).getWidth() != handler.getWidth())) {
            this.failedHandlers = this.failedHandlers + "If multiple video producers are specified, they must all share the same dimensions.\n";
        } else {
            this.videoProducers.add(handler);
        }
    }

    private void addAudioProducer(IAudioProducer handler) {
        if (this.audioProducer != null) {
            this.failedHandlers = this.failedHandlers + "Too many audio producers specified - only one allowed at present.\n";
        } else {
            this.audioProducer = handler;
        }
    }

    private void addWorldGenerator(IWorldGenerator handler) {
        if (this.worldGenerator != null) {
            this.failedHandlers = this.failedHandlers + "Too many world generators specified - only one allowed.\n";
        } else {
            this.worldGenerator = handler;
        }
    }

    public void addRewardProducer(IRewardProducer handler) {
        if (this.rewardProducer == null) {
            this.rewardProducer = handler;
        } else {
            if (!(this.rewardProducer instanceof RewardGroup) || ((RewardGroup)this.rewardProducer).isFixed()) {
                RewardGroup group = new RewardGroup();
                group.addRewardProducer(this.rewardProducer);
                this.rewardProducer = group;
            }
            ((RewardGroup)this.rewardProducer).addRewardProducer(handler);
        }
    }

    public void addCommandHandler(ICommandHandler handler) {
        if (this.commandHandler == null) {
            this.commandHandler = handler;
        } else {
            if (!(this.commandHandler instanceof CommandGroup) || ((CommandGroup)this.commandHandler).isFixed()) {
                CommandGroup group = new CommandGroup();
                group.addCommandHandler(this.commandHandler);
                this.commandHandler = group;
            }
            ((CommandGroup)this.commandHandler).addCommandHandler(handler);
        }
    }

    public void addObservationProducer(IObservationProducer handler) {
        if (this.observationProducer == null) {
            this.observationProducer = handler;
        } else {
            if (!(this.observationProducer instanceof ObservationFromComposite) || ((ObservationFromComposite)this.observationProducer).isFixed()) {
                ObservationFromComposite group = new ObservationFromComposite();
                group.addObservationProducer(this.observationProducer);
                this.observationProducer = group;
            }
            ((ObservationFromComposite)this.observationProducer).addObservationProducer(handler);
        }
    }

    public void addWorldDecorator(IWorldDecorator handler) {
        if (this.worldDecorator == null) {
            this.worldDecorator = handler;
        } else {
            if (!(this.worldDecorator instanceof WorldFromComposite) || ((WorldFromComposite)this.worldDecorator).isFixed()) {
                WorldFromComposite group = new WorldFromComposite();
                group.addBuilder(this.worldDecorator);
                this.worldDecorator = group;
            }
            ((WorldFromComposite)this.worldDecorator).addBuilder(handler);
        }
    }

    public void addQuitProducer(IWantToQuit handler) {
        if (this.quitProducer == null) {
            this.quitProducer = handler;
        } else {
            if (!(this.quitProducer instanceof QuitFromComposite) || ((QuitFromComposite)this.quitProducer).isFixed()) {
                QuitFromComposite group = new QuitFromComposite();
                group.addQuitter(this.quitProducer);
                this.quitProducer = group;
            }
            ((QuitFromComposite)this.quitProducer).addQuitter(handler);
        }
    }

    private Object createHandlerFromParams(Object xmlHandler) {
        if (xmlHandler == null) {
            return null;
        }
        Object handler = null;
        String handlerClass = xmlHandler.getClass().getSimpleName();
        if (handlerClass == null || handlerClass.length() == 0) {
            return null;
        }
        try {
            Class<?> c = Class.forName("com.microsoft.Malmo.MissionHandlers." + handlerClass + "Implementation");
            handler = c.newInstance();
            if (!((HandlerBase)handler).parseParameters(xmlHandler)) {
                this.failedHandlers = this.failedHandlers + handlerClass + " failed to parse parameters.\n";
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Duff MissionHandler requested: " + handlerClass);
            this.failedHandlers = this.failedHandlers + "Failed to find " + handlerClass + "\n";
        }
        catch (InstantiationException e) {
            System.out.println("Could not instantiate specified MissionHandler.");
            this.failedHandlers = this.failedHandlers + "Failed to create " + handlerClass + "\n";
        }
        catch (IllegalAccessException e) {
            System.out.println("Could not instantiate specified MissionHandler.");
            this.failedHandlers = this.failedHandlers + "Failed to access " + handlerClass + "\n";
        }
        return handler;
    }

    public void appendExtraServerInformation(HashMap<String, String> map) {
        List<HandlerBase> handlers = this.getClientHandlerList();
        for (HandlerBase handler : handlers) {
            handler.appendExtraServerInformation(map);
        }
    }

    protected List<HandlerBase> getClientHandlerList() {
        ArrayList<HandlerBase> handlers = new ArrayList<HandlerBase>();
        for (IVideoProducer vp : this.videoProducers) {
            if (vp == null || !(vp instanceof HandlerBase)) continue;
            handlers.add((HandlerBase)((Object)vp));
        }
        if (this.audioProducer != null && this.audioProducer instanceof HandlerBase) {
            handlers.add((HandlerBase)((Object)this.audioProducer));
        }
        if (this.commandHandler != null && this.commandHandler instanceof HandlerBase) {
            handlers.add((HandlerBase)((Object)this.commandHandler));
        }
        if (this.observationProducer != null && this.observationProducer instanceof HandlerBase) {
            handlers.add((HandlerBase)((Object)this.observationProducer));
        }
        if (this.rewardProducer != null && this.rewardProducer instanceof HandlerBase) {
            handlers.add((HandlerBase)((Object)this.rewardProducer));
        }
        if (this.quitProducer != null && this.quitProducer instanceof HandlerBase) {
            handlers.add((HandlerBase)((Object)this.quitProducer));
        }
        return handlers;
    }
}

