/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IWorldDecorator;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.NavigationDecorator;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NavigationDecoratorImplementation
extends HandlerBase
implements IWorldDecorator {
    private NavigationDecorator nparams;
    private double originX;
    private double originY;
    private double originZ;
    private double placementX;
    private double placementY;
    private double placementZ;
    private double radius;
    private double minDist;
    private double maxDist;
    private double minRad;
    private double maxRad;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof NavigationDecorator)) {
            return false;
        }
        this.nparams = (NavigationDecorator)params;
        return true;
    }

    @Override
    public void buildOnWorld(MissionInit missionInit, World world) throws IWorldDecorator.DecoratorException {
        this.originX = this.nparams.getRandomPlacementProperties().getOrigin() != null ? this.nparams.getRandomPlacementProperties().getOrigin().getX().doubleValue() : (double)world.getSpawnPoint().getX();
        this.originY = this.nparams.getRandomPlacementProperties().getOrigin() != null ? this.nparams.getRandomPlacementProperties().getOrigin().getY().doubleValue() : (double)world.getSpawnPoint().getY();
        this.originZ = this.nparams.getRandomPlacementProperties().getOrigin() != null ? this.nparams.getRandomPlacementProperties().getOrigin().getZ().doubleValue() : (double)world.getSpawnPoint().getZ();
        this.maxRad = this.nparams.getRandomPlacementProperties().getMaxRandomizedRadius().doubleValue();
        this.minRad = this.nparams.getRandomPlacementProperties().getMinRandomizedRadius().doubleValue();
        this.radius = (int)(Math.random() * (this.maxRad - this.minRad) + this.minRad);
        this.minDist = this.nparams.getMinRandomizedDistance().doubleValue();
        this.maxDist = this.nparams.getMaxRandomizedDistance().doubleValue();
        this.placementX = 0.0;
        this.placementY = 0.0;
        this.placementZ = 0.0;
        if (this.nparams.getRandomPlacementProperties().getPlacement().equals("surface")) {
            this.placementX = (Math.random() - 0.5) * 2.0 * this.radius;
            this.placementZ = (double)(Math.random() > 0.5 ? -1 : 1) * Math.sqrt(this.radius * this.radius - this.placementX * this.placementX);
            this.placementX += this.originX;
            this.placementZ += this.originZ;
            this.placementY = world.getTopSolidOrLiquidBlock(new BlockPos(this.placementX, 0.0, this.placementZ)).getY() - 1;
        } else if (this.nparams.getRandomPlacementProperties().getPlacement().equals("fixed_surface")) {
            this.placementX = -0.16000000000000003 * this.radius;
            this.placementZ = 1.0 * Math.sqrt(this.radius * this.radius - this.placementX * this.placementX);
            this.placementX += this.originX;
            this.placementZ += this.originZ;
            this.placementY = world.getTopSolidOrLiquidBlock(new BlockPos(this.placementX, 0.0, this.placementZ)).getY() - 1;
        } else if (this.nparams.getRandomPlacementProperties().getPlacement().equals("circle")) {
            this.placementX = (Math.random() - 0.5) * 2.0 * this.radius;
            this.placementY = this.originY;
            this.placementZ = (double)(Math.random() > 0.5 ? -1 : 1) * Math.sqrt(this.radius * this.radius - this.placementX * this.placementX);
            this.placementX += this.originX;
            this.placementZ += this.originZ;
        } else {
            this.placementX = (Math.random() - 0.5) * 2.0 * this.radius;
            this.placementY = (Math.random() - 0.5) * 2.0 * Math.sqrt(this.radius * this.radius - this.placementX * this.placementX);
            this.placementZ = (double)(Math.random() > 0.5 ? -1 : 1) * Math.sqrt(this.radius * this.radius - this.placementX * this.placementX - this.placementY * this.placementY);
            this.placementX += this.originX;
            this.placementY += this.originY;
            this.placementZ += this.originZ;
        }
        IBlockState state = MinecraftTypeHelper.ParseBlockType(this.nparams.getRandomPlacementProperties().getBlock().value());
        world.setBlockState(new BlockPos(this.placementX, this.placementY, this.placementZ), state);
        double xDel = 0.0;
        double zDel = 0.0;
        if (this.nparams.isRandomizeCompassLocation()) {
            double dist = 0.0;
            while ((dist = Math.sqrt((xDel = (Math.random() - 0.5) * 2.0 * this.maxDist) * xDel + (zDel = (Math.random() - 0.5) * 2.0 * this.maxDist) * zDel)) <= this.maxDist && dist >= this.minDist) {
            }
        }
        this.placementX += xDel;
        this.placementZ += zDel;
    }

    @Override
    public boolean getExtraAgentHandlersAndData(List<Object> handlers, Map<String, String> data) {
        return false;
    }

    @Override
    public void update(World world) {
        BlockPos spawn;
        if (Minecraft.getMinecraft().player != null && (spawn = Minecraft.getMinecraft().player.world.getSpawnPoint()).getX() != (int)this.placementX && spawn.getY() != (int)this.placementY && spawn.getZ() != (int)this.placementZ) {
            Minecraft.getMinecraft().player.world.setSpawnPoint(new BlockPos(this.placementX, this.placementY, this.placementZ));
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean targetedUpdate(String nextAgentName) {
        return false;
    }

    @Override
    public void getTurnParticipants(ArrayList<String> participants, ArrayList<Integer> participantSlots) {
    }
}

