/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlers.CommandBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.NearbyCraftCommands;
import com.microsoft.Malmo.Utils.CraftingHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NearbyCraftCommandsImplementation
extends CommandBase {
    private boolean isOverriding;
    private static ArrayList<BlockPos> craftingTables;

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (!event.isCanceled() && event.getPlacedBlock().getBlock() instanceof BlockWorkbench) {
            craftingTables.add(event.getPos());
        }
    }

    @SubscribeEvent
    public void onBlockDestroy(BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && event.getState().getBlock() instanceof BlockWorkbench) {
            for (int i = craftingTables.size() - 1; i >= 0; --i) {
                if (!craftingTables.get(i).equals((Object)event.getPos())) continue;
                craftingTables.remove(i);
            }
        }
    }

    @Override
    protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
        if (verb.equalsIgnoreCase("nearbyCraft") && !parameter.equalsIgnoreCase("none   ")) {
            MalmoMod.network.sendToServer((IMessage)new CraftNearbyMessage(parameter));
            return true;
        }
        return false;
    }

    @Override
    public boolean parseParameters(Object params) {
        if (!(params instanceof NearbyCraftCommands)) {
            return false;
        }
        craftingTables = new ArrayList();
        NearbyCraftCommands cParams = (NearbyCraftCommands)params;
        this.setUpAllowAndDenyLists(cParams.getModifierList());
        return true;
    }

    @Override
    public void install(MissionInit missionInit) {
        CraftingHelper.reset();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void deinstall(MissionInit missionInit) {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public boolean isOverriding() {
        return this.isOverriding;
    }

    @Override
    public void setOverriding(boolean b) {
        this.isOverriding = b;
    }

    public static class CraftNearbyMessageHandler
    implements IMessageHandler<CraftNearbyMessage, IMessage> {
        public IMessage onMessage(CraftNearbyMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            Vec3d headPos = new Vec3d(player.posX, player.posY + 1.6, player.posZ);
            boolean closeTable = false;
            for (BlockPos furnace : craftingTables) {
                Vec3d toBlock;
                Vec3d blockVec = new Vec3d((double)furnace.getX() + 0.5, (double)furnace.getY() + 0.5, (double)furnace.getZ() + 0.5);
                if (!(headPos.squareDistanceTo(blockVec) <= 25.0)) continue;
                double fov = Minecraft.getMinecraft().gameSettings.fovSetting;
                double height = Minecraft.getMinecraft().displayHeight;
                double width = Minecraft.getMinecraft().displayWidth;
                Vec3d lookVec = player.getLookVec();
                double scalarProjection = lookVec.dotProduct(toBlock = blockVec.subtract(headPos)) / lookVec.lengthVector();
                if (!(scalarProjection > 0.0)) continue;
                Vec3d yUnit = new Vec3d(0.0, 1.0, 0.0);
                Vec3d lookCross = lookVec.crossProduct(yUnit);
                Vec3d blockProjectedOntoCross = lookCross.scale(lookCross.dotProduct(toBlock) / lookCross.lengthVector());
                Vec3d blockProjectedOntoPlayerPlane = toBlock.subtract(blockProjectedOntoCross);
                double xyDot = lookVec.dotProduct(blockProjectedOntoPlayerPlane);
                double pitchTheta = Math.acos(xyDot / (lookVec.lengthVector() * blockProjectedOntoPlayerPlane.lengthVector()));
                Vec3d playerY = lookCross.crossProduct(lookVec);
                Vec3d blockProjectedOntoPlayerY = playerY.scale(playerY.dotProduct(toBlock) / playerY.lengthVector());
                Vec3d blockProjectedOntoYawPlane = toBlock.subtract(blockProjectedOntoPlayerY);
                double xzDot = lookVec.dotProduct(blockProjectedOntoYawPlane);
                double yawTheta = Math.acos(xzDot / (lookVec.lengthVector() * blockProjectedOntoYawPlane.lengthVector()));
                if (!(Math.abs(Math.toDegrees(yawTheta)) <= Math.min(1.0, width / height) * (fov / 2.0)) || !(Math.abs(Math.toDegrees(pitchTheta)) <= Math.min(1.0, height / width) * (fov / 2.0))) continue;
                closeTable = true;
            }
            if (closeTable) {
                String[] split = message.parameters.split(" ");
                List<IRecipe> matching_recipes = split.length > 1 ? CraftingHelper.getRecipesForRequestedOutput(message.parameters, true) : CraftingHelper.getRecipesForRequestedOutput(message.parameters, false);
                for (IRecipe recipe : matching_recipes) {
                    if (!CraftingHelper.attemptCrafting(player, recipe)) continue;
                    return null;
                }
            }
            return null;
        }
    }

    public static class CraftNearbyMessage
    implements IMessage {
        String parameters;

        public CraftNearbyMessage() {
        }

        public CraftNearbyMessage(String parameters) {
            this.parameters = parameters;
        }

        public void fromBytes(ByteBuf buf) {
            this.parameters = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.parameters);
        }
    }
}

