/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.Client.MalmoModClient;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.CommandForKey;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.HumanLevelCommandsImplementation;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MouseHelper;

public class ObservationFromHumanImplementation
extends HandlerBase
implements IObservationProducer {
    MouseObserver observer = new MouseObserver();
    List<ObservationEvent> events = new ArrayList<ObservationEvent>();
    List<CommandForKey> keys = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        List<ObservationEvent> list = this.events;
        synchronized (list) {
            if (this.events.size() > 0) {
                JsonArray jsonEvents = new JsonArray();
                for (ObservationEvent event : this.events) {
                    jsonEvents.add((JsonElement)event.getJSON());
                }
                this.events.clear();
                json.add("events", (JsonElement)jsonEvents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(ObservationEvent event) {
        List<ObservationEvent> list = this.events;
        synchronized (list) {
            this.events.add(event);
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        MouseHelper mhelp = Minecraft.getMinecraft().mouseHelper;
        if (!(mhelp instanceof MalmoModClient.MouseHook)) {
            System.out.println("ERROR! MouseHook not installed - Malmo won't work correctly.");
            return;
        }
        ((MalmoModClient.MouseHook)mhelp).requestEvents(this.observer);
        this.keys = HumanLevelCommandsImplementation.getKeyOverrides();
        for (CommandForKey k : this.keys) {
            k.install(missionInit);
            k.setKeyEventObserver(this.observer);
        }
    }

    @Override
    public void cleanup() {
        MouseHelper mhelp = Minecraft.getMinecraft().mouseHelper;
        if (!(mhelp instanceof MalmoModClient.MouseHook)) {
            System.out.println("ERROR! MouseHook not installed - Malmo won't work correctly.");
            return;
        }
        ((MalmoModClient.MouseHook)mhelp).requestEvents(null);
        for (CommandForKey k : this.keys) {
            k.setKeyEventObserver(null);
        }
    }

    private class MouseObserver
    implements MalmoModClient.MouseEventListener,
    CommandForKey.KeyEventListener {
        private MouseObserver() {
        }

        @Override
        public void onXYZChange(int deltaX, int deltaY, int deltaZ) {
            System.out.println("Mouse observed: " + deltaX + ", " + deltaY + ", " + deltaZ);
            if (deltaX != 0 || deltaY != 0 || deltaZ != 0) {
                ObservationFromHumanImplementation.this.queueEvent(new MouseObservationEvent(deltaX, deltaY, deltaZ));
            }
        }

        @Override
        public void onKeyChange(String commandString, boolean pressed) {
            ObservationFromHumanImplementation.this.queueEvent(new KeyObservationEvent(commandString, pressed));
        }
    }

    private class KeyObservationEvent
    extends ObservationEvent {
        private String commandString;
        private boolean pressed;

        KeyObservationEvent(String commandString, boolean pressed) {
            this.commandString = commandString;
            this.pressed = pressed;
        }

        @Override
        public JsonObject getJSON() {
            JsonObject jsonEvent = new JsonObject();
            jsonEvent.addProperty("time", (Number)this.timestamp);
            jsonEvent.addProperty("type", "key");
            jsonEvent.addProperty("command", this.commandString);
            jsonEvent.addProperty("pressed", Boolean.valueOf(this.pressed));
            return jsonEvent;
        }
    }

    private class MouseObservationEvent
    extends ObservationEvent {
        private int deltaX;
        private int deltaY;
        private int deltaZ;

        public MouseObservationEvent(int deltaX, int deltaY, int deltaZ) {
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.deltaZ = deltaZ;
        }

        @Override
        public JsonObject getJSON() {
            JsonObject jsonEvent = new JsonObject();
            jsonEvent.addProperty("time", (Number)this.timestamp);
            jsonEvent.addProperty("type", "mouse");
            jsonEvent.addProperty("deltaX", (Number)this.deltaX);
            jsonEvent.addProperty("deltaY", (Number)this.deltaY);
            jsonEvent.addProperty("deltaZ", (Number)this.deltaZ);
            return jsonEvent;
        }
    }

    private abstract class ObservationEvent {
        public long timestamp = 0L;

        public abstract JsonObject getJSON();

        ObservationEvent() {
            this.timestamp = Minecraft.getMinecraft().world.getWorldTime();
        }
    }
}

