/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.DrawBlock;
import com.microsoft.Malmo.Schemas.DrawItem;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromRay;
import com.microsoft.Malmo.Utils.MinecraftTypeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class ObservationFromRayImplementation
extends HandlerBase
implements IObservationProducer {
    private ObservationFromRay ofrparams;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromRay)) {
            return false;
        }
        this.ofrparams = (ObservationFromRay)params;
        return true;
    }

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        ObservationFromRayImplementation.buildMouseOverData(json, this.ofrparams.isIncludeNBT());
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    public static void buildMouseOverData(JsonObject json, boolean includeNBTData) {
        Vec3d searchVec;
        RayTraceResult mop;
        Vec3d lookVec;
        float partialTicks = 0.0f;
        EntityPlayerSP viewer = Minecraft.getMinecraft().player;
        float depth = 50.0f;
        Vec3d eyePos = viewer.getPositionEyes(partialTicks);
        RayTraceResult mopEnt = ObservationFromRayImplementation.findEntity(eyePos, lookVec = viewer.getLook(partialTicks), depth, mop = Minecraft.getMinecraft().world.rayTraceBlocks(eyePos, searchVec = eyePos.addVector(lookVec.xCoord * (double)depth, lookVec.yCoord * (double)depth, lookVec.zCoord * (double)depth), false, false, false), true);
        if (mopEnt != null) {
            mop = mopEnt;
        }
        if (mop == null) {
            return;
        }
        double hitDist = mop.hitVec.distanceTo(eyePos);
        double blockReach = Minecraft.getMinecraft().playerController.getBlockReachDistance();
        double entityReach = Minecraft.getMinecraft().playerController.extendedReach() ? 6.0 : 3.0;
        JsonObject jsonMop = new JsonObject();
        if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
            NBTTagCompound data;
            TileEntity tileentity;
            jsonMop.addProperty("hitType", "block");
            jsonMop.addProperty("x", (Number)mop.hitVec.xCoord);
            jsonMop.addProperty("y", (Number)mop.hitVec.yCoord);
            jsonMop.addProperty("z", (Number)mop.hitVec.zCoord);
            IBlockState state = Minecraft.getMinecraft().world.getBlockState(mop.getBlockPos());
            ArrayList<IProperty> extraProperties = new ArrayList<IProperty>();
            DrawBlock db = MinecraftTypeHelper.getDrawBlockFromBlockState(state, extraProperties);
            jsonMop.addProperty("type", db.getType().value());
            if (db.getColour() != null) {
                jsonMop.addProperty("colour", db.getColour().value());
            }
            if (db.getVariant() != null) {
                jsonMop.addProperty("variant", db.getVariant().getValue());
            }
            if (db.getFace() != null) {
                jsonMop.addProperty("facing", db.getFace().value());
            }
            if (extraProperties.size() > 0) {
                for (IProperty prop : extraProperties) {
                    String key = "prop_" + prop.getName();
                    if (prop.getValueClass() == Boolean.class) {
                        jsonMop.addProperty(key, Boolean.valueOf(state.getValue(prop).toString()));
                        continue;
                    }
                    if (prop.getValueClass() == Integer.class) {
                        jsonMop.addProperty(key, (Number)Integer.valueOf(state.getValue(prop).toString()));
                        continue;
                    }
                    jsonMop.addProperty(key, state.getValue(prop).toString());
                }
            }
            if (includeNBTData && (tileentity = Minecraft.getMinecraft().world.getTileEntity(mop.getBlockPos())) != null && (data = tileentity.getUpdateTag()) != null) {
                String jsonString = data.toString();
                try {
                    JsonElement jelement = new JsonParser().parse(jsonString);
                    if (jelement != null) {
                        jsonMop.add("NBTTagCompound", jelement);
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            jsonMop.addProperty("inRange", Boolean.valueOf(hitDist <= blockReach));
            jsonMop.addProperty("distance", (Number)hitDist);
        } else if (mop.typeOfHit == RayTraceResult.Type.ENTITY) {
            Entity entity = mop.entityHit;
            if (entity != null) {
                jsonMop.addProperty("x", (Number)entity.posX);
                jsonMop.addProperty("y", (Number)entity.posY);
                jsonMop.addProperty("z", (Number)entity.posZ);
                jsonMop.addProperty("yaw", (Number)Float.valueOf(entity.rotationYaw));
                jsonMop.addProperty("pitch", (Number)Float.valueOf(entity.rotationPitch));
                String name = MinecraftTypeHelper.getUnlocalisedEntityName(entity);
                String hitType = "entity";
                if (entity instanceof EntityItem) {
                    ItemStack is = ((EntityItem)entity).getEntityItem();
                    DrawItem di = MinecraftTypeHelper.getDrawItemFromItemStack(is);
                    if (di.getColour() != null) {
                        jsonMop.addProperty("colour", di.getColour().value());
                    }
                    if (di.getVariant() != null) {
                        jsonMop.addProperty("variant", di.getVariant().getValue());
                    }
                    jsonMop.addProperty("stackSize", (Number)is.getCount());
                    name = di.getType();
                    hitType = "item";
                }
                jsonMop.addProperty("type", name);
                jsonMop.addProperty("hitType", hitType);
            }
            jsonMop.addProperty("inRange", Boolean.valueOf(hitDist <= entityReach));
            jsonMop.addProperty("distance", (Number)hitDist);
        }
        json.add("LineOfSight", (JsonElement)jsonMop);
    }

    static RayTraceResult findEntity(Vec3d eyePos, Vec3d lookVec, double depth, RayTraceResult mop, boolean includeTiles) {
        if (mop != null) {
            depth = mop.hitVec.distanceTo(eyePos);
        }
        Vec3d searchVec = eyePos.addVector(lookVec.xCoord * depth, lookVec.yCoord * depth, lookVec.zCoord * depth);
        Entity pointedEntity = null;
        Vec3d hitVec = null;
        EntityPlayerSP viewer = Minecraft.getMinecraft().player;
        List list = Minecraft.getMinecraft().world.getEntitiesWithinAABBExcludingEntity((Entity)viewer, viewer.getEntityBoundingBox().addCoord(lookVec.xCoord * depth, lookVec.yCoord * depth, lookVec.zCoord * depth).expand(1.0, 1.0, 1.0));
        double distance = depth;
        for (int i = 0; i < list.size(); ++i) {
            double distToEnt;
            Entity entity = (Entity)list.get(i);
            if (!entity.canBeCollidedWith() && !includeTiles) continue;
            float border = entity.getCollisionBorderSize();
            AxisAlignedBB axisalignedbb = entity.getEntityBoundingBox().expand((double)border, (double)border, (double)border);
            RayTraceResult movingobjectposition = axisalignedbb.calculateIntercept(eyePos, searchVec);
            if (axisalignedbb.isVecInside(eyePos)) {
                if (!(distance >= 0.0)) continue;
                pointedEntity = entity;
                hitVec = movingobjectposition == null ? eyePos : mop.hitVec;
                distance = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((distToEnt = eyePos.distanceTo(movingobjectposition.hitVec)) < distance) && distance != 0.0) continue;
            if (entity == entity.getRidingEntity() && !entity.canRiderInteract()) {
                if (distance != 0.0) continue;
                pointedEntity = entity;
                hitVec = movingobjectposition.hitVec;
                continue;
            }
            pointedEntity = entity;
            hitVec = movingobjectposition.hitVec;
            distance = distToEnt;
        }
        if (pointedEntity != null && (distance < depth || mop == null)) {
            RayTraceResult newMop = new RayTraceResult(pointedEntity, hitVec);
            return newMop;
        }
        return null;
    }
}

