/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.Malmo.MissionHandlerInterfaces.ICommandHandler;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.CommandGroup;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.MissionHandlers.MissionBehaviour;
import com.microsoft.Malmo.Schemas.MissionInit;
import java.util.ArrayList;
import java.util.List;

public class ObservationFromRecentCommandsImplementation
extends HandlerBase
implements IObservationProducer {
    private boolean hookedIntoCommandChain = false;
    private List<String> recentCommandList = new ArrayList<String>();

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        if (!this.hookedIntoCommandChain) {
            MissionBehaviour mb = this.parentBehaviour();
            ICommandHandler oldch = mb.commandHandler;
            CommandGroup newch = new CommandGroup(){

                @Override
                protected boolean onExecute(String verb, String parameter, MissionInit missionInit) {
                    boolean handled = super.onExecute(verb, parameter, missionInit);
                    if (handled) {
                        ObservationFromRecentCommandsImplementation.this.addHandledCommand(verb, parameter);
                    }
                    return handled;
                }
            };
            newch.setOverriding(oldch != null ? oldch.isOverriding() : true);
            if (oldch != null) {
                newch.addCommandHandler(oldch);
            }
            mb.commandHandler = newch;
            this.hookedIntoCommandChain = true;
        }
        List<String> list = this.recentCommandList;
        synchronized (list) {
            if (this.recentCommandList.size() != 0) {
                JsonArray commands = new JsonArray();
                for (String s : this.recentCommandList) {
                    commands.add((JsonElement)new JsonPrimitive(s));
                }
                json.add("CommandsSinceLastObservation", (JsonElement)commands);
            }
            this.recentCommandList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHandledCommand(String verb, String parameter) {
        List<String> list = this.recentCommandList;
        synchronized (list) {
            this.recentCommandList.add(verb + " " + parameter);
        }
    }
}

