/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.MissionHandlerInterfaces.IObservationProducer;
import com.microsoft.Malmo.MissionHandlers.HandlerBase;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromSubgoalPositionList;
import com.microsoft.Malmo.Schemas.PointWithToleranceAndDescription;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public class ObservationFromSubgoalPositionListImplementation
extends HandlerBase
implements IObservationProducer {
    private int subgoalIndex = 0;
    private ObservationFromSubgoalPositionList positions;

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof ObservationFromSubgoalPositionList)) {
            return false;
        }
        this.positions = (ObservationFromSubgoalPositionList)params;
        return true;
    }

    @Override
    public void writeObservationsToJSON(JsonObject json, MissionInit missionInit) {
        double difference;
        int nTargets = this.positions.getPoint().size();
        boolean foundNextPoint = false;
        double targetx = 0.0;
        double targetz = 0.0;
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        if (player == null) {
            return;
        }
        double sourcex = player.posX;
        double sourcez = player.posZ;
        while (this.subgoalIndex < nTargets && !foundNextPoint) {
            targetx = this.positions.getPoint().get(this.subgoalIndex).getX().doubleValue();
            targetz = this.positions.getPoint().get(this.subgoalIndex).getZ().doubleValue();
            double tol = this.positions.getPoint().get(this.subgoalIndex).getTolerance().doubleValue();
            if (Math.abs(targetx - sourcex) + Math.abs(targetz - sourcez) < tol) {
                ++this.subgoalIndex;
                continue;
            }
            foundNextPoint = true;
        }
        if (!foundNextPoint) {
            return;
        }
        double dx = targetx - sourcex;
        double dz = targetz - sourcez;
        double targetYaw = Math.atan2(dz, dx) * 180.0 / Math.PI - 90.0;
        double sourceYaw = player.rotationYaw;
        for (difference = targetYaw - sourceYaw; difference < -180.0; difference += 360.0) {
        }
        while (difference > 180.0) {
            difference -= 360.0;
        }
        json.addProperty("yawDelta", (Number)(difference /= 180.0));
        PointWithToleranceAndDescription point = this.positions.getPoint().get(this.subgoalIndex);
        JsonObject pointElement = new JsonObject();
        pointElement.addProperty("XPos", (Number)point.getX().doubleValue());
        pointElement.addProperty("YPos", (Number)point.getY().doubleValue());
        pointElement.addProperty("ZPos", (Number)point.getZ().doubleValue());
        pointElement.addProperty("description", point.getDescription());
        json.add("nextSubgoal", (JsonElement)pointElement);
    }

    @Override
    public void prepare(MissionInit missionInit) {
    }

    @Override
    public void cleanup() {
    }
}

