/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MalmoMod;
import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardForItemBase;
import com.microsoft.Malmo.Schemas.BlockOrItemSpecWithReward;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.RewardForCollectingItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class RewardForCollectingItemImplementation
extends RewardForItemBase
implements IRewardProducer,
MalmoMod.IMalmoMessageListener {
    private RewardForCollectingItem params;

    @Override
    public void onMessage(MalmoMod.MalmoMessageType messageType, Map<String, String> data) {
        String bufstring = data.get("message");
        ByteBuf buf = Unpooled.copiedBuffer((byte[])DatatypeConverter.parseBase64Binary((String)bufstring));
        ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        if (itemStack != null && itemStack.getItem() != null) {
            this.accumulateReward(this.params.getDimension(), itemStack);
        } else {
            System.out.println("Error - couldn't understand the itemstack we received.");
        }
    }

    @Override
    public boolean parseParameters(Object params) {
        if (params == null || !(params instanceof RewardForCollectingItem)) {
            return false;
        }
        this.params = (RewardForCollectingItem)params;
        for (BlockOrItemSpecWithReward is : this.params.getItem()) {
            this.addItemSpecToRewardStructure(is);
        }
        return true;
    }

    @SubscribeEvent
    public void onGainItem(GainItemEvent event) {
        if (event.stack != null) {
            this.accumulateReward(this.params.getDimension(), event.stack);
        }
    }

    @SubscribeEvent
    public void onPickupItem(EntityItemPickupEvent event) {
        if (event.getItem() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            RewardForCollectingItemImplementation.sendItemStackToClient((EntityPlayerMP)event.getEntityPlayer(), MalmoMod.MalmoMessageType.SERVER_COLLECTITEM, event.getItem().getEntityItem());
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalmoMod.MalmoMessageHandler.registerForMessage(this, MalmoMod.MalmoMessageType.SERVER_COLLECTITEM);
    }

    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        MalmoMod.MalmoMessageHandler.deregisterForMessage(this, MalmoMod.MalmoMessageType.SERVER_COLLECTITEM);
    }

    public static class GainItemEvent
    extends Event {
        public final ItemStack stack;
        public int cause = 0;

        public GainItemEvent(ItemStack stack) {
            this.stack = stack;
        }

        public void setCause(int cause) {
            this.cause = cause;
        }
    }
}

