/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.MissionHandlers;

import com.microsoft.Malmo.MissionHandlerInterfaces.IRewardProducer;
import com.microsoft.Malmo.MissionHandlers.MultidimensionalReward;
import com.microsoft.Malmo.MissionHandlers.RewardBase;
import com.microsoft.Malmo.Schemas.EntityTypes;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.MobWithReward;
import com.microsoft.Malmo.Schemas.RewardForDamagingEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RewardForDamagingEntityImplementation
extends RewardBase
implements IRewardProducer {
    RewardForDamagingEntity params;
    Map<MobWithReward, Float> damages = new HashMap<MobWithReward, Float>();

    @Override
    public boolean parseParameters(Object params) {
        super.parseParameters(params);
        if (params == null || !(params instanceof RewardForDamagingEntity)) {
            return false;
        }
        this.params = (RewardForDamagingEntity)params;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getReward(MissionInit missionInit, MultidimensionalReward reward) {
        super.getReward(missionInit, reward);
        if (missionInit == null || Minecraft.getMinecraft().player == null) {
            return;
        }
        Map<MobWithReward, Float> map = this.damages;
        synchronized (map) {
            for (MobWithReward mob : this.damages.keySet()) {
                float damage_amount = this.damages.get(mob).floatValue();
                float damage_reward = damage_amount * mob.getReward().floatValue();
                float adjusted_reward = this.adjustAndDistributeReward(damage_reward, this.params.getDimension(), mob.getDistribution());
                reward.add(this.params.getDimension(), adjusted_reward);
            }
            this.damages.clear();
        }
    }

    @Override
    public void prepare(MissionInit missionInit) {
        super.prepare(missionInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity() == null || event.getSource().getEntity() != Minecraft.getMinecraft().player) {
            return;
        }
        Map<MobWithReward, Float> map = this.damages;
        synchronized (map) {
            for (MobWithReward mob : this.params.getMob()) {
                for (EntityTypes et : mob.getType()) {
                    String mobName = et.value();
                    if (!event.getEntity().getName().equals(mobName)) continue;
                    if (this.damages.containsKey(mob)) {
                        this.damages.put(mob, Float.valueOf(this.damages.get(mob).floatValue() + event.getAmount()));
                        continue;
                    }
                    this.damages.put(mob, Float.valueOf(event.getAmount()));
                }
            }
        }
    }
}

